/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

$(function () {
    'use strict';

    function uploadInit(element, url) {
        
            element.fileupload({
                dropZone: element.parents('.galleryimage-dropzone'),
                url: url,
                dataType: 'json',
                autoUpload: true,
                acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i,
                maxFileSize: 2000000,
                maxNumberOfFiles: 21,
                getNumberOfFiles: function () {
                    return this.dropZone.parents('.fl-galleryimage-submission').find('.fl-files .fl-sort-images').length - 1;
                },
                disableImageResize: /Android(?!.*Chrome)|Opera/
                    .test(window.navigator.userAgent),
                previewMaxWidth: 175,
                previewMaxHeight: 110,
                previewCrop: true,
                formData: {id: userId, elementId}
            }).on('fileuploadadd', function (e, data) {
                data.context = $('<li class="fl-sort-images uk-grid-margin uk-text-center"/>').appendTo($(this).parents('.fl-galleryimage').find('.fl-files'));
                $.each(data.files, function (index, file) {
                    var node = $('<div/>')
                            .append($('<p class="uk-text-small uk-text-truncate uk-margin-small-top uk-margin-small-bottom"/>').html('<i class="fl-galleryimage-load-icon uk-icon-spinner uk-icon-spin"></i> ' + file.name));
                    node.appendTo(data.context);
                });
            }).on('fileuploadprocessalways', function (e, data) {
                var index = data.index,
                    file = data.files[index],
                    node = $(data.context.children()[index]);
                if (file.preview) {
                    var canvas = data.files[0].preview;
                    var newImg = document.createElement("img");
                    newImg.src = canvas.toDataURL();
                    node.prepend(newImg);
                }
                if (file.error) {
                    $(this).parents('.fl-galleryimage').find('.fl-alert').removeClass('uk-hidden').append('<p class="uk-text-small uk-text-break">Файл <b>' + file.name + '</b> не загружен. Причина: ' + file.error + '.</p>');
                    node.closest('.fl-sort-images').remove();
                }
                if (index + 1 === data.files.length) {
                    data.context.find('button')
                        .text('Upload')
                        .prop('disabled', !!data.files.error);
                }
            }).on('fileuploadprogressall', function (e, data) {
                var progress = parseInt(data.loaded / data.total * 100, 10);

                $(this).parents('.fl-galleryimage').find('.uk-progress').removeClass('hidden').find('.uk-progress-bar').css(
                    'width',
                    progress + '%'
                );

                if (progress != 100) {
                    $('#fl-submit-button').prop('disabled', true);
                } else {
                    $('#fl-submit-button').prop('disabled', false);
                }
                
            }).on('fileuploaddone', function (e, data) {
                if (!$('.fl-galleryimage-submission .fl-files').hasClass('uk-margin-top')) {
                    $('.fl-galleryimage-submission .fl-files').addClass('uk-margin-top');
                };
                var flgalleryimageSubmission = $(this).parents('.fl-galleryimage-submission');
                var flgalleryimage = $(this).parents('.fl-galleryimage');
                $.each(data.result.files, function (index, file) {
                    if (file.url) {

                        var count = flgalleryimage.find('.fl-files li').length;

                        $( ".fl-galleryimage-fileupload" ).rules( "add", {
                            galleryimage: count
                        });
                        $('.fl-galleryimage-fileupload').valid();
                        
                        // Количество загруженных изображений
                        var imagesCount = parseInt(flgalleryimageSubmission.attr('fl-galleryimage-images'));

                        // ID элемента
                        var elementId = $('.fl-galleryimage-submission').attr('fl-element-id');

                        var link = $('<div class="fl-galleryimage-thumb uk-text-success uk-text-center">');
                        $(data.context.children()[index])
                            .wrap(link)
                            .find('.fl-galleryimage-load-icon').removeClass('uk-icon-spinner uk-icon-spin')
                            .addClass('uk-icon-check-circle-o');
                        $(data.context.children()[index]).append('<a data-name="' + file.name + '" class="fl-button-delete uk-text-small">Удалить</a><input class="hidden" name="elements[' + elementId + '][images][' + imagesCount + '][file]" type="text" value="' + file.name + '">');

                        imagesCount++;
                        flgalleryimageSubmission.attr('fl-galleryimage-images', imagesCount);

                    } else if (file.error) {
                        $(this).parents('.fl-galleryimage').find('.fl-alert').removeClass('uk-hidden').append('<p class="uk-text-small uk-text-break">Файл <b>' + file.name + '</b> не загружен. Причина: ' + file.error + '.</p>');
                    }
                });
            }).on('fileuploadfail', function (e, data) {
                $.each(data.files, function (index) {
                    $(this).parents('.fl-galleryimage').find('.fl-alert').removeClass('uk-hidden').append('<p class="uk-text-small uk-text-break">Файл <b>' + file.name + '</b> не загружен.</p>');
                    // var error = $('<span class="text-danger"/>').text('File upload failed.');
                    // $(data.context.children()[index]).append(error);
                });
            }).prop('disabled', !$.support.fileInput)
                .parent().addClass($.support.fileInput ? undefined : 'disabled');
    }

    var url = 'http://paper-models.ru/upload/php/index.php';

    // Инициализация Jquery File Upload
    $('.fl-galleryimage-fileupload').each(function () {
        uploadInit($(this), url);
    })

    UIkit.modal.labels = {
        'Ok': 'Ок',
        'Cancel': 'Отменить'
    };

    // Удаление изображения
    $(document).on('click', '.fl-galleryimage .fl-button-delete', function () {
        var li = $(this);
        var stage = li.parents('.fl-files').parent();
        var button = $(this);
    
        UIkit.modal.confirm("Изображение будет удалено с нашего сервера.</br>Удалить изображение?", function(){
            $.ajax({
                type: "DELETE",
                url: url + "?file=" + encodeURIComponent(button.data('name')) + '&id=' + userId,
                success: function(data){
                    li.parents('.fl-sort-images').remove();
                    var filesCount = stage.find('.fl-sort-images').length;
                    if (filesCount == 0) {
                        stage.find('.uk-progress').addClass('uk-hidden');
                    }

                    $( ".fl-galleryimage-fileupload" ).rules( "add", {
                        galleryimage: filesCount
                    });

                    $('.fl-galleryimage-fileupload').valid();
                }
            });
        });
    });

});