<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

$params = $this->config;

if ($this->getItem()->id) {
    $user_id = $this->getItem()->created_by;
} else {
    $user = JFactory::getUser();
    if (!$user->guest) {
        $user_id = $user->id;
    } else {
        $user_id = 'quest';
    }
}

?>
<div class="<?php echo $this->identifier; ?> fl-galleryimage-submission" fl-galleryimage-images="<?php echo count($images); ?>">

    <div class="fl-galleryimage uk-grid">
        <div class="uk-width-1-1" data-uk-observe data-uk-margin="{cls:'uk-margin-top'}">
            <div class="upload">
                <div id="fl-galleryimage-dropzone" class="uk-placeholder uk-text-center galleryimage-dropzone">
                    <i class="uk-icon-cloud-upload uk-icon-medium uk-margin-small-right"></i> Перетащите изображения сюда или <a class="uk-form-file">выберите <input class="<?php echo $this->identifier; ?>-galleryimage-fileupload" type="file" name="<?php echo $this->identifier; ?>-files[]" multiple></a>
                </div>
            </div>
            <div class="fl-alert uk-alert uk-alert-danger uk-hidden"><span title="Спрятать предупреждение" class="uk-alert-close uk-close"></span></div>

            <ul class="fl-files uk-grid uk-grid-small uk-grid-width-large-1-5 uk-grid-width-small-1-3 uk-sortable <?php echo !empty($images) ? 'uk-margin-top' : ''; ?>" data-uk-grid-margin data-uk-sortable data-uk-grid-match>
                <!-- Хак для UIkit Start -->
                <?php echo (count($images)) ? '' : '<li class="fl-remove"></li>'; ?>
                <!-- Хак для UIkit End -->
                <?php
                    if ($images) {
                        $userId = $this->getItem()->created_by;
                        foreach ($images as $key => $image) {
                            echo '<li class="fl-sort-images">';
                            echo '<div class="fl-galleryimage-thumb uk-panel uk-panel-box uk-text-success uk-text-center">';
                            echo '<div class="uk-panel-teaser"><img src="/'.$this->getUploadImagePath().'/thumbnail/'.$image['name'].'"></div>';
                            echo '<p class="uk-text-small uk-text-truncate uk-margin-small-top uk-margin-small-bottom"><i class="fl-galleryimage-load-icon uk-icon-check-circle-o"></i> '.$image['name'].'</p>';
                            echo '<a data-url="'.JURI::root().'media/zoo/applications/jbuniversal/elements/jbgalleryimage/upload/index.php?'.$this->identifier.'-file='.urlencode($image['name']).'" class="fl-button-delete uk-text-small">Удалить</a>';
                            echo $this->app->html->_('control.text', $this->getGalleryImageControlName('name', $key), $image['name'], 'class="uk-hidden"');
                            echo '</div>';
                        }
                    }
                ?>
            </ul>
            <div class="uk-progress uk-progress-mini uk-margin-top uk-hidden">
                <div class="uk-progress-bar"></div>
            </div>     
        </div>
    </div>
</div>

<script>
    (function($){
        <?php if (!$params['script_sort']) : ?>
            $('head').append('<script src="/media/zoo/applications/jbuniversal/elements/jbgalleryimage/assets/js/uikit.sortable.min.js" type="text/javascript">');
        <?php endif; ?>

        <?php if ($params['script_sort']) : ?>
            $(".<?php echo $this->identifier; ?> .fl-files").sortable({
                cursor: "move",
                helper: "clone",
                tolerance: "pointer"
            });
            $(".<?php echo $this->identifier; ?> .fl-files").disableSelection();
        <?php endif; ?>

        $('.<?php echo $this->identifier; ?>-galleryimage-fileupload').jbGalleryImageUpload({
            'uploadId': '<?php echo $this->identifier; ?>',
            'url' : '<?php echo JURI::root(); ?>media/zoo/applications/jbuniversal/elements/jbgalleryimage/upload/index.php',
            'maxNumberOfFiles' : <?php echo $params['max_number']; ?>,
            'previewMaxWidth' : <?php echo $params['thumb_width']; ?>,
            'previewMaxHeight' : <?php echo $params['thumb_height']; ?>,
            'previewCrop': <?php echo ($params['thumb_crop']) ? 'true' : 'false'; ?>,
            'maxFileSize' : <?php echo $params['max_upload_size']*1000; ?>,
            'imageMaxWidth' : <?php echo $params['max_width']; ?>,
            'imageMaxHeight': <?php echo $params['max_height']; ?>,
            'userId' : '<?php echo $user_id; ?>'
        }); 

        $(document).on('click', '.fl-galleryimage .fl-button-delete', function () {
            if (confirm('Вы уверены, что хотите удалить изображение?')) {
                $(this).jbGalleryImageUpload('delete', {
                    'url' : $(this).data('url'),
                    'uploadId': '<?php echo $this->identifier; ?>',
                    'methodType': 'DELETE',
                    'userId' : '<?php echo $user_id; ?>'
                })
                $(this).parents('.fl-sort-images').remove();
            };
        })

        $(document).on('click', '.fl-alert .uk-close', function () {
            $(this).parent().addClass('uk-hidden').find('p').remove();
        })
    })(jQuery);
</script>