<?php
/**
 * @package   FL Gallery Image Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Class ElementJBImage
 */
class ElementJBGalleryImage extends Element implements iSubmittable
{
    /**
     * @var JBImageHelper
     */
    protected $_jbimagegallery = null;

    /**
     * Class constructor
     */
    public function __construct()
    {
        parent::__construct();

        $this->_jbimagegallery = $this->app->jbimage;

        $this->registerCallback('reSaveAfterChange');
    }

    public function reSaveAfterChange($files)
    {   
        $this->set('images', $files);
        $this->app->table->item->save($this->getItem(), false);

        return $this->app->jbajax->send(array(
                'reSave' => true,
            )
        );
    }

    /**
     * Checks if the repeatables element's value is set.
     * @param array $params render parameter
     * @return bool true, on success
     */
    public function hasValue($params = array())
    {   
        $data = $this->data();
        $file = $this->get('images');

        $check = !empty($data) || !empty($file);

        if (!$check) {
            return false;
        }

        return true;
    }

    /**
     * Get elements search data.
     * @return string Search data
     */
    public function getSearchData()
    {   
        $data = $this->data();
        $file = $this->get('images');
        $check = !empty($data) || !empty($file);

        if ($check) {
            return "__IMAGES_EXISTS__";
        } else {
            return "__IMAGES_NO_EXISTS__";
        }
    }

    public function getGalleryImageControlName($name, $index = 0)
    {
        return "elements[{$this->identifier}][{$index}][{$name}]";
    }

    /**
     * Renders the element.
     * @param array $params render parameter
     * @return null|string HTML
     */
    public function renderFile ($params = array(), $file = '')
    {
        //init params
        $params = $this->app->data->create($params);

        // init vars
        $title  = $this->get('title');
        $width  = (int)$params->get('width', 0);
        $height = (int)$params->get('height', 0);
        $alt    = $title = empty($title) ? $this->getItem()->name : $title;
        $url    = $imagePopup = $appendClass = $target = $rel = '';

        $image = $this->_jbimagegallery->resize($file, $width, $height);

        // select render template
        $template = $params->get('template', 'default');

        if ($template == 'itemlink') {
            if ($this->getItem()->getState()) {
                $url   = $this->app->jbrouter->externalItem($this->_item);
                $title = empty($title) ? $this->getItem()->name : $title;
            }

        } elseif ($template == 'popup') {

            $appendClass = 'jbimage-gallery';
            if ((int)$params->get('group_popup', 1)) {
                $rel = 'jbimage-gallery-' . $this->getItem()->id;
            }

            $target = '_blank';

            $widthPopup  = (int)$params->get('width_popup');
            $heightPopup = (int)$params->get('height_popup');

            if ($image) {
                $url = $this->_jbimagegallery->getUrl($file);
                if ($widthPopup || $heightPopup) {
                    $newImg = $this->_jbimagegallery->resize($image->orig, $widthPopup, $heightPopup);
                    $url    = $newImg->url;
                }
            }
        }

        // render layout
        if ($image && $layout = $this->getLayout('jbimage-' . $template . '.php')) {

            $unique = $params->get('_layout') . '_' . $this->_item->id . '_' . $this->identifier;

            return $this->renderLayout($layout, array(
                    'imageAttrs' => $this->_buildAttrs(array(
                        'class'         => 'jbimage ' . $unique,
                        'alt'           => $alt,
                        'title'         => $title,
                        'src'           => $image->url,
                        'width'         => $image->width,
                        'height'        => $image->height,
                        'data-template' => $template
                    )),
                    'linkAttrs'  => $this->_buildAttrs(array(
                        'class'  => 'jbimage-link ' . $appendClass . ' ' . $unique,
                        'title'  => $title,
                        'href'   => $url,
                        'rel'    => $rel,
                        'target' => $target,
                        'id'     => uniqid('jbimage-link-')
                    )),
                    'link'       => $url,
                    'image'      => $image
                )
            );
        }

        return null;
    }

    /**
     * @param array $attrs
     * @return string
     */
    public function _buildAttrs(array $attrs)
    {
        return $this->app->jbhtml->buildAttrs($attrs);
    }

    /**
     * Render
     * @param array $params
     */
    public function render($params = array())
    {   
        $result = array();
        $params = $this->app->data->create($params);

        $images = $this->get('images');

        if (empty($images)) {
            $images = $this->data();
        }

        switch ($params->get('display', 'all')) {
            case 'first':
                $result[] = $this->renderFile($params, $images[0]['file']);
                break;
            case 'all_without_first':
                array_shift($images);
                foreach ($images as $image) {
                    $result[] = $this->renderFile($params, $image['file']);
                }
                break;
            case 'all':
            default:
                foreach ($images as $image) {
                    $result[] = $this->renderFile($params, $image['file']);
                }
                break;
        }

        return $this->app->element->applySeparators($params->get('separated_by'), $result);
    }

    /**
     * Renders the edit form field.
     * @return string HTML
     */
    public function edit()
    {      
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/load-image.all.min.js');
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/canvas-to-blob.min.js');
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/jquery.iframe-transport.js');
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/jquery.fileupload.js');
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/jquery.fileupload-process.js');
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/jquery.fileupload-image.js');
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/jquery.fileupload-validate.js');
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/edit.js');

        $images = $this->get('images');

        if (empty($images)) {
            $images = $this->data();
        }

        if ($layout = $this->getLayout('edit.php')) {
            return $this->renderLayout($layout,
                compact('images')
            );
        }

        return null;
    }

    /**
     * Renders the element in submission.
     * @param array $params submission parameters
     * @return null|string|void
     */
    public function renderSubmission($params = array())
    {   
        $this->app->jbsession->set($this->identifier, null, 'jbgalleryimage_validate');

        $this->app->document->addScript('elements:jbgalleryimage/assets/js/load-image.all.min.js');
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/canvas-to-blob.min.js');
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/jquery.iframe-transport.js');
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/jquery.fileupload.js');
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/jquery.fileupload-process.js');
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/jquery.fileupload-image.js');
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/jquery.fileupload-validate.js');
        $this->app->document->addScript('elements:jbgalleryimage/assets/js/jbgalleryimage-upload.js');

        $images = $this->get('images');

        if (empty($images)) {
            $images = $this->data();
        }

        if ($layout = $this->getLayout('submission.php')) {
            return $this->renderLayout($layout,
                compact('images')
            );
        }

        return null;
    }

    public function bindData($data = array()) {

        $images_arr = $data['images'];

        if (empty($images_arr)) {
            $images_arr = $data;
        }

        $key = 0;

        if (!empty($images_arr)) {
            foreach ($images_arr  as $image) {
                $datanew[$key]['file']  = $this->getUploadedFilePath($image['name']);
                $datanew[$key]['title']  = '';
                $datanew[$key]['link']  = '';
                $datanew[$key]['target']  = '0';
                $datanew[$key]['rel']  = '';
                $key++;
            }

            parent::bindData($datanew);
        }
    }

    /**
     * Validates the submitted element
     * @param AppData $value  value
     * @param AppData $params submission parameters
     * @return array
     * @throws AppValidatorException
     */
    public function validateSubmission($value, $params)
    {   
        $images_arr = $value->get('images');

        if (empty($images_arr)) {
            $images_arr = $value;
        }

        if ($params->get('required') && empty($images_arr)) {
            throw new AppValidatorException('Please select an image to upload.');
        }

        $key = 0;

        foreach ($images_arr  as $image) {
            $result[$key]['name'] = $this->app->validator->create('string', array('required' => true))->clean($image['name']);
            $key++;
        }

        return $result;
    }

    /**
     * Get upload image path
     * @return string
     */
    protected function getUploadImagePath()
    {
        $uploadByUser    = (int)$this->config->get('upload_by_user', 0);
        $uploadByDate    = (int)$this->config->get('upload_by_date', 0);
        $uploadDirectory = trim(trim($this->config->get('upload_directory', 'images/zoo/uploads/')), '\/');

        if ($uploadByUser) {
            if ($this->getItem()->id) {
                $user_id = ($this->getItem()->created_by) ? $this->getItem()->created_by : 'quest';
            } else {
                $user = JFactory::getUser();
                $user_id = $user->id;
            }
            $uploadDirectory .= '/' . $user_id;
        } elseif ($uploadByDate) {
            $uploadDirectory .= '/' .  date("d-m-Y");
        }

        $uploadDirectory = JPath::clean($uploadDirectory);

        return $uploadDirectory;
    }

    /**
     * Get uploaded file path 
     * @return string
     */

    protected function getUploadedFilePath($userfile)
    {
        $basePath = JPATH_ROOT . '/' . $this->getUploadImagePath() . '/';
        $file     = $basePath . $userfile;

        return JPath::clean($this->app->path->relative($file));
    }

    /**
     * Get default image
     * @param JSONData $params
     * @return null|object
     */
    protected function getDefaultImage($params)
    {
        // init vars
        $width         = (int)$params->get('width', 0);
        $height        = (int)$params->get('height', 0);
        $defaultImage  = $this->config->get('default_image');
        $defaultEnable = (int)$this->config->get('default_enable', 0);

        $result = null;

        if ($defaultEnable && $defaultImage) {

            if (strpos($defaultImage, 'http') !== false) {

                return (object)array(
                    'width'   => $width,
                    'height'  => $height,
                    'path'    => $defaultImage,
                    'orig'    => $defaultImage,
                    'origUrl' => $defaultImage,
                    'url'     => $defaultImage,
                    'rel'     => $defaultImage,
                );

            } else {
                return $this->_jbimagegallery->resize($defaultImage, $width, $height);
            }
        }

        return null;
    }

}