/**
 * @package   FL Gallery Image Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

 (function($){

    var methods = {
        init : function(options) {

            var settings = $.extend( {
                'uploadId': '',
                'url' : '',
                'maxNumberOfFiles' : 10,
                'previewMaxWidth' : 175,
                'previewMaxHeight' : 110,
                'previewCrop': true,
                'maxFileSize' : 512000,
                'imageMaxWidth' : 1024,
                'imageMaxHeight': 800,
                'userId' : 'quest'
            }, options);
            
            var fileupload = function() {
                $('.' + options.uploadId + '-galleryimage-fileupload').fileupload({
                    dropZone: $('.' + options.uploadId + ' .galleryimage-dropzone'),
                    url: options.url,
                    dataType: 'json',
                    autoUpload: true,
                    acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i,
                    maxFileSize: options.maxFileSize,
                    maxNumberOfFiles: options.maxNumberOfFiles,
                    getNumberOfFiles: function () {
                        return $('.' + options.uploadId + ' .fl-files .fl-sort-images').length - 1;
                    },
                    disableImageResize: /Android(?!.*Chrome)|Opera/
                        .test(window.navigator && navigator.userAgent),
                    previewMaxWidth: options.previewMaxWidth,
                    previewMaxHeight: options.previewMaxHeight,
                    previewCrop: options.previewCrop,
                    imageMaxWidth: options.imageMaxWidth,
                    imageMaxHeight: options.imageMaxHeight,
                    formData: {id: options.userId, elementId: options.uploadId}
                }).on('fileuploadadd', function (e, data) {
                    $('.fl-remove').remove(); //хак для UIkit
                    data.context = $('<li class="fl-sort-images uk-text-center"/>').appendTo($(this).parents('.fl-galleryimage').find('.fl-files'));
                    $.each(data.files, function (index, file) {
                        var node = $('<div/>')
                                .append($('<p class="uk-text-small uk-text-truncate uk-margin-small-top uk-margin-small-bottom"/>').html('<i class="fl-galleryimage-load-icon uk-icon-spinner uk-icon-spin"></i> ' + file.name));
                        node.appendTo(data.context);
                    });
                }).on('fileuploadprocessalways', function (e, data) {
                    var index = data.index,
                        file = data.files[index],
                        node = $(data.context.children()[index]),
                        teaser = $('<div class="uk-panel-teaser"></div>');

                    if (file.preview) {
                        var canvas = data.files[0].preview;
                        var newImg = document.createElement("img");
                        newImg.src = canvas.toDataURL();
                        var img = teaser.prepend(newImg);
                        node.prepend(img);
                    }
                    if (file.error) {
                        $(this).parents('.fl-galleryimage').find('.fl-alert').removeClass('uk-hidden').append('<p class="uk-text-small uk-text-break">Файл <b>' + file.name + '</b> не загружен. Причина: ' + file.error + '.</p>');
                        node.closest('.fl-sort-images').remove();
                    }
                    if (index + 1 === data.files.length) {
                        data.context.find('button')
                            .text('Upload')
                            .prop('disabled', !!data.files.error);
                    }
                }).on('fileuploadprogressall', function (e, data) {
                    var progress = parseInt(data.loaded / data.total * 100, 10);

                    $(this).parents('.fl-galleryimage').find('.uk-progress').removeClass('uk-hidden').find('.uk-progress-bar').css(
                        'width',
                        progress + '%'
                    );

                    if (progress != 100) {
                        $('#fl-submit-button').prop('disabled', true);
                    } else {
                        $('#fl-submit-button').prop('disabled', false);
                    }
                    
                }).on('fileuploaddone', function (e, data) {
                    var flgalleryimageSubmission = $('.' + options.uploadId + '.fl-galleryimage-submission');
                    $.each(data.result[options.uploadId + '-files'], function (index, file) {
                        if (file.url) {

                            var count = $('.' + options.uploadId + ' .fl-files li').length;
    
                            var imagesCount = parseInt(flgalleryimageSubmission.attr('fl-galleryimage-images'));

                            var link = $('<div class="fl-galleryimage-thumb uk-panel uk-panel-box uk-text-success uk-text-center">');
                            $(data.context.children()[index])
                                .wrap(link)
                                .find('.fl-galleryimage-load-icon').removeClass('uk-icon-spinner uk-icon-spin')
                                .addClass('uk-icon-check-circle-o');
                            $(data.context.children()[index]).append('<a data-url="' + file.deleteUrl + '" class="fl-button-delete uk-text-small">Удалить</a><input class="uk-hidden" name="elements[' + options.uploadId + '][' + imagesCount + '][name]" type="text" value="' + file.name + '">');

                            imagesCount++;
                            flgalleryimageSubmission.attr('fl-galleryimage-images', imagesCount);

                        } else if (file.error) {
                            $(this).parents('.fl-galleryimage').find('.fl-alert').removeClass('uk-hidden').append('<p class="uk-text-small uk-text-break">Файл <b>' + file.name + '</b> не загружен. Причина: ' + file.error + '.</p>');
                        }
                    });
                }).on('fileuploadfail', function (e, data) {
                    $.each(data.files, function (index) {
                        $(this).parents('.fl-galleryimage').find('.fl-alert').removeClass('uk-hidden').append('<p class="uk-text-small uk-text-break">Файл <b>' + file.name + '</b> не загружен.</p>');
                    });
                }).prop('disabled', !$.support.fileInput).parent().addClass($.support.fileInput ? undefined : 'disabled');
            }

            return this.each(fileupload);
        },
        delete : function(options) {
            var settings = $.extend( {
                'url': '',
                'uploadId': '',
                'methodType': 'DELETE',
                'userId' : ''
            }, options);

            return this.each(function() {
                $.ajax({
                    type: options.methodType,
                    url: options.url + '&id=' + options.userId + '&elementId=' + options.uploadId,
                    success: function(data){
                        var imagesCount = $('.' + options.uploadId + ' .fl-sort-images').length;
                        $('.' + options.uploadId + '.fl-galleryimage-submission').attr('fl-galleryimage-images', imagesCount)
                        if (imagesCount == 0) {
                            $('.' + options.uploadId + ' .uk-progress').addClass('uk-hidden');
                        }
                    }
                });

            });
        }
    };

    $.fn.jbGalleryImageUpload = function(method) {
        
        if ( methods[method] ) {
            return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
        } else if ( typeof method === 'object' || ! method ) {
            return methods.init.apply( this, arguments );
        } else {
            $.error('Метод с именем ' +  method + ' не существует для jbGalleryImageUpload');
        } 
    };

})(jQuery);