<?php
// Запрещаем прямой доступ к файлу
defined('_JEXEC') or die('Restricted access');

class ElementImagereelkit extends Element implements iSubmittable {
		
	public function getDirectory() {
		return rtrim($this->config->get('directory'), '/').'/';
	}
	
	protected function _getDirectoryPath() {
		return trim(trim($this->config->get('directory', 'images/')), '\/');
    }		
	
	/* проверка заполненности полей элемента */

	public function hasValue($params = array()) {		
		$value = $this->get('value', '');		
		return !empty($value);
	}

    /* Добавляем возможность подачи и редактирования в админке */
    public function edit()	{
		if ($layout = $this->getLayout('edit.php')) {				
			return $this->renderLayout($layout);
		}		
		return false;
	}
		
    /* Добавлем возмождность редактировать с фронта  */
    public function renderSubmission($params = array()) {
        return $this->edit();
	}		
		
    /* Вывод результатов */
    public function render($params = array())
    {
		$this->app->document->addScript('elements:imagereelkit/assets/js/jquery.reel-min.js');
		$this->app->document->addScript('elements:imagereelkit/assets/js/jquery.mousewheel.min.js');
        $this->app->document->addStylesheet('elements:imagereelkit/assets/css/reel.css');
				
		if ($layout = $this->getLayout('tmpl.php')) {
			//jbdump ($params, 0);
			$params 		= $this->app->data->create($params);
			$directory		= $this->_config->get('directory', "images");			
			$cw				= $this->_config->get('cw', true);
			$frames			= $this->_config->get('frames', 36);
			$frame			= $this->_config->get('frame', 1);
			$speed			= $this->_config->get('speed', -0.2);
			$velocity		= $this->_config->get('velocity', 1);
			$duration		= $this->_config->get('duration', 4);
			$wheelable		= $this->_config->get('wheelable', true);
			$responsive		= $this->_config->get('responsive', false);
			$brake			= $this->_config->get('brake', 0.2);
			$foolimwidth	= $this->_config->get('foolimwidth', 600);
			$foolimheight	= $this->_config->get('foolimheight', 600);
			
			$responsive		= $params->get('responsive', false);
			$foolimwidth	= $params->get('foolimwidth', 600);
			$foolimheight	= $params->get('foolimheight', 600);
										
            return $this->renderLayout($layout, array(
						'directory' 	=> $directory,
					  	'cw' 			=> $cw,
						'frames' 		=> $frames,
						'frame' 		=> $frame,
						'speed' 		=> $speed,
						'velocity' 		=> $velocity,
						'duration' 		=> $duration,
						'wheelable' 	=> $wheelable,
						'responsive' 	=> $responsive,
						'brake' 		=> $brake,
						'foolimwidth' 	=> $foolimwidth,
						'foolimheight' 	=> $foolimheight	
					  ));
        }
        return null;
    }


	//Валмдация элемента
	public function validateSubmission($value, $params)
	{
		return array(
			'value'  => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('value')),
		);
	}

}