<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Alexander Oganov <t_tapak@yahoo.com>
 */

// no direct access

defined('_JEXEC') or die('Restricted access');

// register ElementFile class
App::getInstance('zoo')->loader->register('NovaPoshtaApi2', 'cart-elements:shipping/newpostnew/api/api2.php');

/**
 * Class JBCartElementShippingNewPostNew
 */
class JBCartElementShippingNewPostNew extends JBCartElementShipping
{
    const CACHE_TTL = 1440;

    const TYPE_DOORS = 'WarehouseDoors';
    const TYPE_WARE  = 'WarehouseWarehouse';

    const DEFAULT_TYPE = 'WarehouseWarehouse';

    const DEFAULT_CITY   = 'Київ';
    const DEFAULT_REGION = 'Київська';

    protected $_currency = 'uah';

    /**
     * @var string
     */
    protected $_url = 'http://orders.novaposhta.ua/xml.php';

    /**
     * Class constructor
     * @param App    $app
     * @param string $type
     * @param string $group
     */
    public function __construct($app, $type, $group)
    {
        parent::__construct($app, $type, $group);

        $this->registerCallback('ajaxLocations');
    }

    /**
     * Check if exists api_key.
     * Without api_key all requests will be unsuccessful.
     * @param array $params
     * @return bool
     */
    public function hasValue($params = array())
    {
        $key = $this->config->get('api_key');

        if (!empty($key)) {
            return parent::hasValue($params);
        }

        return parent::hasValue($params);
    }

    /**
     * @return JBCartValue
     */
    public function getRate()
    {
        $rate = $this->_order->val(0, $this->_currency);

        $items  = $this->_order->getItems();
        $sender = $this->getCity($this->getDefaultCity());
        $type   = $this->get('deliveryType_id', self::DEFAULT_TYPE);

        foreach ($items as $item) {
            $item = $this->app->data->create($item);

            $recipient = $this->getCity($this->get('recipientCity', self::DEFAULT_CITY));
            $quantity  = $item->get('quantity', 1);
            $price     = $this->_order->val($item->get('total'))->multiply($quantity);

            $weight = (float)$item->find('elements._weight', 0.1) * $quantity;

            try {
                $resp = $this->getApi()->getDocumentPrice($sender, $recipient, $type, $weight, $price->val($this->_currency));

                if (isset($resp['success'])) {
                    $cost = $this->app->jbvars->money($resp['data']['0']['Cost']);
                    $rate->add(array($cost, $this->_currency));
                }
            } catch (Exception $e) {
                continue;
            }
        }

        return $rate;
    }

    /**
     * @return mixed
     */
    protected function getDefaultCity()
    {
        return $this->config->get('sender_city', self::DEFAULT_CITY);
    }

    /**
     * @return NovaPoshtaApi2
     */
    protected function getApi()
    {
        $api = new NovaPoshtaApi2(
            $this->config->get('api_key'),
            $this->config->get('language'),
            true, // При ошибке в запросе выбрасывать Exception: FALSE (default) | TRUE
            'jbhttp' // Используемый механизм запроса: curl (defalut) | file_get_content
        );

        return $api;
    }

    /**
     * @return array
     */
    protected function getRegionList()
    {
        $areas = $this->getApi()->getAreas();
        $label = $this->getStdLabel(array(
            'Description' => '-&nbsp;' . JText::_('JBZOO_ELEMENT_SHIPPING_NEWPOST_REGION') . '&nbsp;-'
        ));

        if (isset($areas['success']) && !empty($areas['data'])) {
            array_unshift($areas['data'], $label);
        }

        $list = $this->prepareData($areas['data']);
        ksort($list);

        return $list;
    }

    /**
     * @param null $region
     * @return array
     */
    protected function getCityList($region = null)
    {
        $api    = $this->getApi();
        $cities = $api->setFormat('array')->getCities();
        $label  = $this->getStdLabel(array(
            'Description' => '-&nbsp;' . JText::_('JBZOO_ELEMENT_SHIPPING_NEWPOST_REGION') . '&nbsp;-',
            'Area'        => ''
        ));

        if (isset($cities['success'])) {
            array_unshift($cities['data'], $label);
        }

        if (!empty($region)) {
            $region = JString::trim($this->getRegion($region));
            $region = empty($region) ? null : $region;
        }

        $list = $this->prepareData($cities['data'], function ($city) use ($region) {
            if (!isset($city['Area'])) {
                return false;
            }
            $cityArea = strtolower(trim($city['Area']));

            return (!empty($region) && $cityArea == $region ? $city['Description'] : false);
        });

        return $list;
    }

    /**
     * @param null $city
     * @return array
     */
    protected function getWarehouseList($city = null)
    {
        $label      = $this->getStdLabel(array(
            'Description' => '-&nbsp;' . JText::_('JBZOO_ELEMENT_SHIPPING_NEWPOST_WAREHOUSES') . '&nbsp;-'
        ));
        $warehouses = $this->getApi()->getWarehouses($this->getCity($city));

        if (isset($warehouses['success'])) {
            array_unshift($warehouses['data'], $label);
        }
        $list = $this->prepareData($warehouses['data']);
        ksort($list);

        return $list;
    }

    /**
     * @param  string $name Name of the city to find
     * @return string
     */
    protected function getCity($name)
    {
        if (empty($name)) {
            $name = $this->getDefaultCity();
        }

        $ref      = $name;
        $response = $this->getAPI()->getCities(0, $name);

        if ($response['success']) {
            $ref = $response['data'][0]['Ref'];
        }

        return $ref;
    }

    /**
     * @param $name
     * @return string
     */
    protected function getRegion($name)
    {
        if (empty($name)) {
            $name = self::DEFAULT_REGION;
        }

        $ref      = '';
        $response = $this->getAPI()->getArea($name);
        if ($response['success']) {
            $ref = $response['data'][0]['Ref'];
        }

        return $ref;
    }

    /**
     * @return array
     */
    protected function getTypeList()
    {
        return array(
            self::TYPE_DOORS => JText::_('JBZOO_ELEMENT_SHIPPING_NEWPOST_TO_DOORS'),
            self::TYPE_WARE  => JText::_('JBZOO_ELEMENT_SHIPPING_NEWPOST_TO_WAREHOUSE'),
        );
    }

    /**
     * @param $type
     * @param $location
     */
    public function ajaxLocations($type, $location)
    {
        $list = array();

        if ($type == 'cities') {
            $list = $this->getCityList($location);
        } else if ($type == 'warehouses') {
            $list = $this->getWarehouseList($location);
        }

        $this->app->jbajax->send(array('list' => $list));
    }

    /**
     * @return string
     */
    protected function getAjaxLocationsUrl()
    {
        return $this->getAjaxUrl('ajaxLocations');
    }

    /**
     * @param  array        $data
     * @param  Closure|null $filter
     * @param string        $key
     * @param string        $value
     * @return array
     */
    protected function prepareData($data, $filter = null, $key = 'Description', $value = 'Description')
    {
        $defaultKey = 'Ref';
        $defaultVal = 'Description';
        $count      = count($data);
        $result     = array();

        $isCallable = is_callable($filter);
        for ($i = 0; $i < $count; $i++) {
            if ($isCallable) {
                $result[$data[$i][$key]] = $filter($data[$i]);

            } elseif (isset($data[$i][$key], $data[$i][$value])) {
                $result[$data[$i][$key]] = $data[$i][$value];

            } else {
                $result[$data[$i][$defaultKey]] = $data[$i][$defaultVal];

            }
        }
        $result = array_filter($result);

        return $result;
    }

    /**
     * @param array $properties
     * @return \stdClass
     * @internal param $label
     */
    protected
    function getStdLabel($properties = array())
    {
        $properties = array_filter((array)$properties);

        $object = array(
            'Ref   '      => '',
            'Description' => ''
        );

        if (is_array($properties) || is_object($properties)) {
            foreach ((array)$properties as $k => $v) {
                $object[$k] = $v;
            }
        }

        return $object;
    }
}
