<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Alexander Oganov <t_tapak@yahoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/** @type JBHtmlHelper $jbHTML */
$jbHTML  = $this->app->jbhtml;
$unique = $this->app->jbstring->getId('newpostnew-');

$defCity = $this->getDefaultCity();
?>

<div class="newpostnew-sender-city">
    <p>
        <strong><?php echo JText::_('JBZOO_ELEMENT_SHIPPING_NEWPOST_SENDER'); ?>:</strong>
        <?php echo $defCity; ?>
    </p>
</div>

<div id="<?php echo $unique; ?>">
    <div class="newpostnew-deliveryType_id">
        <?php echo $jbHTML->select($this->getTypeList(), $this->getControlName('deliveryType_id'),
                'class="jsDeliveryType"', $this->get('deliveryType_id', JBCartElementShippingNewPostNew::DEFAULT_TYPE)); ?>
    </div>

    <div class="newpostnew-region">
        <?php echo $jbHTML->select($this->getRegionList(), $this->getControlName('region'),
                'class="jsRegion"', $this->get('region', JBCartElementShippingNewPostNew::DEFAULT_REGION)); ?>
    </div>

    <div class="newpostnew-recipientCity">
        <?php echo $jbHTML->select($this->getCityList($this->get('region', JBCartElementShippingNewPostNew::DEFAULT_REGION)),
                $this->getControlName('recipientCity'), 'class="jsRecipientCity"',
                $this->get('recipientCity', JBCartElementShippingNewPostNew::DEFAULT_CITY)); ?>
    </div>

    <div class="newpostnew-warehouse jsWarehouseWrapper">
        <?php echo $jbHTML->select($this->getWarehouseList($this->get('recipientCity', JBCartElementShippingNewPostNew::DEFAULT_CITY)),
                $this->getControlName('warehouse'), 'class="jsWarehouse"', $this->get('warehouse')); ?>
    </div>

    <div class="newpostnew-doors jsDoorsWrapper">
        <?php
        echo $jbHTML->text(
                $this->getControlName('street'),
                $this->get('street'),
                array('placeholder' => JText::_('JBZOO_ELEMENT_SHIPPING_NEWPOST_STREET'))
        );
        echo $jbHTML->text(
                $this->getControlName('floor_count'),
                $this->get('floor_count'),
                array('placeholder' => JText::_('JBZOO_ELEMENT_SHIPPING_NEWPOST_FLOOR_COUNT'))
        );
        ?>
    </div>
</div>

<?php echo $this->app->jbassets->widget('#' . $unique, 'JBZooShippingTypeNewpostNew', array(
        'type_doors'    => JBCartElementShippingNewPostNew::TYPE_DOORS,
        'type_ware'     => JBCartElementShippingNewPostNew::TYPE_WARE,
        'url_locations' => $this->getAjaxLocationsUrl(),
), true); ?>

