<?php
/**
 * @package   com_zoo
 * @author    YOOtheme http://www.yootheme.com
 * @copyright Copyright (C) YOOtheme GmbH
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// register ElementRepeatable class
App::getInstance('zoo')->loader->register('ElementRepeatable', 'elements:repeatable/repeatable.php');

/**
 * Class ElementDate
 * The date element class
 */
class ElementDate extends ElementRepeatable implements iRepeatSubmittable
{

    const EDIT_DATE_FORMAT = '%Y-%m-%d %H:%M:%S';

    /**
     * Get repeatable elements search data.
     * @return null
     */
    protected function _getSearchData()
    {
        return $this->get('value');
    }

    /**
     * Renders the repeatable element.
     * @param array $params
     * @return string
     */
    public function render($params = array())
    {
		$actdate = 0;
        $params = $this->app->data->create($params);
		//Загоняем все даты в массив
		$result = array();		
		foreach ($this as $self) {$result[] = $this->_render($params);}
		
		//Выводим массив
		foreach ($result as &$value) {
		//Получаем дату из массива
		$value = $this->app->html->_('date', $value, $this->app->date->format($params->get('date_format') == 'custom' ? $params->get('custom_format') : $params->get('date_format')));		
		//Получаем текущую дату и сравниваем ее с текущим элементом массива
		$mtdate = strtotime(date("d.m.Y")) - strtotime($value);		
		//Задаем переменнst отметки даты как ближайшая и переменные попап окна		
		$myclass = 'unvizibledate';
		$dcont = 'Прошедшая дата тура';
		$ortitle = 'Дата тура';
		
		//Если разница меньше нуля значит дата текущая меньше будующей
            if ($mtdate > 0) {
				$myclass = 'unvizibledate';
				$dcont = 'Прошедшая дата тура';
				$ortitle = 'Дата тура';
				}
           else {
			   if ($actdate == 1) {
					$myclass = 'vizidate';
					$dcont = 'Планируемая дата тура';
					$ortitle = 'Дата тура';
					} 
					
			   if (($mtdate < 0) and ($actdate == 0)) {
					$myclass = 'active';
					$dcont = 'Ближайшая дата тура';
					$ortitle = 'Дата тура';
					$actdate = 1;
					}
			     
			   } 

			?>
			<span rel="popover" class="<?php print $myclass; ?>" data-content="<?php print $dcont; ?>" data-original-title="<?php print $ortitle; ?>"><?php print $value; ?></span>
            <?php
			
		}
        return '';
    }

    /**
     * Renders the repeatable edit form field.
     * @return mixed
     */
    protected function _edit()
    {
        $name = $this->getControlName('value');
        if ($value = $this->get('value', '')) {
            try {

                $value = $this->app->html->_('date', $value, $this->app->date->format(self::EDIT_DATE_FORMAT), $this->app->date->getOffset());

            } catch (Exception $e) {
            }
        }
        return $this->app->html->_('zoo.calendar', $value, $name, $name, array('class' => 'calendar-element'), true);
    }

    /**
     * Renders the element in submission.
     * @param array $params
     * @return mixed|void
     */
    public function _renderSubmission($params = array())
    {
        return $this->_edit();
    }

    /**
     * Validates the submitted element
     * @param $value
     * @param $params
     * @return array
     */
    public function _validateSubmission($value, $params)
    {

        $value = $value->get('value');
        if (!empty($value) && ($time = strtotime($value))) {
            $value = strftime(self::EDIT_DATE_FORMAT, $time);
        }

        return array('value' => $this->app->validator->create('date', array('required' => $params->get('required')), array('required' => 'Please choose a date.'))
                ->addOption('date_format', self::EDIT_DATE_FORMAT)
                ->clean($value));
    }

    /**
     * Set data through data array.
     * @param array $data
     */
    public function bindData($data = array())
    {
        parent::bindData($data);

        foreach ($this as $self) {

            $value = $this->get('value', '');

            if (!empty($value) && ($value = strtotime($value)) && ($value = strftime(self::EDIT_DATE_FORMAT, $value))) {
                $tzoffset = $this->app->date->getOffset();
                $date     = $this->app->date->create($value, $tzoffset);
                $value    = $date->toSQL();
                $this->set('value', $value);
            }
        }

    }

    /**
     * @param array $params
     * @return string
     */
    public function renderSubmission($params = array())
    {
        $this->app->jbassets->calendar();
        return parent::renderSubmission($params);
    }

}
