<?php
/**
* @package   com_zoo
* @author    YOOtheme http://www.yootheme.com
* @copyright Copyright (C) YOOtheme GmbH
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// register ElementRepeatable class
App::getInstance('zoo')->loader->register('ElementRepeatable', 'elements:repeatable/repeatable.php');

/*
   Class: ElementText
       The text element class
*/
class ElementSkladKit extends ElementRepeatable implements iRepeatSubmittable {

	/*
		Function: _hasValue
			Checks if the repeatables element's value is set.

	   Parameters:
			$params - render parameter

		Returns:
			Boolean - true, on success
	*/
	protected function _hasValue($params = array()) {
		$value = $this->get('value', $this->config->get('default'));
		return !empty($value) || $value === '0';
	}
	
	/*
		Function: render
			Renders the element.

	   Parameters:
            $params - render parameter

		Returns:
			String - html
	*/
	protected function _render($params = array()) {
               $this->app->document->addStylesheet('elements:itext/assets/css/itext.css');
               $params       = $this->app->data->create($params) ;
			   $jplugins     = $this->config->get('jplugins');
	           $before       = $params->get('before') ;
	           $after        = $params->get('after') ;
			   $skladis_en   = $this->config->get('skladis_en', 0) ;
			   $skladis      = $this->config->get('skladis') ;
			   $skladepmt_en = $this->config->get('skladepmt_en', 0) ;
			   $skladepmt    = $this->config->get('skladepmt', 'ожидается') ;
               $value        = $this->get('value');
               $wtipe        = $params->get('wtipe') ;
			   $wlimit       = $params->get('wlimit') ;

			   if ($value > 0) {
					if ($skladis_en == 1) {$value = $skladis;}
			   }
			   else {
					if ($skladepmt_en == 1) {$value = $skladepmt;}
			   }
			   $value        = $before.$value.$after;
			   
			   $sep = ' ';
				//обрезаем текст по словам   
			   
			   if ($wtipe == "words"){	 
					$words = preg_split("/ /", $value);
					if ( count($words) > $wlimit ) $value = join(" ", array_slice($words, 0, $wlimit)) . '...';
			   }
			   if ($wtipe == "simbols"){	
			   $cut = mb_substr($value, 0, $wlimit);
			   $res = mb_strlen($value,'UTF-8') - mb_strlen($cut,'UTF-8');
			   if ($res > 0) {$res = '...';} else {$res = '';}
					$value = $cut.$res;
			   }
			   
			   if ($params->get('link_to_item', false) && $this->_item->getState()) {
			 $value = '<a title="'.$this->_item->name.'" href="' . $this->app->route->item($this->_item) . '">' .$value.'</a>';}
			   
			   
			   $result[] = $value;     
	// trigger joomla content plugins
		if ($jplugins) {
			for ($i = 0; $i < count($result); $i++) {
				$result[$i] = $this->app->zoo->triggerContentPlugins($result[$i], array('item_id' => $this->_item->id), 'com_zoo.element.text');
			}
		}
					
		//$full       = "$before $result $after" ;	
		$full       = $result[0] ;
				    
     return $full;
	}



	/*
		Function: _getSearchData
			Get repeatable elements search data.

		Returns:
			String - Search data
	*/
	protected function _getSearchData() {
		return $this->get('value', $this->config->get('default'));
	}

	/*
	   Function: _edit
	       Renders the repeatable edit form field.

	   Returns:
	       String - html
	*/
	protected function _edit($params = array()) {
		$params		= $this->app->data->create($params) ;
		$ctipe	   	= $this->config->get('ctipe', 'nofiltr');
		$randomid	= mt_rand (100, 9999);
		$mfid 		= 'mfid'.$randomid;
		$fieldlim	= $this->config->get('fieldlim', '255');
				
		switch ($ctipe) {
			case 'nofiltr':
				
			break;
			case 'onlinum':
			?>
				<script type="text/javascript">
					jQuery(function($){
						$(document).ready(function(){
							$("#<?php print $mfid; ?>").keypress(function(<?php print $mfid; ?>) {
							if (!(<?php print $mfid; ?>.which==8 || <?php print $mfid; ?>.which==44 || <?php print $mfid; ?>.which==32 || <?php print $mfid; ?>.which==45 || <?php print $mfid; ?>.which==46 ||(<?php print $mfid; ?>.which>47 && <?php print $mfid; ?>.which<58))) return false;
							});
						});
					});
				</script>
			<?php
			break;
			case 'onlisimb':
			?>
				<script type="text/javascript">
					jQuery(function($){
						$(document).ready(function(){
							$("#<?php print $mfid; ?>").keypress(function(<?php print $mfid; ?>) {
							if (!(<?php print $mfid; ?>.which==8 || <?php print $mfid; ?>.which==44 || <?php print $mfid; ?>.which==32 || <?php print $mfid; ?>.which==45 || <?php print $mfid; ?>.which==46 || (<?php print $mfid; ?>.which>64 && <?php print $mfid; ?>.which<91)|| (<?php print $mfid; ?>.which>96 && <?php print $mfid; ?>.which<123) || (<?php print $mfid; ?>.which>1039 && <?php print $mfid; ?>.which<1106))) return false;
							});
						});
					});
				</script>
			<?php
			break;
			case 'onlisimbr':
			?>
				<script type="text/javascript">
					jQuery(function($){
						$(document).ready(function(){
							$("#<?php print $mfid; ?>").keypress(function(<?php print $mfid; ?>) {
							if (!(<?php print $mfid; ?>.which==8 || <?php print $mfid; ?>.which==44 || <?php print $mfid; ?>.which==32 || <?php print $mfid; ?>.which==45 || <?php print $mfid; ?>.which==46 || (<?php print $mfid; ?>.which>1039 && <?php print $mfid; ?>.which<1106))) return false;
							});
						});
					});
				</script>
			<?php
			break;
			case 'onlisimbe':
			?>
				<script type="text/javascript">
					jQuery(function($){
						$(document).ready(function(){
							$("#<?php print $mfid; ?>").keypress(function(<?php print $mfid; ?>) {
							if (!(<?php print $mfid; ?>.which==8 || <?php print $mfid; ?>.which==44 || <?php print $mfid; ?>.which==32 || <?php print $mfid; ?>.which==45 || <?php print $mfid; ?>.which==46 || (<?php print $mfid; ?>.which>64 && <?php print $mfid; ?>.which<91)|| (<?php print $mfid; ?>.which>96 && <?php print $mfid; ?>.which<123))) return false;
							});
						});
					});
				</script>
			<?php
			break;
		}
		//print $ctipe;
		return $this->app->html->_('control.text', $this->getControlName('value'), $this->get('value', $this->config->get('default')), 'size="60" maxlength="'.$fieldlim.'" id="'.$mfid.'"');
		
		
	}


	/*
		Function: _renderSubmission
			Renders the element in submission.

	   Parameters:
            $params - AppData submission parameters

		Returns:
			String - html
	*/
	public function _renderSubmission($params = array()) {
        return $this->_edit();
	}

}