<?php
// Запрещаем прямой доступ к файлу
defined('_JEXEC') or die('Restricted access');

class JBCSVItemUserMenuKit extends JBCSVItem 
{
	
 	public function toCSV()
    {
        $result = array();
		
		if (!empty($this->_value)) {
            foreach ($this->_value as $self) {

                $resTmp = $self['level1'];
				$resTmp .= JBCSVItem::SEP_CELL . $self['level2'];
				$resTmp .= JBCSVItem::SEP_CELL . $self['level3'];
				$resTmp .= JBCSVItem::SEP_CELL . $self['level4'];
				$resTmp .= JBCSVItem::SEP_CELL . $self['level5'];	
				$resTmp .= JBCSVItem::SEP_CELL . $self['image'];
                $result[] = $resTmp;
            }
        }

        if ((int)$this->_exportParams->get('merge_repeatable')) {
            return implode(JBCSVItem::SEP_ROWS, $result);
        } else {
            return $result;
        }
    }
   
   
    public function fromCSV($value, $position = null)
    {
        $data = ($position == 1) ? array() : $this->_element->data();

        if (strpos($value, JBCSVItem::SEP_ROWS)) {
            foreach (explode(JBCSVItem::SEP_ROWS, $value) as $val) {
                if (strpos($value, JBCSVItem::SEP_CELL) === false) {
                    $level1 = '';
					$level2 = '';
                    $level3 = '';
					$level4 = '';
                    $level5 = '';
					$image = '';
                } else {
                    list($level1, $level2, $level3, $level4, $level5, $image) = explode(JBCSVItem::SEP_CELL, $val);
                }

                $values[] = array(
                    'level1' => $this->_getString($level1),
                    'level2'  => $this->_getString($level2),
					'level3'  => $this->_getString($level3),
					'level4'  => $this->_getString($level4),
					'level5'  => $this->_getString($level5),
					'image'  => $this->_getString($image),
                );
            }
            $data = $values;
        } else {
            if (strpos($value, JBCSVItem::SEP_CELL) === false) {
                $level1 = '';
				$level2 = '';
                $level3 = '';
				$level4 = '';
                $level5 = '';
				$image = '';
            } else {
                list($level1, $level2, $level3, $level4, $level5, $image) = explode(JBCSVItem::SEP_CELL, $value);
            }

            if (!empty($file)) {
                $values = array(
                    'level1' => $this->_getString($level1),
                    'level2'  => $this->_getString($level2),
					'level3'  => $this->_getString($level3),
					'level4'  => $this->_getString($level4),
					'level5'  => $this->_getString($level5),
					'image'  => $this->_getString($image),
                );

                $data[] = $values;
            }
        }
        $this->_element->bindData($data);

        return $this->_item;
    }

}