<?php
// Запрещаем прямой доступ к файлу
defined('_JEXEC') or die('Restricted access');

// Регистрируем ElementRepeatable class

App::getInstance('zoo')->loader->register('ElementRepeatable', 'elements:repeatable/repeatable.php');

class ElementMenuKit extends ElementRepeatable implements iRepeatSubmittable {

	/* проверка введенности полей элемента */

	protected function _hasValue($params = array()) {
		
		if (class_exists('JBCart')) {

            if (is_null($this->_jbvalue)) {
                $value = $this->get('level4');
                $this->_jbvalue = JBCart::val($level4);
            }
			
        }
		
		
		$level1 = $this->get('level1', '');
		$level2 = $this->get('level2', '');
		$level3 = $this->get('level3', '');
		$level4 = $this->get('level4', '');
		$level5 = $this->get('level5', '');
		$image = $this->get('image', '');
		return !empty($level1) || !empty($level2) || !empty($level3) || !empty($level4) || !empty($level5) || !$this->_jbvalue->isEmpty();
	}
		
	/* добавление в поиск данных элемента */
	protected function _getSearchData() {
		return value;
	}
	
    /* Добавляем возможность подачи и редактирования в админке */
    protected function _edit()	{
		$this->app->document->addScript('elements:menukit/assets/js/imagepast.js');
		$this->app->document->addStylesheet('elements:menukit/assets/css/menukit.css');
		if ($layout = $this->getLayout('edit.php')) {			
			return $this->renderLayout($layout);
		}		
		return false;
	}
		
    /* Добавлем возмождность редактировать с фронта  */
    public function _renderSubmission($params = array()) {
        return $this->_edit();
	}		
		
    /* Вывод результатов */
    public function _render($params = array())
    {
		$this->app->document->addStylesheet('elements:menukit/assets/css/menukit.css');
				
		if ($layout = $this->getLayout('tmpl.php')) {

			$imwidth		= $params->get('imwidth', 150);
			$imheight		= $params->get('imheight', 150);
			$foolimwidth	= $params->get('foolimwidth', 800);
			$foolimheight	= $params->get('foolimheight', 600);
			$popupimage		= $params->get('popupimage', 0);
							
            return $this->renderLayout($layout, array(
					  'imwidth' 		=> $imwidth,
					  'imheight' 		=> $imheight,
					  'foolimwidth' 	=> $foolimwidth,
					  'popupimage' 		=> $popupimage,
					  'foolimheight' 	=> $foolimheight			
					  ));
        }
        return null;
    }


	//Валмдация элемента
	public function _validateSubmission($value, $params)
	{
		return array(
			'image'  => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('image')),
			'level1' => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('level1')),
			'level2' => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('level2')),
			'level3' => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('level3')),
			'level4' => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('level4')),
			'level5' => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('level5')),
		);
	}

}