<?php
defined('_JEXEC') or die;


class PlgUserUsersync extends JPlugin
{
	
	private $_count = 3;

	public function onUserBeforeSave($user, $isnew, $data)
	{
		$app = JFactory::getApplication();
		$data = (object)$data;

		$groups = $data->groups;

		unset($data->groups);
		unset($data->password_clear);
		unset($data->guest);
		unset($data->aid);
		unset($data->email1);
		unset($data->email2);
		unset($data->password1);
		unset($data->password2);
		
		
		$x=0;
		while ($x ++< $this->_count)
		{
			$db = $this->database($x);
			if ($db) {
				if ($isnew)
				{
					$query = $db->getQuery(true)
						->select($db->quoteName('id'))
						->select($db->quoteName('username'))
						->select($db->quoteName('email'))
						->from($db->quoteName('#__users'))
						->where($db->quoteName('username') . ' = ' . $db->quote($data->username) . ' OR ' . $db->quoteName('email') . ' = ' . $db->quote($data->email));
					$db->setQuery($query);
					$res = $db->loadObject();
					if ($res && $res->id) {
						if ($res->username == $data->username) $app->enqueueMessage(JText::_('COM_USERS_REGISTER_USERNAME_MESSAGE'), 'warning');
						if ($res->email == $data->email) $app->enqueueMessage(JText::_('COM_USERS_REGISTER_EMAIL1_MESSAGE'), 'warning');
						$app->redirect(JRoute::_('index.php?option=com_users&view=registration'));
					}
					$db->insertObject('#__users', $data, 'id');
					$data->id = (int) $db->insertid();
				}
				else
				{
					$query = $db->getQuery(true)
						->select($db->quoteName('id'))
						->from($db->quoteName('#__users'))
						->where($db->quoteName('username') . ' = ' . $db->quote($data->username));
					$db->setQuery($query);

					$data->id = (int) $db->loadResult();
					$db->updateObject('#__users', $data, 'id');
				}

				$data->groups = $groups;
//				unset($groups);

				$query = $db->getQuery(true);

				if (is_array($data->groups) && count($data->groups))
				{
					$query->delete($db->quoteName('#__user_usergroup_map'))
						->where($db->quoteName('user_id') . ' = ' . (int) $data->id);
					$db->setQuery($query);
					$db->execute();

					$query->clear()
						->insert($db->quoteName('#__user_usergroup_map'))
						->columns(array($db->quoteName('user_id'), $db->quoteName('group_id')));

					foreach ($data->groups as $group)
					{
						$query->clear('values')
							->values($data->id . ', ' . $group);
						$db->setQuery($query);
						$db->execute();
					}
				}
			}
		}
		
		
		return true;
		
	}
	
	public function onUserAfterDelete($user, $success, $msg)
	{
		if (!$success)
		{
			return false;
		}
		
		$x=0; while ($x ++< $this->_count)
		{
			$db = $this->database($x);
			if ($db) {
				$query = $db->getQuery(true)
				->delete($db->quoteName('#__users'))
				->where($db->quoteName('username') . ' = ' .  $db->quote($user['username']));
				$db->setQuery($query)->execute();
			}
		}

		return true;
	}
	
	public function onUserAfterLogin($options)
	{
		
		$username = $options['user']->username;
		
		
		if (!$username) return true;
		
		$session = JFactory::getSession();
		
		$x=0; while ($x ++< $this->_count)
		{
			$db = $this->database($x);
			if ($db) {
				$query = $db->getQuery(true)
						->select($db->quoteName('id'))
						->from($db->quoteName('#__users'))
						->where($db->quoteName('username') . ' = ' . $db->quote($username));
					$db->setQuery($query);
				$userID = (int) $db->loadResult();
				
				if ($userID) {
					$query = $db->getQuery(true)
							->select($db->quoteName('session_id'))
							->from($db->quoteName('#__session'))
							->where($db->quoteName('session_id') . ' = ' . $db->quote($session->getId()));
							$db->setQuery($query);
					$session_id = $db->loadResult();
					$data = '__default|'.serialize($_SESSION['__default']);
					if ($session_id) {
						$query = $db->getQuery(true)
							->update($db->quoteName('#__session'))
							->set($db->quoteName('guest') . ' = ' . $db->quote($options['user']->guest))
							->set($db->quoteName('data') . ' = ' . $db->quote($data))
							->set($db->quoteName('username') . ' = ' . $db->quote($username))
							->set($db->quoteName('userid') . ' = ' . (int) $userID)
							->where($db->quoteName('session_id') . ' = ' . $db->quote($session->getId()));
					} else {
						$query = $db->getQuery(true)
							->insert($db->quoteName('#__session'))
							->set($db->quoteName('time') . ' = ' . $db->quote(time()))
							->set($db->quoteName('guest') . ' = ' . $db->quote($options['user']->guest))
							->set($db->quoteName('data') . ' = ' . $db->quote($data))
							->set($db->quoteName('username') . ' = ' . $db->quote($username))
							->set($db->quoteName('userid') . ' = ' . (int) $userID)
							->set($db->quoteName('session_id') . ' = ' . $db->quote($session->getId()));
					}
					$db->setQuery($query)->execute();
				}
			}
		}
		
		return true;
	}
	
	public function onUserLogout($user, $options = array())
	{
		
		$x=0; while ($x ++< $this->_count)
		{
			$db = $this->database($x);
			if ($db) {
				$query = $db->getQuery(true)
					->delete($db->quoteName('#__session'))
					->where($db->quoteName('userid') . ' = ' . (int) $user['id'])
					->where($db->quoteName('client_id') . ' = ' . (int) $options['clientid']);
				$db->setQuery($query)->execute();
			}
		}
		
		return true;
	}
	
	public function database($x)
	{
		if (
		!$this->params->get('dbuser'.$x) || 
		!$this->params->get('password'.$x) || 
		!$this->params->get('database'.$x) || 
		!$this->params->get('prefix'.$x)
		) 
		{
			return 0;
		}
		
		$dbuser = $this->params->get('dbuser'.$x);
		$password = $this->params->get('password'.$x);
		$database = $this->params->get('database'.$x);
		$prefix = $this->params->get('prefix'.$x);
		$options = array('host' => $this->params->get('host'), 'user' => $dbuser, 'password' => $password, 'database' => $database, 'prefix' => $prefix);
		$db = JDatabaseDriver::getInstance($options);
		
		return $db;
	}


}
