<?php
/**
 * @package   FL Simple Rating Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC') or die('Restricted access'); 

$link = $this->app->link(array('task' => 'callelement', 'format' => 'raw', 'item_id' => $this->_item->id, 'element' => $this->identifier), false);

$uniqid = uniqid($this->identifier.'-');

$showRating = $this->config->get('rating', 1);

?>

<div id="<?php echo $uniqid; ?>">
	<div class="uk-button-group">
		<div data-uk-dropdown="{mode:'hover'}">
		    <button class="uk-button jsVote <?php echo $minusActive ? 'uk-active' : ''; ?>" data-vote="minus">
		    	<i class="uk-icon-thumbs-down uk-text-danger"></i> <span class="flsimplerating-count"><?php echo $minusCount ? $minusCount : '0'; ?></span> <?php echo $minusCount ? '<i class="uk-icon-caret-down"></i>' : ''; ?>	    	
		    </button>
		    <?php if ($minusCount) {
		    	echo '<div class="uk-dropdown uk-dropdown-scrollable">';
		    	echo '<ul class="uk-nav uk-nav-dropdown">';
		    	foreach ($minus as $value) {
		    		$user = JFactory::getUser($value);
		    		$username = $user->username;
		    		echo '<li><a href="#">'.$username.'</a></li>';
		    	}
		    	echo '</ul>';
		    	echo '</div>';
		    } ?>
		</div>

		<?php if ($showRating == 1) : ?>
			<button class="uk-button uk-button-primary"><?php echo $rating; ?></button>
		<?php endif; ?>

		<div data-uk-dropdown="{mode:'hover'}">
		    <button class="uk-button jsVote <?php echo $plusActive ? 'uk-active' : ''; ?>" data-vote="plus">
		    	<i class="uk-icon-thumbs-up uk-text-success"></i> <span class="flsimplerating-count"><?php echo $plusCount ? $plusCount : '0'; ?></span> <?php echo $plusCount ? '<i class="uk-icon-caret-down"></i>' : ''; ?>
		    </button>
		    <?php if ($plusCount) {
		    	echo '<div class="uk-dropdown uk-dropdown-scrollable">';
		    	echo '<ul class="uk-nav uk-nav-dropdown">';
		    	foreach ($plus as $value) {
		    		$user = JFactory::getUser($value);
		    		$username = $user->username;
		    		echo '<li><a href="#">'.$username.'</a></li>';
		    	}
		    	echo '</ul>';
		    	echo '</div>';
		    } ?>
		</div>
	</div>

	<script type="text/javascript">
		jQuery('#<?php echo $uniqid; ?>').FLSimpleRating({
			url: '<?php echo $link; ?>',
			element: '<?php echo $uniqid; ?>',
			canVote: '<?php echo $canVote ? "1" : "0"; ?>',
			returnUrl: '<?php echo $returnUrl; ?>'
		});
	</script>
</div>