<?php
/**
 * @package   FL Simple Rating Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

class ElementFLSimpleRating extends Element {

	public function __construct() {
        parent::__construct();
        $this->registerCallback('vote');

        if ($this->app->system->application->isAdmin()) {
            $this->registerCallback('reset');
        }
    }

    // Vote Ajax Function

    public function vote($vote) {

        $rating = $this->get('rating', 0);
        $plus = $this->get('plus', array());
        $minus = $this->get('minus', array());

        $userID = $this->getUserIdentificator();

        $posMinus = array_search($userID, $minus);
        $posPlus = array_search($userID, $plus);

        if ($posPlus === false && $posMinus === false) { // Пользователь еще не проголосовал
            if ($vote == 'minus') {
                $rating--;
                $minus[] = $userID;
            } elseif ($vote == 'plus') {
                $rating++;
                $plus[] = $userID;
            }
        } elseif($posMinus !== false) { // Пользователь уже проголосовал за минус
            unset($minus[$posMinus]);
            $rating++;
            if ($vote == 'plus') {
                $rating++;
                $plus[] = $userID;
            }
        } elseif($posPlus !== false) { // Пользователь уже проголосовал за плюс
            unset($plus[$posPlus]);
            $rating--;
            if ($vote == 'minus') {
                $rating--;
                $minus[] = $userID;
            }
        }

        $this->set('rating', $rating);
        $this->set('minus', $minus);
        $this->set('plus', $plus);

        $this->app->table->item->save($this->getItem());

        $res = array(
            'rating' => $rating,
            'minus'  => count($minus),
            'plus'   => count($plus),
            'html'   => $this->render()
        );

    	return json_encode($res);
    }

    // Reset Rating Ajax On Edit Function

    public function reset() {

        $rating = 0;
        $plus = array();
        $minus = array();

        $this->set('rating', $rating);
        $this->set('minus', $minus);
        $this->set('plus', $plus);

        $this->app->table->item->save($this->getItem());

        return $this->edit();
    }

    // Has Value Function

	public function hasValue($params = array()) {
		return true;
	}

    // Get Data For Search  Function

    public function getSearchData() {
        $rating = $this->get('rating', 0);
        return $rating;
    }

    // Get Config Form Function

    public function getConfigForm() {
        $form = parent::getConfigForm();
        $form->addElementPath($this->app->path->path('elements:flsimplerating/fields'));
        return $form;
    }


    // Render Function

	public function render($params = array()) {
        $this->app->document->addScript('elements:flsimplerating/assets/js/flsimplerating.min.js');

        $canVote = false;
        $plusActive = $minusActive = false;

        $plus = $this->get('plus', array());
        $minus = $this->get('minus', array());
        $rating = $this->get('rating', 0);

        $method = $this->config->get('method', 'users');
        $enterMenuId = $this->config->get('menu', '');

        $plusCount = count($plus);
        $minusCount = count($minus);

        $enterUrl = $enterMenuId ? JRoute::_(JFactory::getApplication()->getMenu()->getItem($enterMenuId)->link).'?return=' : '/index.php?option=com_users&view=login&return=';
        $returnUrl = base64_encode(JRoute::_($this->app->route->item($this->getItem(), false), false, 2));

        $template = $this->config->get('template', 'simple');

        $user = JFactory::getUser();

        if (!$user->guest || $method == 'ip') {
            $canVote = true;
            $userId = $this->getUserIdentificator();
            if (in_array($userId, $minus)) {
                $minusActive = true;
            } elseif (in_array($userId, $plus)) {
                $plusActive = true;
            }
        }

        if ($layout = $this->getLayout('flsimplerating_'.$template.'.php')) {
            return $this->renderLayout($layout, compact('rating', 'plus', 'minus','plusCount', 'minusCount', 'canVote', 'method', 'enterUrl','returnUrl', 'plusActive', 'minusActive'));
        }

        return null;
	}

    // Edit Function

	public function edit() {
		$controller = $this->app->request->getWord('controller');
        $url = $this->app->link(array('controller' => $controller, 'format' => 'raw', 'type' => $this->getType()->identifier, 'elm_id' => $this->identifier, 'item_id' => $this->getItem()->id, 'task' => 'callelement'), false);

        // render layout
        if ($layout = $this->getLayout('edit.php')) {
            return $this->renderLayout($layout, compact('url'));
        }
	}

    // Get User Identificator Function

    public function getUserIdentificator() {
        $method = $this->config->get('method', 'users');
        if ($method == 'users') {
            $user   = JFactory::getUser();
            $userID = $user->id;
        } elseif ($method == 'ip') {
            $userID = $this->app->useragent->ip();
        }

        return $userID;
    }
}
