<?php
/**
 * @package   FL Simple Rating Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC') or die('Restricted access'); 

$link = $this->app->link(array('task' => 'callelement', 'format' => 'raw', 'item_id' => $this->_item->id, 'element' => $this->identifier), false);

$uniqid = uniqid($this->identifier.'-');

$showRating = $this->config->get('rating', 1);

?>

<div id="<?php echo $uniqid; ?>" class="<?php echo $this->identifier; ?>">
	<div class="uk-button-group">
		<button class="uk-button jsVote <?php echo $minusActive ? 'uk-active' : ''; ?>" data-vote="minus">
		    	<i class="uk-icon-thumbs-down uk-text-danger"></i> <span class="flsimplerating-count"><?php echo $minusCount ? $minusCount : '0'; ?></span>	    	
		</button>

		<?php if ($showRating == 1) : ?>
			<button class="uk-button uk-button-primary"><?php echo $rating; ?></button>
		<?php endif; ?>

		<button class="uk-button jsVote <?php echo $plusActive ? 'uk-active' : ''; ?>" data-vote="plus">
		    	<i class="uk-icon-thumbs-up uk-text-success"></i> <span class="flsimplerating-count"><?php echo $plusCount ? $plusCount : '0'; ?></span>
		</button>
	</div>

	<script type="text/javascript">
		jQuery('#<?php echo $uniqid; ?>').FLSimpleRating({
			url: '<?php echo $link; ?>',
			element: '<?php echo $uniqid; ?>',
			canVote: '<?php echo $canVote ? "1" : "0"; ?>',
			method: '<?php echo $method; ?>',
			enterUrl: '<?php echo $enterUrl; ?>',
			returnUrl: '<?php echo $returnUrl; ?>'
		});
	</script>
</div>