/**
 * @package   FL Simple Rating Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

(function($){
    var methods = {
        init : function(options) {

            var flsimplerating = function() {

                $('#' + options.element + ' .jsVote').on("click", function(event) {
                    event.preventDefault();

                    $button = $(this);
                    var vote = $button.data('vote');

                    if (options.canVote == 0 && options.method == 'users') {
                        var signIn = confirm("Чтобы проголосовать, Вам необходимо авторизоваться");
                        if (signIn) {
                            document.location.href = options.enterUrl + options.returnUrl;
                        };
                    } else {
                        jQuery.ajax({
                            type: 'POST',
                            url: options.url,
                            data: {method: 'vote', 'args[0]': vote},
                            beforeSend: function() {
                                //$button.find('i').attr('class', 'uk-icon-refresh uk-icon-spin');
                            },
                            success: function(data) {
                                var data = $.parseJSON(data);
                                $('#' + options.element).replaceWith(data.html);;
                            }
                        })
                    }

                })
            }

            return this.each(flsimplerating);
        }
    };

    $.fn.FLSimpleRating = function(method) {
        
        if ( methods[method] ) {
            return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
        } else if ( typeof method === 'object' || ! method ) {
            return methods.init.apply( this, arguments );
        } else {
            $.error('Метод с именем ' +  method + ' не существует для FLSimpleRating');
        } 
    };

})(jQuery);