<?php
/**
 * @package   FL Simple Rating Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC') or die('Restricted access'); 

$uniqid = uniqid('flsimplerating-');

$rating = $this->get('rating', 0);

$plus = $this->get('plus', array());
$minus = $this->get('minus', array());

$plusCount = count($plus);
$minusCount = count($minus);

?>

<div id="<?php echo $uniqid; ?>">
	<div class="row">
	    <span class="label label-important fl-minus"><i class="icon-thumbs-down"></i> <span class="fl-count"><?php echo $minusCount; ?></span></span>
	    <span class="label label-info fl-rating fl-count"><?php echo $rating; ?></span>
	    <span class="label label-success fl-plus"><i class="icon-thumbs-up"></i> <span class="fl-count"><?php echo $plusCount; ?></span></span>
	</div>
	<div class="row">
		<button class="btn">Сбросить рейтинг</button>
	</div>
	<div class="row flsimpleratingvalues hidden">
			<?php echo $this->app->html->_('control.text', $this->getControlName('rating'), $rating, ''); ?>

			<?php
				if (!empty($plus)) {
					echo $this->app->html->_('control.text', $this->getControlName('plus'), implode(',', $plus), '');
				}
			?>
	
			<?php
				if (!empty($minus)) {
					echo $this->app->html->_('control.text', $this->getControlName('minus'), implode(',', $minus), '');
				}
			?>
	</div>

	<script type="text/javascript">
		jQuery('#<?php echo $uniqid; ?> button').on('click', function() {

	       	jQuery.ajax({
	            type: 'POST',
	            url: '<?php echo $url; ?>',
	            data: {method: 'reset'},
	            success: function(data) {
	            	var data = jQuery.parseJSON(data);
	                jQuery('#<?php echo $uniqid; ?>').replaceWith(data.html);
	            }
	        })

	    	return false;
		})
	</script>
</div>