/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Alexander Oganov <t_tapak@yahoo.com>
 */

;
(function ($, window, document, undefined) {

    JBZoo.widget('JBZoo.PriceValidator.Multi', {},
        {
            init: function ($this) {

                this.constructor.parent.init.apply($this);
            },

            validate: function () {
                this.errors = {};
                this.errors = this.duplicates();

                return this.errors;
            },

            clear: function () {

                var $this = this;
                this.$('.jbprice-variation-row').each(function (i, row) {
                    $this.clearRow(row);
                });

                return this;
            },

            clearRow: function (row) {
                var $row = $(row);
                this.clearMessages($row);

                return this;
            },

            fill: function () {
                var $this = this;
                this.$('.jbprice-variation-row').each(function (i, row) {
                    var $row = $(row);
                    $this.addOptions($row);
                });

                return this;
            },

            getErrors: function () {

                this.validate();
                if (JBZoo.empty(this.errors)) {
                    return false;
                }

                var $this      = this,
                    variations = this.$('.jbprice-variation-row');
                $.each(this.errors, function (key, error) {
                    var variants = $(variations.get(error.variant)),
                        params   = $('.simple-param', variants),
                        label    = $('.jsVariantLabel', variants);

                    $this.message(label, $this.options.message_variant_invalid);
                    $.each(error.index, function (index) {
                        var param = params.get(index);

                        $this.message(param, $this.options.message_duplicate_values);
                    });
                });

                return this.errors;
            }
        }
    );

})(jQuery, window, document);
