<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBCartElementHookAddUser
 */
class JBCartElementHookAddUser extends JBCartElementHook
{
    /**
     * {@inheritdoc}
     */
    public function __construct(App $app, $type, $group)
    {
        parent::__construct($app, $type, $group);

        require_once JPATH_ROOT . '/components/com_users/models/registration.php';

        jimport('joomla.mail.helper');
        jimport('joomla.user.helper');

        $this->_loadLangs();
        JFactory::getLanguage()->load('com_users', JPATH_ROOT, null, true);
    }

    /**
     * @param $params
     */
    public function notify($params = array())
    {
        $currentUser = JFactory::getUser();

        if ($currentUser->id) {
            return; // Only for guests
        }

        $order = $this->getOrder();
        if (!$order || !$order->id) {
            return;
        }

        $fields = array('email', 'realname', 'login', 'password');
        $data   = array('block' => 0);

        foreach ($fields as $fieldKey) {

            if ($element = $order->getFieldElement($this->config->find($fieldKey . '.0'))) {

                $value = $element->get('value');

                if ($fieldKey == 'login') {
                    $data['username'] = $value ? $value : $data['email1'];

                } elseif ($fieldKey == 'realname') {
                    $data['name'] = $value ? $value : $data['email1'];

                } elseif ($fieldKey == 'email') {
                    $data['email1'] = $value;

                } elseif ($fieldKey == 'password') {
                    $value = $value ? $value : JUserHelper::genRandomPassword();

                    $data['password1'] = $value;
                    $data['password2'] = $value;
                }
            }
        }

        $model  = new UsersModelRegistration();
        $userId = $model->register($data);

        if ((int)$userId > 0) {
            $order->created_by = $userId;
            JBModelOrder::model()->save($order, true);
        }

        if ((int)$this->config->get('auth', 0) && $data['username'] && $data['password1']) {
            JFactory::getApplication()->login(array(
                'username' => $data['username'],
                'password' => $data['password1']
            ));
        }
    }
}
