<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Vitaliy Yanovskiy <joejoker@jbzoo.com>
 * @coder       Oganov Alexander <t_tapakm@yahoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBZooModFlyRuleText
 */
class JBZooModFlyRuleText
{
    /**
     * @param $key
     * @param $value
     * @return array
     */
    public function validateValues($key, $value)
    {
        if (!empty($value)) {
            if (strpos($value, '/')) {
                $result[$key] = array('range' => $value);
            } else {
                $result[$key] = $value;
            }

            return $result;
        }

        return false;
    }
}

/**
 * Class JBZooModFlyRuleRating
 */
class JBZooModFlyRuleRating
{
    /**
     * @param $key
     * @param $value
     * @return array
     */
    public function validateValues($key, $value)
    {
        if (!empty($value)) {
            return array($key => $value);
        }

        return false;
    }
}

/**
 * Class JBZooModFlyRuleItemCategory
 */
class JBZooModFlyRuleItemCategory extends JBZooModFlyRuleText
{
    /**
     * @param $key
     * @param $value
     * @return array
     */
    public function validateValues($key, $value)
    {
        $app    = App::getInstance('zoo');
        $result = array();

        if (preg_match("/[0-9]/", $value)) {
            $result[$key] = $value;
        } else {
            $slug = $app->string->sluggify($value);
            $cat  = JBModelCategory::model()->getByAlias($slug);
            if (!empty($cat)) {
                $result[$key] = $cat->id;
            }

        }

        return !empty($result) ? $result : false;
    }
}

/**
 * Class JBZooModFlyRuleItemDate
 */
class JBZooModFlyRuleItemDate extends JBZooModFlyRuleText
{
    /**
     * @param $key
     * @param $value
     * @return mixed
     */
    public function validateValues($key, $value)
    {
        if (strpos($value, '/')) {
            $result[$key]['range'] = explode('/', $value);
        } else {
            $result[$key] = $value;
        }

        return $result;
    }

}

/**
 * Class JBZooModFlyRuleDate
 */
class JBZooModFlyRuleDate extends JBZooModFlyRuleItemDate
{
    /**
     * @param $key
     * @param $value
     * @return mixed
     */
    public function validateValues($key, $value)
    {
        if (strpos($value, '/')) {
            $result[$key]['range-date'] = explode('/', $value);
        } else {
            $result[$key] = $value;
        }

        return $result;
    }
}

/**
 * Class JBZooModFlyRulePrice
 */
class JBZooModFlyRuleJBPrice extends JBZooModFlyRuleText
{
    /**
     * @var App
     */
    public $app;

    /**
     * Array of element config
     * @var array
     */
    protected $_element = array();

    /**
     * UUID of element
     * @var string|null
     */
    protected $_element_id = null;

    /**
     * UUID of price element
     * @var string|null
     */
    protected $_param_id = null;

    /**
     * @param $elem_id
     * @param $param_id
     * @param $value
     * @return array
     */
    public function validateElements($elem_id, $param_id, $value)
    {
        $params    = null;
        $this->app = App::getInstance('zoo');
        $elements  = $this->app->jbentity->getItemTypesData(false);

        $this->_element    = $elements[$elem_id];
        $this->_element_id = $elem_id;
        $this->_param_id   = $param_id;
        $result[$elem_id]  = array();

        $value = JString::trim($value);

        unset($elements);
        if ($param_id == '_value') {
            $params[$param_id] = $this->_validateValue($value);

        } elseif ($param_id == '_balance') {
            $params[$param_id] = $this->_validateBalance($value);

        } elseif (in_array($param_id, array('_image', '_discount'))) {
            $params[$param_id] = $this->_validateBool($value);

        } elseif ($this->_validateDate($value)) {
            $params[$param_id] = $this->_validateDate($value);

        } else {
            $params[$param_id] = $this->_validateDefault($value);

        }

        if (isset($params[$param_id])) {
            $result[$elem_id] = $params;
        }

        return $result;
    }

    /**
     * @param $value
     * @return int|string
     */
    protected function _validateValue($value)
    {
        $result = array();
        if (strpos($value, '/')) {
            $result['range'] = $value;

        } elseif (is_numeric($value)) {
            $result['value'] = $this->app->jbmoney->clearValue($value);

        }

        return $result;
    }

    /**
     * @param $value
     * @return mixed
     */
    protected function _validateBalance($value)
    {
        return $value;
    }

    /**
     * @param $value
     * @return int
     */
    protected function _validateBool($value)
    {
        return (int)$value;
    }

    /**
     * @param $date
     * @return mixed
     */
    protected function _validateDate($date)
    {
        $result = array();

        if (strpos($date, '/')) {
            list($from, $to) = explode('/', $date);

            if ($this->_isDate($from) && $this->_isDate($to)) {
                $result = array($from, $to);
            }

        } else {
            if ($this->_isDate($date)) {
                $result[] = $date;
            }
        }

        return empty($result) ? false : $result;
    }

    /**
     * Check if value seems like date
     * @param string $date
     * @param string $format
     * @return bool
     */
    protected function _isDate($date, $format = 'Y-m-d')
    {
        $dateObj = DateTime::createFromFormat($format, $date);

        return $dateObj && $dateObj->format($format) == $date;
    }

    /**
     * @param $value
     * @return mixed
     */
    protected function _validateDefault($value)
    {
        return $value;
    }

    /**
     * @param $exVal
     * @return mixed
     */
    protected function _getFlag($exVal)
    {
        $result = array();

        if (!is_array($exVal)) {
            $exVal = (array)$exVal;
        }

        foreach ($exVal as $val) {

            if (strpos($val, '/')) {
                $result['range'] = $val;

            } elseif ($flags = $this->_getOptions($val)) {
                $result = array_merge($result, $flags);

            } elseif (is_numeric($val)) {
                $result['val'] = $val;

            }

        }

        return $result;
    }

    /**
     * @param $val
     * @return null | array
     */
    protected function _getOptions($val)
    {
        $result = null;

        if (trim($val) == 'balance') {
            $result['balance'] = 1;

        } elseif (trim($val) == 'hit') {
            $result['hit'] = 1;

        } elseif (trim($val) == 'new') {
            $result['new'] = 1;

        } elseif (trim($val) == 'sale') {
            $result['sale'] = 1;
        }

        return $result;
    }

}

class JBZooModFlyRuleJBPricePlain extends JBZooModFlyRuleJBPrice
{

}

class JBZooModFlyRuleJBPriceCalc extends JBZooModFlyRuleJBPrice
{

}

/**
 * Class JBZooModFlyRuleItemFrontPage
 */
class JBZooModFlyRuleItemFrontPage extends JBZooModFlyRuleText
{

    /**
     * @param $key
     * @param $value
     * @return mixed
     */
    public function validateValues($key, $value)
    {
        if (!empty($value) || $value === '0') {
            $result[$key] = $value;

            return $result;
        } else {
            return false;
        }
    }
}


/**
 * Class JBZooModFlyRuleJBSelectCascade
 */
class JBZooModFlyRuleJBSelectCascade extends JBZooModFlyRuleText
{

    /**
     * @param $key
     * @param $value
     * @return array
     */
    public function validateValues($key, $value)
    {
        if (strpos($value, '||')) {
            $exVal = explode('||', $value);
        } else {
            $exVal = $value;
        }

        $result[$key] = $exVal;

        return $result;
    }
}

/**
 * Class JBZooModFlyRuleJBImage
 */
class JBZooModFlyRuleJBImage extends JBZooModFlyRuleText
{
    /**
     * @param $key
     * @param $value
     * @return string
     */
    public function validateValues($key, $value)
    {
        if ($value == '1') {
            $value = JBModelElementJBImage::IMAGE_EXISTS;
        } elseif ($value != '' && $value == '0') {
            $value = JBModelElementJBImage::IMAGE_NO_EXISTS;
        }

        if (!empty($value)) {
            $result[$key] = $value;

            return $result;
        }

        return false;
    }
}

/**
 * Class JBZooModFlyRuleImage
 */
class JBZooModFlyRuleImage extends JBZooModFlyRuleText
{

    /**
     * @param $key
     * @param $value
     * @return string
     */
    public function validateValues($key, $value)
    {
        if (!empty($value)) {
            $result[$key] = $value;

            return $result;
        }

        return null;
    }
}

/**
 * Class JBZooModFlyRuleItemAuthor
 */
class JBZooModFlyRuleItemAuthor extends JBZooModFlyRuleText
{
    /**
     * @param $key
     * @param $value
     * @return array
     */
    public function validateValues($key, $value)
    {
        if (!empty($value)) {
            $result[$key] = $value;

            return $result;
        }

        return null;
    }
}

/**
 * Class JBZooModFlyRuleItemName
 */
class JBZooModFlyRuleItemName extends JBZooModFlyRuleText
{
    /**
     * @param $key
     * @param $value
     * @return array
     */
    public function validateValues($key, $value)
    {
        if (!empty($value)) {
            $result[$key] = $value;

            return $result;
        }

        return null;
    }
}

/**
 * Class JBZooModFlyRuleItemTag
 */
class JBZooModFlyRuleItemTag extends JBZooModFlyRuleText
{
    /**
     * @param $key
     * @param $value
     * @return array
     */
    public function validateValues($key, $value)
    {
        if (!empty($value)) {
            $result[$key] = $value;

            return $result;
        }

        return null;
    }
}