<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Sergey Gutnikov <info@obago.ru>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Class JBCartElementNotificationCallBack
 */
class JBCartElementNotificationAffiliate extends JBCartElementNotification
{

   const FIELD_USERMAIL = 'usermail';
    const FIELD_SITEMAIL = 'sitemail';

    /**
     * @var JMail
     */
    protected $_mailer;

    /**
     * @var EmailRenderer
     */
    protected $_renderer;

    /**
     * Class constructor
     * @param App    $app
     * @param string $type
     * @param string $group
     */
    public function __construct($app, $type, $group)
    {
        parent::__construct($app, $type, $group);

        $this->_mailer   = JFactory::getMailer();
        $this->_renderer = $this->app->jbrenderer->create('email');
    }

    /**
     * Launch notification
     * @return string
     */
    public function notify()
    {
$pticeaf = $this->_order->getTotalForItems()->plain();
$conversion_data = array(
    "name" => $this->_getMailSubject(),
    "component" => "com_zoo",
    "extended_name" => $this->getOrder()->id,
    "reference_id" => $this->getOrder()->id,
    "type" => 1,
     "value" => preg_replace('/\s/', '', $pticeaf),

    "approved" => (int)$this->config->get('approved', 0),
);
 
require_once(JPATH_SITE.DIRECTORY_SEPARATOR.'components'.DIRECTORY_SEPARATOR.'com_affiliatetracker'.DIRECTORY_SEPARATOR.'helpers'.DIRECTORY_SEPARATOR.'helpers.php');
AffiliateHelper::create_conversion($conversion_data, $user_id);


    }



   

    /**
     * Get mail subject from config
     * @return string
     */
    protected function _getMailSubject()
    {
        $subject = $this->config->get('subject');
        $subject = $this->_macros->renderText($subject, $this->getOrder());
        $subject = JString::trim($subject);

        if (empty($subject)) {
            $subject = $this->getName();
        }

        return $subject;
    }




}
