<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Sergey Gutnikov <info@obago.ru>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
/**
 * Class JBCartElementNotificationBitrix
 */
class JBCartElementNotificationBitrix extends JBCartElementNotification
{

 const FIELD_USERMAIL = 'usermail';
    const FIELD_SITEMAIL = 'sitemail';

    /**
     * @var JMail
     */
    protected $_mailer;

    /**
     * @var EmailRenderer
     */
    protected $_renderer;

    /**
     * Class constructor
     * @param App    $app
     * @param string $type
     * @param string $group
     */
    public function __construct($app, $type, $group)
    {
        parent::__construct($app, $type, $group);

        $this->_mailer   = JFactory::getMailer();
        $this->_renderer = $this->app->jbrenderer->create('email');
    }

    /**
     * @param $params
     */
    public function notify($params = array())
    {

        $order = $this->getOrder();
        if (!$order || !$order->id) {
            return;
        }

        $fields = array('telephone', 'email', 'realname', 'comment', 'companytitle', 'lastname', 'secondname', 'postd', 'adress', 'phonemobile', 'phonefax', 'phonehome', 'webwork', 'webfacebook', 'emailwork', 'imskype', 'imicq');
        $data   = array('block' => 0);

        foreach ($fields as $fieldKey) {

            if ($element = $order->getFieldElement($this->config->find($fieldKey . '.0'))) {

                $value = $element->get('value');

                if ($fieldKey == 'telephone') {
                    $data['telephone'] = $value;

                } elseif ($fieldKey == 'email') {
                    $data['email'] = $value;

                } elseif ($fieldKey == 'realname') {
                    $data['realname'] = $value;

                } elseif ($fieldKey == 'comment') {
                    $data['comment'] = $value;

                } elseif ($fieldKey == 'companytitle') {
                    $data['companytitle'] = $value;

                } elseif ($fieldKey == 'lastname') {
                    $data['lastname'] = $value;

                } elseif ($fieldKey == 'secondname') {
                    $data['secondname'] = $value;

                } elseif ($fieldKey == 'postd') {
                    $data['postd'] = $value;

                } elseif ($fieldKey == 'adress') {
                    $data['adress'] = $value;

                } elseif ($fieldKey == 'phonemobile') {
                    $data['phonemobile'] = $value;

                } elseif ($fieldKey == 'phonefax') {
                    $data['phonefax'] = $value;

                } elseif ($fieldKey == 'phonehome') {
                    $data['phonehome'] = $value;

                } elseif ($fieldKey == 'webwork') {
                    $data['webwork'] = $value;

                } elseif ($fieldKey == 'webfacebook') {
                    $data['webfacebook'] = $value;

                } elseif ($fieldKey == 'emailwork') {
                    $data['emailwork'] = $value;

                } elseif ($fieldKey == 'imskype') {
                    $data['imskype'] = $value;

                } elseif ($fieldKey == 'imicq') {
                    $data['imicq'] = $value;

                }
            }
        }



// CRM server conection data
//define(' $this->config->get('host')', '$this->config->get('host')'); // your CRM domain name
define('CRM_PORT', '443'); // CRM server port
define('CRM_PATH', '/crm/configs/import/lead.php'); // CRM server REST service path

// CRM server authorization data
//define('$this->config->get('login')', '$this->config->get('login')'); // login of a CRM user able to manage leads
//define('$this->config->get('password')', '$this->config->get('password')'); // password of a CRM user
// OR you can send special authorization hash which is sent by server after first successful connection with login and password
//define('CRM_AUTH', 'e54ec19f0c5f092ea11145b80f465e1a'); // authorization hash

/********************************************************************************************/

// POST processing


    // get lead data from the form
    $postData = array(
        'TITLE' => $this->_getMailSubject(),
        'NAME' => $data['realname'],
        'EMAIL_HOME' => $data['email'],
        'COMMENTS' => $data['comment'].$this->_order->getTotalForItems(),
        'PHONE_WORK' => $data['telephone'],
        'COMPANY_TITLE' => $data['companytitle'],
        'LAST_NAME' => $data['lastname'],
        'SECOND_NAME' => $data['secondname'],
        'POST' => $data['postd'],
        'ADDRESS' => $data['adress'],
//        'OPPORTINUTY' => preg_replace('/\s/', '', $pticeaf),
        'OPPORTINUTY' => $this->_order->getTotalForItems(),
        'PHONE_MOBILE' => $data['phonemobile'],
        'PHONE_FAX' => $data['phonefax'],
        'PHONE_HOME' => $data['phonehome'],
        'WEB_WORK' => $data['webwork'],
        'WEB_FACEBOOK' => $data['webfacebook'],
        'EMAIL_WORK' => $data['emailwork'],
        'IM_SKYPE' => $data['imskype'],
        'IM_ICQ' => $data['imicq'],
        'SOURCE_ID' => 'WEB',
        'CURRENCY_ID' => $this->config->get('currenb'),
    );

    // append authorization data
    if (defined('CRM_AUTH'))
    {
        $postData['AUTH'] = CRM_AUTH;
    }
    else
    {
        $postData['LOGIN'] = $this->config->get('login');
        $postData['PASSWORD'] = $this->config->get('password');
    }

    // open socket to CRM
    $fp = fsockopen("ssl://". $this->config->get('host'), CRM_PORT, $errno, $errstr, 30);
    if ($fp)
    {
        // prepare POST data
        $strPostData = '';
        foreach ($postData as $key => $value)
            $strPostData .= ($strPostData == '' ? '' : '&').$key.'='.urlencode($value);

        // prepare POST headers
        $str = "POST ".CRM_PATH." HTTP/1.0\r\n";
        $str .= "Host: ". $this->config->get('host')."\r\n";
        $str .= "Content-Type: application/x-www-form-urlencoded\r\n";
        $str .= "Content-Length: ".strlen($strPostData)."\r\n";
        $str .= "Connection: close\r\n\r\n";

        $str .= $strPostData;

        // send POST to CRM
        fwrite($fp, $str);

        // get CRM headers
        $result = '';
        while (!feof($fp))
        {
            $result .= fgets($fp, 128);
        }
        fclose($fp);

        // cut response headers
        $response = explode("\r\n\r\n", $result);

        $output = '<pre>'.print_r($response[1], 1).'</pre>';
    }
    else
    {
        echo 'Connection Failed! '.$errstr.' ('.$errno.')';
    }





    }



        /**
     * Get mail subject from config
     * @return string
     */
    protected function _getMailSubject()
    {
        $subject = $this->config->get('subject');
        $subject = $this->_macros->renderText($subject, $this->getOrder());
        $subject = JString::trim($subject);

        if (empty($subject)) {
            $subject = $this->getName();
        }

        return $subject;
    }
}
