<?php
// Запрещаем прямой доступ к файлу
defined('_JEXEC') or die('Restricted access');

// Регистрируем ElementRepeatable class

App::getInstance('zoo')->loader->register('ElementRepeatable', 'elements:repeatable/repeatable.php');
App::getInstance('zoo')->loader->register('ElementOption', 'elements:option/option.php');


class ElementUniTableKit extends ElementRepeatable implements iRepeatSubmittable {

	/* проверка введенности полей элемента */

	protected function _hasValue($params = array()) {
		
		if (class_exists('JBCart')) {
			$price = "";
            if (is_null($this->_jbvalue)) {
                $value = $this->get('price');
                $this->_jbvalue = JBCart::val($price);

            }
			
        }		
		$title_sep = $this->get('title_sep', '');
		$col_1 = $this->get('col_1', '');
		$col_2 = $this->get('col_2', '');
		$col_3 = $this->get('col_3', '');
		$col_4 = $this->get('col_4', '');
		$col_5 = $this->get('col_5', '');
		$col_6 = $this->get('col_6', '');
		$col_7 = $this->get('col_7', '');
		$price = $this->get('price', '');
		return !empty($title_sep) || !empty($col_1) || !empty($col_2) || !empty($col_3) || !empty($col_4) || !empty($col_5) || !empty($col_6) || !empty($col_7) || !empty($price) || !$this->_jbvalue->isEmpty();
	}
	

	/* добавление в поиск данных элемента */
	protected function _getSearchData() {

		$options = array(
					'title_sep'	=> $this->get('title_sep', ''),
					'col_1' 	=> $this->get('col_1', ''),
					'col_2' 	=> $this->get('col_2', ''),
					'col_3'		=> $this->get('col_3', ''),
					'col_4' 	=> $this->get('col_4', ''),
					'col_5' 	=> $this->get('col_5', ''),
					'col_6' 	=> $this->get('col_6', ''),
					'col_7' 	=> $this->get('col_7', ''),
					'price' 	=> $this->get('price', ''),
					 );
		 
		 $result = implode(PHP_EOL, $options);		 
		 return (empty($result) ? null : $result); 
	}
	
    /* Добавляем возможность подачи и редактирования в админке */
    protected function _edit()	{
		$this->app->document->addStylesheet('elements:option/option.css');
		$this->app->document->addStylesheet('elements:unitablekit/assets/css/unitablekit.css');
		
		if ($layout = $this->getLayout('edit.php')) {					
			return $this->renderLayout($layout, array());
		}		
		return false;
	}
		
    /* Добавлем возмождность редактировать с фронта  */
    public function _renderSubmission($params = array()) {
        return $this->_edit();
	}		
	
		
    /* Вывод результатов */
    public function _render($params = array())
    {
		$this->app->document->addStylesheet('elements:unitablekit/assets/css/unitablekit.css');				
			
		if ($layout = $this->getLayout('tmpl.php')) {	
            return $this->renderLayout($layout, array(
				
			));
        }
        return null;
    }
	
	 public function render($params = array())
		{
			$count = 0;
			$params = $this->app->data->create($params);

			$tablesort = ($this->config->get("tablesorter") == '1') ? true : false;
			$tablesortclass = ($this->config->get("tablesorter") == '1') ? 'jsTableSorter tablesorter' : false;

			if ($tablesort) {$tablesort = '<script type="text/javascript">
		        jQuery(function ($) {
		            $(".jsTableSorter").tablesorter();
		        });
		    </script>';}

			$startcnt  = '<table class="jsTableSorter tablesorter table table-striped table-hover table-bordered table-responsive">';
				   foreach ($this as $self) {
					  	
						if ($this->get('title_sep')) {$count = 0;}
						if ($count !=0) {
							$startcnt = "";} else {
								$startcnt  = '<table class="'.$tablesortclass.' table table-striped table-hover table-bordered table-responsive">';
								$startcnt .= '<thead><tr>';
                                        if ($this->config->get("col_1_title")) {$startcnt .= '<th>'.$this->config->get("col_1_title","").'</th>';}
                                        if ($this->config->get("col_2_title")) {$startcnt .= '<th>'.$this->config->get("col_2_title","").'</th>';}
                                        if ($this->config->get("col_3_title")) {$startcnt .= '<th>'.$this->config->get("col_3_title","").'</th>';}
                                        if ($this->config->get("col_4_title")) {$startcnt .= '<th>'.$this->config->get("col_4_title","").'</th>';}
                                        if ($this->config->get("col_5_title")) {$startcnt .= '<th>'.$this->config->get("col_5_title","").'</th>';}
                                        if ($this->config->get("col_6_title")) {$startcnt .= '<th>'.$this->config->get("col_6_title","").'</th>';}
                                        if ($this->config->get("col_7_title")) {$startcnt .= '<th>'.$this->config->get("col_7_title","").'</th>';}
                                        if ($this->config->get("price_title")) {$startcnt .= '<th class="pricetitle">'.$this->config->get("price_title","").'</th>';}
                                $startcnt .= '</tr></thead>';      
								}						
						$count++;
						$result[] = $startcnt.$this->_render($params);
						}		
			return $this->app->element->applySeparators($params->get('separated_by'), $result).'
			</table>'.$tablesort;
		}

	//Валмдация элемента
	public function _validateSubmission($value, $params)
	{
		return array(
			'title_sep'  => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('title_sep')),
			'col_1' => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('col_1')),
			'col_2' => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('col_2')),
			'col_3' => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('col_3')),
			'col_4' => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('col_4')),
			'col_5' => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('col_5')),
			'col_6' => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('col_6')),
			'col_7' => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('col_7')),
			'price' => $this->app->validator->create('textfilter', array('required' => $params->get('required')))->clean($value->get('price')),
		);
	}

}