<?php
// no direct access
defined('_JEXEC') or die('Restricted access');

require_once(JPATH_ADMINISTRATOR . '/components/com_zoo/config.php');
require_once(JPATH_BASE . '/media/zoo/applications/jbuniversal/framework/jbzoo.php');

class JBZooFavoriteHelper{
	/**
	 * @var JRegistry
	 */
	protected $_params = null;

	/**
	 * @var App
	 */
	protected $app = null;

	/**
	 * Init Zoo
	 * @param JRegistry $params
	 */
	public function __construct(JRegistry $params){
		$this->app     = App::getInstance('zoo');
		$this->_params = $params;

		JBZoo::init();
	}

	/**
	 * Get compare items
	 * @return mixed
	 */
	public function getFavoriteItems(){
		$favoriteItems = $this->app->jbfavorite->getAllItems();

		return $favoriteItems;
	}
	
	function NumToStr($number, $titles) 
	{  
        $cases = array(2, 0, 1, 1, 1, 2);
		return $titles[($number % 100 > 4 && $number % 100 < 20) ? 2 : $cases[min($number % 10, 5)]];  
    }
	
}