<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


// register ElementRepeatable class
App::getInstance('zoo')->loader->register('ElementRepeatable', 'elements:repeatable/repeatable.php');

/**
 * Class ElementJBImage
 */
class ElementJBImageTwenty extends ElementRepeatable
{
    /**
     * @var JBImageHelper
     */
    protected $_jbimage = null;

    /**
     * Class constructor
     */
    public function __construct()
    {
        parent::__construct();

        $this->_jbimage = $this->app->jbimage;
    }

    /**
     * Checks if the repeatables element's value is set.
     * @param array $params render parameter
     * @return bool true, on success
     */
    public function _hasValue($params = array())
    {
        $fileAfter      = JString::trim($this->get('file-after'));
        $fileBefore     = JString::trim($this->get('file-before'));
        $isExistsAfter  = !empty($fileAfter) && JFile::exists(JPATH_ROOT . '/' . $fileAfter);
        $isExistsBefore = !empty($fileAfter) && JFile::exists(JPATH_ROOT . '/' . $fileBefore);
        $defaultImage = $this->_getDefaultImage($params);

        if (!$isExistsAfter && !$isExistsBefore && !$defaultImage) {
            return false;
        }

        return true;
    }

    /**
     * Get elements search data.
     * @return string Search data
     */
    public function _getSearchData()
    {
        $fileAfter      = JString::trim($this->get('file-after'));
        $fileBefore     = JString::trim($this->get('file-before'));

        $isExistsBefore = !empty($fileBefore) && JFile::exists(JPATH_ROOT . '/' . $fileBefore);
        $isExistsAfter  = !empty($fileAfter) && JFile::exists(JPATH_ROOT . '/' . $fileAfter);

        $title    = $this->get('title');

        if ($isExistsBefore && $isExistsAfter) {
            return $title . "\n" . JBModelElementJBImage::IMAGE_EXISTS;
        } else {
            return $title . "\n__" . JBModelElementJBImage::IMAGE_NO_EXISTS;
        }
    }

    /**
     * @return null|string
     */
    public function getSearchData()
    {
        $result = array();
        foreach ($this as $self) {
            $result[] = $this->_getSearchData();
        }

        return (empty($result) ? null : implode("\n", $result));
    }

    /**
     * Renders the element.
     * @param array $params render parameter
     * @return null|string HTML
     */
    public function _render($params = array())
    {
        //init params
        $params = $this->app->data->create($params);

        // init vars
        $titleBefore    = $this->get('title-before');
        $titleAfter     = $this->get('title-after');
        $width          = (int)$params->get('width', 0);
        $height         = (int)$params->get('height', 0);
        $altBefore      = $titleBefore = empty($titleBefore) ? $this->getItem()->name : $titleBefore;
        $altAfter       = $titleAfter = empty($titleAfter) ? $this->getItem()->name : $titleAfter;
        $urlBefore      = $urlAfter = $appendClass = $targetBefore = $targetAfter = $relBefore = $relAfter = '';

        // get image before
        if ($this->_isFileExists($this->get('file-before'))) {
            $imageBefore = $this->_jbimage->resize($this->get('file-before'), $width, $height);
        } else {
            $imageBefore = $this->_getDefaultImage($params);
        }

        // get image after
        if ($this->_isFileExists($this->get('file-after'))) {
            $imageAfter = $this->_jbimage->resize($this->get('file-after'), $width, $height);
        } else {
            $imageAfter = $this->_getDefaultImage($params);
        }

        // select render template
        $template = $params->get('template', 'itemlink');

        if ($template == 'link') {
            $urlAfter    = $this->get('link-after');
            $relAfter    = $this->get('rel-after');
            $targetAfter = (int)$this->get('target-after') ? '_blank' : false;

        } elseif ($template == 'itemlink') {
            if ($this->getItem()->getState()) {
                $urlAfter   = $this->app->jbrouter->externalItem($this->_item);
                $titleAfter = empty($titleAfter) ? $this->getItem()->name : $titleAfter;
            }

        } elseif ($template == 'combine') {
            if ($this->getItem()->getState()) {
                $urlAfter   = $this->app->jbrouter->externalItem($this->_item);
                $titleAfter = empty($titleAfter) ? $this->getItem()->name : $titleAfter;
            }

        } elseif ($template == 'slider') {
            $appendClass    = 'jbimagetwenty';
        }

        // render layout
        if ($imageAfter && $imageBefore && $layout = $this->getLayout('_jbimagetwenty-' . $template . '.php')) {

            $unique = $params->get('_layout') . '_' . $this->_item->id . '_' . $this->identifier;

            return $this->renderLayout($layout, array(
                    'imageAttrsBefore' => $this->_buildAttrs(array(
                        'class'         => 'jbimagetwenty ' . $unique,
                        'alt'           => $altBefore,
                        'title'         => $titleBefore,
                        'src'           => $imageBefore->url,
                        'width'         => $imageBefore->width,
                        'height'        => $imageBefore->height,
                        'data-template' => $template,
                    )),
                    'linkAttrsBefore'  => $this->_buildAttrs(array(
                        'class'  => 'jbimage-link ' . $appendClass . ' ' . $unique,
                        'title'  => $titleBefore,
                        'href'   => $urlBefore,
                        'target' => $targetBefore,
                        'id'     => uniqid('jbimagetwenty-link-'),
                    )),
                    'imageAttrsAfter' => $this->_buildAttrs(array(
                        'class'         => 'jbimagetwenty ' . $unique,
                        'alt'           => $altAfter,
                        'title'         => $titleAfter,
                        'src'           => $imageAfter->url,
                        'width'         => $imageAfter->width,
                        'height'        => $imageAfter->height,
                        'data-template' => $template,
                    )),
                    'linkAttrsAfter'  => $this->_buildAttrs(array(
                        'class'  => 'jbimagetwenty-link ' . $appendClass . ' ' . $unique,
                        'title'  => $titleAfter,
                        'href'   => $urlAfter,
                        'target' => $targetAfter,
                        'id'     => uniqid('jbimagetwenty-link-'),
                    )),
                    'linkAfter'     => $urlAfter,
                    'imageBefore'   => $imageBefore->url
                )
            );
        }

        return null;
    }

    /**
     * @param array $params
     * @return mixed
     */
    public function render($params = array())
    {
        $result     = array();
        $params     = $this->app->data->create($params);
        $template   = $params->get('template', 'itemlink');

        if ($template == 'slider') {
            $this->app->document->addScript('elements:jbimagetwenty/assets/js/jquery.event.move.js');
            $this->app->document->addScript('elements:jbimagetwenty/assets/js/jquery.twentytwenty.js');
            $this->app->document->addStylesheet('elements:jbimagetwenty/assets/css/twentytwenty.css');
        } elseif ($template == 'combine') {
            $this->app->document->addStylesheet('elements:jbimagetwenty/assets/css/combine.css');
        }

        switch ($params->get('display', 'all')) {
            case 'first':
                $this->seek(0);
                $result[] = $this->_render($params);
                break;
            case 'all_without_first':
                $this->seek(1);
                while ($this->valid()) {
                    $result[] = $this->_render($params);
                    $this->next();
                }
                break;
            case 'all':
            default:
                foreach ($this as $self) {
                    $result[] = $this->_render($params);
                }
                break;
        }

        return $this->app->element->applySeparators($params->get('separated_by'), $result);
    }

    /**
     * @param array $attrs
     * @return string
     */
    public function _buildAttrs(array $attrs)
    {
        return $this->app->jbhtml->buildAttrs($attrs);
    }

    /**
     * Renders the edit form field.
     * @return string HTML
     */
    public function _edit()
    {
        $this->app->document->addScript('elements:jbimagetwenty/assets/js/edit.js');

        if ($layout = $this->getLayout('_editrow.php')) {
            return $this->renderLayout($layout);
        }

        return null;
    }

    /**
     * Check is in upload path
     * @param $image
     * @return bool
     */
    protected function _inUploadPath($image)
    {
        $auth  = JPath::clean($this->_getUploadImagePath(false)) == JPath::clean(dirname($image));
        $guest = JPath::clean($this->_getUploadImagePath(true)) == JPath::clean(dirname($image));

        return $auth || $guest;
    }

    /**
     * Get upload image path
     * @param bool $forceGuest
     * @return string
     */
    protected function _getUploadImagePath($forceGuest = false)
    {
        $uploadByUser    = (int)$this->config->get('upload_by_user', 0);
        $uploadDirectory = trim(trim($this->config->get('upload_directory', 'images/zoo/uploads/')), '\/');

        if ($uploadByUser) {

            if ($forceGuest) {
                $uploadDirectory .= '/user_0';
            } else {
                $user = JFactory::getUser();
                $uploadDirectory .= '/user_' . $user->id;
            }
        }

        $uploadDirectory = JPath::clean($uploadDirectory);
        if (!JFolder::exists($uploadDirectory)) {
            mkdir($uploadDirectory, 0777, true);
            @chmod($uploadDirectory, 0777);
        }

        return $uploadDirectory;
    }

    /**
     * Get default image
     * @param JSONData $params
     * @return null|object
     */
    protected function _getDefaultImage($params)
    {
        $params = $this->app->data->create($params);

        // init vars
        $width         = (int)$params->get('width', 0);
        $height        = (int)$params->get('height', 0);
        $defaultImage  = $this->config->get('default_image');
        $defaultEnable = (int)$this->config->get('default_enable', 0);

        $result = null;

        if ($defaultEnable && $defaultImage) {

            if (strpos($defaultImage, 'http') !== false) {

                return (object)array(
                    'width'   => $width,
                    'height'  => $height,
                    'path'    => $defaultImage,
                    'orig'    => $defaultImage,
                    'origUrl' => $defaultImage,
                    'url'     => $defaultImage,
                    'rel'     => $defaultImage,
                );

            } else {
                return $this->_jbimage->resize($defaultImage, $width, $height);
            }
        }

        return null;
    }

    /**
     * Is file exists
     * @param string $imagePath
     * @return bool
     */
    protected function _isFileExists($imagePath)
    {
        if (strpos($imagePath, 'http') !== false) {
            return true;

        } else if (JFile::exists($imagePath) || JFile::exists(JPATH_ROOT . '/' . $imagePath)) {
            return true;
        }

        return false;
    }

    /**
     * Trigger on item delete
     */
    public function triggerItemDeleted()
    {
        $removeWithItem = (int)$this->config->get('remove_with_item');
        if (!$removeWithItem) {
            return null;
        }

        $result = array();

        $this->seek(0);
        while ($this->valid()) {
            $result[] = $this->_triggerItemDeleted();
            $this->next();
        }

        return $result;
    }

    /**
     * Each image delete
     */
    protected function _triggerItemDeleted()
    {
        $fileBefore = $this->get('file-before');
        $fileAfter  = $this->get('file-after');

        if (($fileBefore && JFile::exists(JPATH_ROOT . '/' . $fileBefore)) && ($fileAfter && JFile::exists(JPATH_ROOT . '/' . $fileAfter))) {
            return JFile::delete(JPATH_ROOT . '/' . $fileBefore) && JFile::delete(JPATH_ROOT . '/' . $fileAfter);
        }

        return null;
    }

    /**
     * Init Twenty Script
     */
    public function jbimageTwenty()
    {
        $this->app->jbassets->widget(
            array(
                '.'.$this->identifier.' .jbimage-twenty-container'
            ),
            'twentytwenty',
            array(
                'default_offset_pct'    => floatval(trim(str_replace(',', '.', $this->config->get('slider_offset', 0.7)))),
                'orientation'           => strtolower($this->config->get('slider_orientation', 'horizontal'))
            )
        );
    }

    /**
     * Init Twenty Script Extra Variant
     */

    // public function jbimageTwenty()
    // {
    //     static $included = array();

    //     $hash = implode('///', array('.'.$this->identifier.' .jbimage-twenty-container', 'twentytwenty'));

    //     if (!isset($included[$hash])) {
    //         $included[$hash] = true;

    //         $document = JFactory::getDocument();
    //         $document->addScriptDeclaration('
    //             jQuery(function($){
    //                 $(window).load(function(){
    //                     $(".'.$this->identifier.' .jbimage-twenty-container").twentytwenty({
    //                         "default_offset_pct" : '.trim($this->config->get('slider_offset', 0.7)).',
    //                         "orientation" : "'.strtolower($this->config->get('slider_orientation', 'horizontal')).'"
    //                     });
    //                 });
    //             });
    //         ');
    //     }
    // }

}