/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */


jQuery(function ($) {

    var url = location.href.match(/^(.+)administrator\/index\.php.*/i)[1];

    var initJbImageTwenty = function (i, isCopy) {
        console.info(i);
        var $element = $(this);

        if ($element.find('image-preview').length) {
            return;
        }

        var parentClass   = $element.closest('.repeat-elements').attr('id'),
            id            = parentClass + '-jbimagetwenty-' + i,
            $selectButton = $('<button type="button" />').text("Select Image").insertAfter($element),
            $cancelSelect = $("<span />").addClass("image-cancel").insertAfter($element),
            $imagePreview = $("<div />").addClass("image-preview").insertAfter($selectButton);

        $element.attr("id", id);
        $element.val() && $("<img />").attr("src", url + $element.val()).appendTo($imagePreview);

        $cancelSelect.click(function () {
            $element.val("");
            $imagePreview.empty();
        });

        $selectButton.click(function (event) {
            event.preventDefault();

            SqueezeBox.fromElement(this, {
                handler: "iframe",
                url    : "index.php?option=com_media&view=images&tmpl=component&e_name=" + id,
                size   : {x: 850, y: 500}
            });
        });

        if (isCopy) {
            $cancelSelect.trigger('click');
        }

    };

    $("input.jbimagetwenty-select").each(function (n, obj) {
        initJbImageTwenty.apply(obj, [n, false]);
        var $parent = $(obj).closest('.element'),
            $addButton = $parent.find('p.add');

        if (!$addButton.data('jbimagetwenty-init')) {

            $addButton.data('jbimagetwenty-init', true);

            $addButton.bind('click', function () {
                var newIndexBefore  = $parent.find("li.repeatable-element").length*2 - 2,
                    newIndexAfter   = newIndexBefore + 1,
                    $elementBefore  = $parent.find('input.jbimagetwenty-select:eq(' + (newIndexBefore + 1) + ')');
                    $elementAfter   = $parent.find('input.jbimagetwenty-select:eq(' + (newIndexBefore) + ')');

                initJbImageTwenty.apply($elementBefore, [newIndexBefore, true]);  
                initJbImageTwenty.apply($elementAfter, [newIndexAfter, true]);  

            });
        }
    });

    if ($.isFunction(window.jInsertEditorText)) {
        window.insertTextOldJbImageTwenty = window.jInsertEditorText;
    }

    window.jInsertEditorText = function (c, a) {
        console.info(a);
        if (a.match(/-jbimagetwenty-/)) {

            var $element = $("#" + a),
                value    = c.match(/src="([^\"]*)"/)[1];
                console.info($element);
            $element.parent()
                .find("div.image-preview")
                .html(c)
                .find("img")
                .attr("src", url + value);

            $element.val(value);

        } else {
            $.isFunction(window.insertTextOldJbImageTwenty) && window.insertTextOldJbImageTwenty(c, a);
        }
    };

});
