/**
 * @package   FL Universal Form Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

(function($){
    var defaults = {
            'url' : '',
            'element' : '',
            'errorRowClass': '',
            'successRowClass' : '',
            'errorFormClass': '',
            'successFormClass' : '',
        };
    var methods = {
        init : function(options) {
            $.extend(defaults, options);

            var el = this;

            $('#' + defaults.element + ' .fluniversalform-submit').on('click', function() {
                var check = true;
                var result = true;
                $('#' + defaults.element + ' input, #' + defaults.element + ' textarea').each(function(indx, element){
                    if($(this).hasClass('fl-required') || $(this).hasClass('flquickcontact-captcha')) {
                        type = $(this).attr('type');
                        if (type == 'email') {
                            check = methods.checkEmail($(this));
                        } else {
                            check = methods.checkRow($(this));
                        }
                        result = result && check; 
                    }
                });
                if (result) {
                    var data = [];
                    $('#' + defaults.element + ' input, #' + defaults.element + ' textarea').each(function(indx, element){
                        data.push($(element).val());
                    })
                    //console.info(a);
                    methods.sendEmail(defaults.url, data);
                };
                //console.info(result);
                return false;
            })
        },
        checkRow : function(row) {
            if(row.val() != '') {
                row.removeClass(defaults.errorRowClass).addClass(defaults.successRowClass);
                return true;
            } else {
                row.removeClass(defaults.successRowClass).addClass(defaults.errorRowClass);
                return false;
            }
        },
        checkEmail : function(row) {
            if(row.val() != '') {
                var expr = /^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$/;
                if(!expr.test(row.val())) {
                    row.removeClass(defaults.successRowClass).addClass(defaults.errorRowClass);
                    return false;
                } else {
                    row.removeClass(defaults.errorRowClass).addClass(defaults.successRowClass);
                    return true;
                }
            } else {
                row.removeClass(defaults.successRowClass).addClass(defaults.errorRowClass);
                return false;
            }
        },
        sendEmail : function(url, data) {
            jQuery.ajax({
                type: 'POST',
                url: url,
                data: {method: 'sendEmail', 'args[0]': data},
                beforeSend: function(){
                    $('#' + defaults.element + ' .uk-alert').removeClass(defaults.errorFormClass).removeClass(defaults.successFormClass).hide();
                    $('#' + defaults.element + ' .fluniversalform-submit').prepend('<i class="uk-icon uk-icon-refresh uk-icon-spin"></i> ');
                },
                success: function(data){
                    var dataObj = $.parseJSON(data);
                    $('#' + defaults.element + ' .uk-alert').hide().html(dataObj.mes).fadeIn().delay(5000).fadeOut(500);
                    if (dataObj.res) {
                        $('#' + defaults.element + ' .uk-alert').removeClass(defaults.errorFormClass).addClass(defaults.successFormClass);
                    } else {
                        $('#' + defaults.element + ' .uk-alert').addClass(defaults.errorFormClass).removeClass(defaults.successFormClass);
                    }
                    $('#' + defaults.element + ' .fluniversalform-submit i').fadeOut(function(){
                        $(this).remove();
                    });
                }
            })
        }
    };

    $.fn.FlUniversalForm = function(method) {
        
        if ( methods[method] ) {
            return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
        } else if ( typeof method === 'object' || ! method ) {
            return methods.init.apply( this, arguments );
        } else {
            $.error('Метод с именем ' +  method + ' не существует для FlUniversalForm');
        } 
    };

})(jQuery);