<?php
/**
 * @package   FL Universal Form Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

	defined('_JEXEC') or die('Restricted access');

?>

	<div class="name-input">
		<label for="name">Название</label>
		<input type="text" name="<?php echo $var.'[row]['.$num.'][name]'; ?>" value="<?php echo $name; ?>" />
	</div>
	<div class="type-input">
		<label for="type">Тип</label>
		<select name="<?php echo $var.'[row]['.$num.'][type]'; ?>" >
			<option value="text" <?php echo ($type == 'text') ? 'selected' : ''; ?>>Text</option>
  			<option value="email" <?php echo ($type == 'email') ? 'selected' : ''; ?>>Email</option>
  			<option value="textarea" <?php echo ($type == 'textarea') ? 'selected' : ''; ?>>Textarea</option>
		</select>
	</div>
	<div class="help-input">
		<label for="help">Подсказка</label>
		<input type="text" name="<?php echo $var.'[row]['.$num.'][help]'; ?>" value="<?php echo $help; ?>" />
	</div>
	<div class="placeholder-input">
		<label for="placeholder">Placeholder</label>
		<input type="text" name="<?php echo $var.'[row]['.$num.'][placeholder]'; ?>" value="<?php echo $placeholder; ?>" />
	</div>
	<div class="required-input">
		<label for="required">Обязательно</label>
		<input type="checkbox" name="<?php echo $var.'[row]['.$num.'][required]'; ?>" value="required" <?php echo $required ? 'checked' : ''; ?> />
	</div>
	<div class="value-input hidden">
		<label for="value">Value</label>
		<a class="trigger" href="#" title="<?php echo JText::_('Edit Option Value');?>"><?php echo $value; ?></a>
		<div class="panel">
			<input type="text" name="<?php echo $var.'[row]['.$num.'][value]'; ?>" value="<?php echo $value; ?>" />
			<input type="button" class="accept" value="<?php echo JText::_('Accept'); ?>">
			<a href="#" class="cancel"><?php echo JText::_('Cancel'); ?></a>
		</div>
	</div>
	<div class="delete" title="<?php echo JText::_('Delete option'); ?>">
		<img alt="<?php echo JText::_('Delete option'); ?>" src="<?php echo $this->app->path->url('assets:images/delete.png'); ?>"/>
	</div>
	<div class="sort-handle" title="<?php echo JText::_('Sort option'); ?>">
		<img alt="<?php echo JText::_('Sort option'); ?>" src="<?php echo $this->app->path->url('assets:images/sort.png'); ?>"/>
	</div>