<?php
/**
 * @package   FL Universal Form Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC') or die('Restricted access'); 

$link = $this->app->link(array('task' => 'callelement', 'format' => 'raw', 'item_id' => $this->_item->id, 'element' => $this->identifier), false);
$rows = $this->config->get('row');
$buttonText = $this->config->get('button-text');
$buttonTextPopup = $this->config->get('button-popup-text');
$beforeFormText = $this->config->get('before-form-text');
$popup = $this->config->get('popup');
$popupScript = $this->config->get('popup-script');
$uniqid = uniqid('fl-universal-form-');

ob_start();
?>

<div id="<?php echo $uniqid; ?>">

	<div class="uk-alert" style="display: none;"></div>

	<?php echo $beforeFormText ? '<p>'.$beforeFormText.'</p>' : ''; ?>

	<form id="fl-form" class="uk-form uk-form-horizontal uk-margin-bottom">
		<?php foreach ($rows as $key => $row) { 
			$required = (isset($row['required'])) ? 'fl-'.$row['required'] : '';
			if ($row['type'] == 'textarea') {
				$inp = '<textarea class="uk-form-width-medium '.$required.'" name="'.$key.'-'.$this->identifier.'-'.$row['value'].'" placeholder="'.$row['placeholder'].'" rows="5"></textarea>';
			} else {
				$inp = '<input class="uk-form-width-medium '.$required.'" type="'.$row['type'].'" name="'.$key.'-'.$this->identifier.'-'.$row['value'].'" placeholder="'.$row['placeholder'].'" />';
			}
		?>
		
		    <div class="uk-form-row">
		    	<label class="uk-form-label" for="<?php echo $key.'-'.$this->identifier.'-'.$row['value']; ?>"><?php echo $row['name']?><?php echo (isset($row['required'])) ? ' *' : '';?></label>
		    	<div class="uk-form-controls">
		    		<?php echo $inp; ?>
		    		<?php echo $row['help'] ? '<p class="uk-form-help-block">'.$row['help'].'</p>' : ''; ?>
		    	</div>
			</div>

		<?php } ?>

		<?php if ($this->config->get('captcha')) : ?>
			<div class="uk-form-row">
				<label class="uk-form-label" for="captcha-<?php echo $this->identifier; ?>">Проверочный код</label>
				<div class="uk-form-controls">
					<input class="flquickcontact-captcha uk-form-width-medium" type="text" name="captcha-<?php echo $this->identifier ?>" value="" placeholder="Проверочный код">
					<p class="uk-form-help-block"><?php echo $this->config->get('captcha_question');?></p>
				</div>
			</div>
		<?php endif; ?>

		<div class="uk-form-row">
			<div class="uk-form-controls">
				<div class="uk-text-primary">Поля, отмеченные звездочкой (*) обязательны.</div>
			</div>
		</div>

		<div class="uk-form-row">
			<div class="uk-form-controls">
				<button class="fluniversalform-submit uk-button uk-button-primary"><?php echo $buttonText; ?></button>
			</div>
		</div>
	</form>
</div>

<?php 
	$form = ob_get_contents();
	ob_end_clean();
?>

<?php
	if ($popup) {
		$html = '';
		switch ($popupScript) {
			case 'uikit':
				$html .= '<a href="#'.$uniqid.'-popup" class="uk-button uk-button-primary" data-uk-modal>'.$buttonTextPopup.'</a>';
				$html .= '<div id="'.$uniqid.'-popup" class="uk-modal"><div class="uk-modal-dialog"><a class="uk-modal-close uk-close"></a><h1>'.$this->config->get('name').'</h1>'.$form.'</div></div>';
				break;
			case 'bootstrap':
				$html .= '<a href="#'.$uniqid.'-popup" role="button" class="btn btn-primary" data-toggle="modal">'.$buttonTextPopup.'</a>';
				$html .= '<div id="'.$uniqid.'-popup" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true"><div class="modal-header"><button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button><h3 id="myModalLabel">'.$this->config->get('name').'</h3></div><div class="modal-body" style="overflow-y:auto;">'.$form.'</div></div>';
				break;
			case 'fancybox':
				$html .= '<a href="#'.$uniqid.'-popup" class="uk-button uk-button-primary '.$uniqid.'-popup">'.$buttonTextPopup.'</a>';
				$html .= '<div id="'.$uniqid.'-popup" style="display:none;"><h1>'.$this->config->get('name').'</h1>'.$form.'</div>';
				$html .= '<script type="text/javascript">
					jQuery(function($) {
						$(document).ready(function() {
							$(".'.$uniqid.'-popup").fancybox();
						})
					})
					</script>';
				break;
		}
		echo $html; // вывод во всплывающем окне
	} else {
		echo $form; // вывод формы
	}
?>

<script type="text/javascript">
	jQuery('#<?php echo $uniqid; ?>').FlUniversalForm({
		url: '<?php echo $link; ?>',
		element: '<?php echo $uniqid; ?>',
		errorRowClass : 'uk-form-danger',
		successRowClass : 'uk-form-success',
		errorFormClass : 'uk-alert-danger',
		successFormClass : 'uk-alert-success'
	});
</script>