<?php
/**
 * @package   FL Universal Form Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

class ElementFluniversalform extends Element {

	public function __construct() {
        parent::__construct();
        $this->registerCallback('sendEmail');
    }

    // Send Ajax Mail Function
    public function sendEmail($data) {  

        array_walk($data, array($this, 'clear'));   // clean all POST data values

        $extraData = $this->getExtraData(); 

        if ($this->config->get('captcha')) {
            $captchaUserAnswer = array_pop($data); // remove latest value from POST data values

            if ($captchaUserAnswer == $this->config->get('captcha_answer')) {
                $body = $this->renderEmailBody($data, $extraData);
                $result = $this->email($body);
            } else {
                $result = array(
                    'res' => false,
                    'mes' => $this->config->get('captcha_error')
                );
            }
        } else {
            $body = $this->renderEmailBody($data, $extraData);
            $result = $this->email($body);
        }

    	return json_encode($result);
    }

    //Get Value From Element Function
	public function hasValue($params = array()) {
		$value = $this->get('value', 1);
		return !empty($value);
	}

    //Render Element Fuction
	public function render($params = array()) {
        $this->app->document->addScript('elements:fluniversalform/assets/js/fluniversalform.min.js');
        if ($layout = $this->getLayout('fluniversalform.php')) {
            return $this->renderLayout($layout);
        }

        return null;
	}

    //Edit From Admin Element Function
	public function edit() {
		return $this->app->html->_('select.booleanlist', $this->getControlName('value'), '', $this->get('value', 1));
	}

    //Load Assets From Admin Function
    public function loadConfigAssets() {
        $this->app->document->addScript('elements:fluniversalform/assets/js/script.min.js');
        $this->app->document->addStylesheet('elements:fluniversalform/assets/css/style.css');
        return parent::loadConfigAssets();
    }

    // Set Config Folder Function
    public function getConfigForm() {
        $form = parent::getConfigForm();
        $form->addElementPath($this->app->path->path('elements:fluniversalform/fields'));
        return $form;
    }

    //EditRow From Admin Function
    public function editRow($var, $num, $name = null, $type = null, $help = null, $placeholder = null,  $required = null, $value = null){
        return $this->renderLayout($this->app->path->path("elements:fluniversalform/tmpl/editrow.php"), compact('var', 'num', 'name', 'type', 'help', 'placeholder', 'required', 'value'));
    }

    //Render Email Body Function
    public function renderEmailBody($data = array(), $extraData = array()) {
        //$this->app->document->addScript('elements:fluniversalform/assets/js/fluniversalform.js');
        if ($layout = $this->getLayout('email.php')) {
            return $this->renderLayout($layout, compact('data', 'extraData'));
        }

        return null;
    }

    //Get Recipients Emails From Element Config Fuction
    public function getRecipients() {
        $siteConfig = JFactory::getConfig();
        $emails = array();
        $email = $this->config->get('email');
        foreach ($email as $mail) {
            switch ($mail) {
                case 'administrator':
                    $adminEmail = $siteConfig->get('mailfrom');
                    if (filter_var($adminEmail, FILTER_VALIDATE_EMAIL)) {
                        array_push($emails, $adminEmail);
                    }
                    break;
                
                case 'author':
                    $authorId = $this->getItem()->created_by;
                    if ($authorId) {
                        $author = JFactory::getUser($authorId);
                        $authorEmail = $author->email;
                        if (filter_var($authorEmail, FILTER_VALIDATE_EMAIL)) {
                            array_push($emails, $authorEmail);
                        }
                    }
                    break;

                case 'extra':
                    $extraEmails = $this->config->get('extra_email');
                    $extraEmailArray = array_map('trim', explode(',', $extraEmails));
                    foreach ($extraEmailArray as $extraemail) {
                        if (filter_var($extraemail, FILTER_VALIDATE_EMAIL)) {
                            array_push($emails, $extraemail);
                        }
                    }
                    break;
            }
        }
        return $emails;
    }

    //Get Extra Email Data From  Element Config Fuction
    public function getExtraData() {
        $data = array();
        $extraData = $this->config->get('fields');
        if (!empty($extraData)) {
            foreach ($extraData as $key => $extra) {
                switch ($extra) {
                    case 'id':
                        $id = $this->getItem()->id;
                        $data[$key]['name'] = 'ID материала';
                        $data[$key]['value'] = $id;
                        break;
                    
                    case 'name':
                        $name = $this->getItem()->name;
                        $data[$key]['name'] = 'Название материала';
                        $data[$key]['value'] = $name;
                        break;

                    case 'author':
                        $authorId = $this->getItem()->created_by;
                        if ($authorId) {
                            $author = JFactory::getUser($authorId);
                            $authorData = $author->name.' ('.$author->username.')';
                            $data[$key]['name'] = 'Автор материала';
                            $data[$key]['value'] = $authorData;
                        }
                        break;

                    case 'link':
                        $link = JRoute::_($this->app->route->item($this->getItem(), false), false, 2);
                        $data[$key]['name'] = 'Ссылка на материал';
                        $data[$key]['value'] = $link;
                        break;

                    case 'ip':
                        $ip = $this->app->useragent->ip();
                        $data[$key]['name'] = 'IP-адрес отправителя';
                        $data[$key]['value'] = $ip;
                        break;
                }
            }
        }
        return $data;
    }

    //Send Email Fuction
    public function email($body) {
        $siteConfig = JFactory::getConfig();
        $subject = $this->config->get('subject', 'FL Universal Form');
        $sender = array( 
            $siteConfig->get('mailfrom'),
            $siteConfig->get( 'fromname')
        );

        $mailer = JFactory::getMailer();
        $mailer->setSender($sender);
        $mailer->addRecipient($this->getRecipients());
        $mailer->setSubject($subject.' - '.$siteConfig->get( 'fromname'));
        $mailer->isHTML(true);
        $mailer->Encoding = 'base64';
        $mailer->setBody($body);

        $send = $mailer->Send();
        
        if ($send !== true) {
            $result = false;
            $mes = $this->config->get('error_notice');
        } else {
            $result = true;
            $mes = $this->config->get('success_notice');
        }

        $res = array(
            'res' => $result,
            'mes' => $mes 
        );

        return $res;
    }

    //Clear Vars Fuction
    function clear($var, $key) {
        //$clearVar = htmlentities(strip_tags(JString::trim($var)), ENT_QUOTES, "UTF-8");
        $clearVar = htmlentities(strip_tags(JString::trim($var)));
        return $clearVar;
    }
}
