<?php
/**
 * @package   FL Universal Form Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

class ElementFluniversalform extends Element {

	public function __construct() {
        parent::__construct();
        $this->registerCallback('sendEmail');
        $this->registerCallback('uploadFile');
        $this->registerCallback('deleteFile');
    }

    // Send Mail Function

    public function sendEmail($data, $captcha = '', $files = array()) {  

        $data = $this->getValues($data);
        $captcha = $this->clear($captcha);
        $extraData = $this->getExtraData(); 

        if ($this->config->get('captcha')) {

            switch ($this->config->get('captcha-type', 'simple')) {
                case 'simple':
                    $captchaAnswer = ($captcha == $this->config->get('captcha-answer')) ? true : false;
                    break;
                
                case 'recaptcha':
                    JFactory::getApplication()->input->set('g-recaptcha-response', $captcha);
                    JPluginHelper::importPlugin('captcha');
                    $dispatcher     = JDispatcher::getInstance();
                    $captchaCheck   = $dispatcher->trigger('onCheckAnswer', $captcha);
                    $captchaAnswer  = $captchaCheck[0];
                    break;
            }

            if ($captchaAnswer) {
                $body = $this->renderEmailBody($data, $extraData);
                $result = $this->email($body, $files);
            } else {
                $result = array(
                    'res' => false,
                    'mes' => $this->config->get('captcha-error')
                );
            }
        } else {
            $body = $this->renderEmailBody($data, $extraData);
            $result = $this->email($body, $files);
        }

    	return json_encode($result);
    }

    // Upload File Function

    public function uploadFile($name) {

        require($this->app->path->path("elements:fluniversalform/helper/UploadHandler.php"));

        $url = JURI::base().$this->getUploadPath();
        $dir = JPATH_ROOT.'/'.$this->getUploadPath();

        $options = array(
            'upload_dir'        =>  $dir.'/', 
            'upload_url'        =>  $url.'/',
            'param_name'        =>  $name,
            'user_dirs'         =>  false,
            'image_versions'    =>  array(),
        );

        $upload_handler = new UploadHandler($options);

        return $options;
    }

    // Delete File Function

    public function deleteFile($name) {
        if (JFile::exists(JPATH_ROOT.'/'.$this->getUploadPath().'/'.$name)) {
            return JFile::delete(JPATH_ROOT.'/'.$this->getUploadPath().'/'.$name);
        }
        return null;
    }

    //Get Value From Element Function

	public function hasValue($params = array()) {
		$value = $this->get('value', 1);
		return !empty($value);
	}

    //Render Element Fuction

	public function render($params = array()) {
        $this->app->document->addScript('elements:fluniversalform/assets/js/jquery.form-validator.min.js');
        $this->app->document->addScript('elements:fluniversalform/assets/js/fluniversalform.orig.js');
        if ($layout = $this->getLayout('fluniversalform.php')) {
            return $this->renderLayout($layout);
        }

        return null;
	}

    //Edit From Admin Element Function

	public function edit() {
		return $this->app->html->_('select.booleanlist', $this->getControlName('value'), '', $this->get('value', 1));
	}

    //Load Assets From Admin Function

    public function loadConfigAssets() {
        $this->app->document->addScript('elements:fluniversalform/assets/js/script.orig.js');
        $this->app->document->addStylesheet('elements:fluniversalform/assets/css/style.css');
        return parent::loadConfigAssets();
    }

    // Set Config Folder Function

    public function getConfigForm() {
        $form = parent::getConfigForm();
        $form->addElementPath($this->app->path->path('elements:fluniversalform/fields'));
        return $form;
    }

    //EditRow From Admin Function

    public function editRow($var, $num, $name = null, $type = null, $options = null, $help = null, $placeholder = null,  $required = null, $value = null){
        return $this->renderLayout($this->app->path->path("elements:fluniversalform/tmpl/editrow.php"), compact('var', 'num', 'name', 'type', 'options', 'help', 'placeholder', 'required', 'value'));
    }

    //Render Email Body Function

    public function renderEmailBody($data = array(), $extraData = array()) {
        //$this->app->document->addScript('elements:fluniversalform/assets/js/fluniversalform.js');
        $template = $this->config->get('template', 'default');
        if ($layout = $this->getLayout('email_template/'.$template.'.php')) {
            return $this->renderLayout($layout, compact('data', 'extraData'));
        }

        return null;
    }

    //Get Recipients Emails From Element Config Fuction

    public function getRecipients() {
        $siteConfig = JFactory::getConfig();
        $emails = array();
        $email = $this->config->get('email');
        foreach ($email as $mail) {
            switch ($mail) {
                case 'administrator':
                    $adminEmail = $siteConfig->get('mailfrom');
                    if (filter_var($adminEmail, FILTER_VALIDATE_EMAIL)) {
                        array_push($emails, $adminEmail);
                    }
                    break;
                
                case 'author':
                    $authorId = $this->getItem()->created_by;
                    if ($authorId) {
                        $author = JFactory::getUser($authorId);
                        $authorEmail = $author->email;
                        if (filter_var($authorEmail, FILTER_VALIDATE_EMAIL)) {
                            array_push($emails, $authorEmail);
                        }
                    }
                    break;

                case 'extra':
                    $extraEmails = $this->config->get('extra_email');
                    $extraEmailArray = array_map('trim', explode(',', $extraEmails));
                    foreach ($extraEmailArray as $extraemail) {
                        if (filter_var($extraemail, FILTER_VALIDATE_EMAIL)) {
                            array_push($emails, $extraemail);
                        }
                    }
                    break;
            }
        }
        return $emails;
    }

    //Get Extra Email Data From  Element Config Fuction

    public function getExtraData() {
        $data = array();
        $extraData = $this->config->get('fields');
        if (!empty($extraData)) {
            foreach ($extraData as $key => $extra) {
                switch ($extra) {
                    case 'id':
                        $id = $this->getItem()->id;
                        $data[$key]['name'] = 'ID материала';
                        $data[$key]['value'] = $id;
                        break;
                    
                    case 'name':
                        $name = $this->getItem()->name;
                        $data[$key]['name'] = 'Название материала';
                        $data[$key]['value'] = $name;
                        break;

                    case 'author':
                        $authorId = $this->getItem()->created_by;
                        if ($authorId) {
                            $author = JFactory::getUser($authorId);
                            $authorData = $author->name.' ('.$author->username.')';
                            $data[$key]['name'] = 'Автор материала';
                            $data[$key]['value'] = $authorData;
                        }
                        break;

                    case 'link':
                        $link = JRoute::_($this->app->route->item($this->getItem(), false), false, 2);
                        $data[$key]['name'] = 'Ссылка на материал';
                        $data[$key]['value'] = $link;
                        break;

                    case 'ip':
                        $ip = $this->app->useragent->ip();
                        $data[$key]['name'] = 'IP-адрес отправителя';
                        $data[$key]['value'] = $ip;
                        break;
                }
            }
        }
        return $data;
    }

    //Send Email Fuction

    public function email($body, $files) {
        $siteConfig = JFactory::getConfig();
        $subject = $this->config->get('subject', 'FL Universal Form');
        $sender = array( 
            $siteConfig->get('mailfrom'),
            $siteConfig->get( 'fromname')
        );

        $mailer = JFactory::getMailer();
        $mailer->setSender($sender);
        $mailer->addRecipient($this->getRecipients());
        $mailer->setSubject($subject.' - '.$siteConfig->get( 'fromname'));
        $mailer->isHTML(true);
        $mailer->Encoding = 'base64';
        $mailer->setBody($body);

        if (!empty($files)) {
            foreach ($files as $key => $file) {
                $mailer->addAttachment(JPATH_ROOT.'/'.$this->getUploadPath().'/'.$file);
            }
        }

        $send = $mailer->Send();
        
        if ($send !== true) {
            $result = false;
            $mes = $this->config->get('error_notice');
        } else {
            $result = true;
            $mes = $this->config->get('success_notice');
            if ($this->config->get('upload_delete', 1) && !empty($files)) {
                foreach ($files as $key => $file) {
                    $this->deleteFile($file);
                }
            }
        }

        $res = array(
            'res' => $result,
            'mes' => $mes 
        );

        return $res;
    }

    //Clear Vars Fuction

    public function clear($var) {
        //$clearVar = htmlentities(strip_tags(JString::trim($var)), ENT_QUOTES, "UTF-8");
        $clearVar = htmlentities(strip_tags(JString::trim($var)));
        return $clearVar;
    }

    // Get Options Grom Text

    protected function parseOptions($text) {
        $text   = JString::trim($text);
        $result = array();
        if (!empty($text)) {
            $lines = explode(",", $text);
            foreach ($lines as $key => $line) {
                $line = JString::trim($line);
                // $result[$key]['value'] = $this->transliterate($line);
                $result[$key]['value'] = $line;
            }
        }
        return $result;
    }

    // Transliterate Function

    protected function transliterate($text) {
        $lang = JLanguage::getInstance('ru-RU');
        $result = $lang->transliterate($text);

        return $result;
    }

    // Get Values Array From Serialize Form

    protected function getValues($data) {
        $dataArray = array();
        $data = array_values($data);

        if ($this->config->get('captcha')) {
            array_pop($data);
        }

        $rows = $this->config->get('row');

        $i = 0;
        $checkbox = array();
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                $value = implode(', ', $value);
            }
            $dataArray[$key]['name'] = $rows[$key]['name'];
            $dataArray[$key]['value'] = $this->clear($value);
        }

        return $dataArray;
    }

    // Add Upload Script

    protected function jqueryFileUpload($name) {
        $this->app->document->addScript('elements:fluniversalform/assets/js/jquery.file.upload.min.js');

        $url = $this->app->link(array('task' => 'callelement', 'format' => 'raw', 'item_id' => $this->_item->id, 'element' => $this->identifier, 'method' => 'uploadFile', 'args[0]' => $name), false);
        $acceptedFiles = '/(\.|\/)('.str_replace(',', '|', $this->config->get('upload_types', 'gif,jpg,jpeg,png')).')$/i';

        $this->app->document->addScriptDeclaration("
            jQuery(function($) {
                $('.".$name." .jsFlUpload').fileupload({
                    url: '".$url."',
                    dataType: 'json',
                    paramName: '".$name."',
                    acceptFileTypes: ".$acceptedFiles.",
                    maxFileSize: ".($this->config->get('upload_max_size', 2000)*1000).",
                    maxNumberOfFiles: ".$this->config->get('upload_max_files', '1').",
                    getNumberOfFiles: function() {
                        return $('.".$name." .jsFiles div').length;
                    },
                    messages: {
                        maxNumberOfFiles: 'Максимальное количество файлов - ".$this->config->get('upload_max_files', '1')."',
                        maxFileSize: 'Максимальный размер загружаемого файла - ".$this->config->get('upload_max_size', 2000)."КБ',
                        acceptFileTypes: 'Допустимые типы файлов - ".$this->config->get('upload_types', 'gif,jpg,jpeg,png')."',
                        minFileSize: 'Файл слишком маленький'
                    },
                    processalways: function (e, data) {
                        var index = data.index;
                        var file = data.files[index];
                        if (file.error) {
                            $('.".$name." .jsError').show().append('<p class=\"uk-text-small uk-text-break\">Файл <b>' + file.name + '</b> не загружен. Причина: ' + file.error + '.</p>');
                        }
                    },
                    done: function (e, data) {
                        $.each(data.result['".$name."'], function (index, file) {
                            if (file.url) {
                                $('<div/>').text(file.name).append('<a href=\"#\" class=\"uk-icon-close uk-text-warning uk-margin-small-left jsDeleteFile\"/>').appendTo($('.".$name." .jsFiles').show());
                            } else if (file.error) {
                                $('.".$name." .jsError').show().append('<p class=\"uk-text-small uk-text-break\">Файл <b>' + file.name + '</b> не загружен. Причина: ' + file.error + '.</p>');
                            }
                        });
                        
                    },
                    progressall: function (e, data) {
                        var progress = parseInt(data.loaded / data.total * 100, 10);
                        $('.".$name." .jsProgress').show().find('.jsBar').css(
                            'width',
                            progress + '%'
                        );
                    },
                    fail: function (e, data) {
                        $.each(data.files, function (index, file) {
                            var error = $('<p/>').text('Файл не загружен.');
                            $('.".$name." .jsError').show().append('<p class=\"uk-text-small uk-text-break\">Файл <b>' + file.name + '</b> не загружен. Причина: ' + file.error + '.</p>');
                        });
                    }
                }).prop('disabled', !$.support.fileInput).parent().addClass($.support.fileInput ? undefined : 'disabled');
            });");

        return true;
    }

    // Get Uikit Popup Form Function

    protected function getUikitPopup($uniqid, $form) {
        $buttonTextPopup    = $this->config->get('button-popup-text');

        $html = '<a href="#'.$uniqid.'-popup" class="uk-button uk-button-primary" data-uk-modal>'.$buttonTextPopup.'</a>';
        $html .= '<div id="'.$uniqid.'-popup" class="uk-modal">
                        <div class="uk-modal-dialog">
                            <a class="uk-modal-close uk-close"></a>
                            <h1>'.$this->config->get('name').'</h1>'.
                            $form.
                        '</div>
                    </div>';
        $html .= '<script type="text/javascript">
                        jQuery(function($) {
                            $(document).ready(function() {
                                var modal = UIkit.modal("#'.$uniqid.'-popup");
                                $(document).on("success.fl.universal.form", function() {
                                    setTimeout(function(){
                                        modal.hide();
                                    }, 5000);
                                });
                            })
                        })
                    </script>';

        return $html;
    }

    // Get Bootstrap 2 Popup Form Function

    protected function getBootstrap2Popup($uniqid, $form) {
        $buttonTextPopup    = $this->config->get('button-popup-text');

        $html = '<a href="#'.$uniqid.'-popup" role="button" class="btn btn-primary" data-toggle="modal">'.$buttonTextPopup.'</a>';
        $html .= '<div id="'.$uniqid.'-popup" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                            <h3>'.$this->config->get('name').'</h3>
                        </div>
                        <div class="modal-body">'.
                        $form.
                        '</div>
                    </div>';
        $html .= '<script type="text/javascript">
                        jQuery(function($) {
                            $(document).ready(function() {
                                $(document).on("success.fl.universal.form", function() {
                                    setTimeout(function(){
                                        $("#'.$uniqid.'-popup").modal(\'hide\');
                                    }, 5000);
                                });
                            })
                        })
                    </script>';

        return $html;
    }

    // Get Bootstrap 3 Popup Form Function

    protected function getBootstrap3Popup($uniqid, $form) {
        $buttonTextPopup    = $this->config->get('button-popup-text');

        $html = '<button type="button" data-target="#'.$uniqid.'-popup" role="button" class="btn btn-primary" data-toggle="modal">'.$buttonTextPopup.'</button>';

        $html .= '<div class="modal fade" id="'.$uniqid.'-popup" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                    <h3 class="modal-title">'.$this->config->get('name').'</h3>
                                </div>
                                <div class="modal-body">'.
                                    $form.
                                '</div>
                            </div>
                        </div>
                    </div>';

        $html .= '<script type="text/javascript">
                        jQuery(function($) {
                            $(document).ready(function() {
                                $(document).on("success.fl.universal.form", function() {
                                    setTimeout(function(){
                                        $("#'.$uniqid.'-popup").modal(\'hide\');
                                    }, 5000);
                                });
                            })
                        })
                    </script>';

        return $html;
    }

    // Get Bootstrap 3 Popup Form Function

    protected function getFancyboxPopup($uniqid, $form) {
        $buttonTextPopup = $this->config->get('button-popup-text');

        $html = '<a href="#'.$uniqid.'-popup" class="uk-button uk-button-primary '.$uniqid.'-popup">'.$buttonTextPopup.'</a>';
        $html .= '<div id="'.$uniqid.'-popup" style="display:none;"><h1>'.$this->config->get('name').'</h1>'.$form.'</div>';
        $html .= '<script type="text/javascript">
                        jQuery(function($) {
                            $(document).ready(function() {
                                $(".'.$uniqid.'-popup").fancybox();
                                $(document).on("success.fl.universal.form", function() {
                                    setTimeout(function(){
                                         $.fancybox.close();
                                    }, 5000);
                                });
                            })
                        })
                    </script>';

        return $html;
    }

    // Get Popup

    protected function getPopupHtml($uniqid, $form) {
        $popupScript = $this->config->get('popup-script');

        switch ($popupScript) {
            case 'uikit':
                $html = $this->getUikitPopup($uniqid, $form);
                break;

            case 'bootstrap2':
                $html = $this->getBootstrap2Popup($uniqid, $form);
                break;

            case 'bootstrap3':
                $html = $this->getBootstrap3Popup($uniqid, $form);
                break;

            case 'fancybox':
                $html = $this->getFancyboxPopup($uniqid, $form);
                break;
        }

        return $html;
    }

    // Get Upload Path 

    protected function getUploadPath()
    {   
        $uploadDirectory = trim(trim($this->config->get('upload_directory', 'images/uploads/')), '\/');

        return $uploadDirectory;
    }
}
