/**
 * @package   FL Universal Form Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

(function($){
    var defaults = {
        'url'               : '',
        'element'           : '',
        'errorRowClass'     : '',
        'successRowClass'   : '',
        'errorFormClass'    : '',
        'successFormClass'  : '',
        'errorTextClass'    : '',
        'defaultButtonText' : '',
        'sendingButtonText' : '',
        'validationMessages': 1,
        'popup'             : 0,
    };
    var methods = {
        init : function(options) {
            defaults = $.extend(defaults, options);

            $('#' + defaults.element + ' .jsFormSubmit').on('click', function() {
                var result = methods.validate(defaults);

                if (result) {
                    data = methods.serialize(defaults);
                    files = methods.getFiles(defaults);
                    methods.sendEmail(defaults.url, data, files, defaults);
                };
                return false;
            })
        },
        sendEmail : function(url, data, files, defaults) {
            var captcha = $('#' + defaults.element + ' .jsFormCaptcha').val();

            if (!captcha) {
                captcha = $('#g-recaptcha-response').val();
            } 

            jQuery.ajax({
                type: 'POST',
                url: url,
                data: {method: 'sendEmail', 'args[0]': data, 'args[1]': captcha, 'args[2]': files},
                beforeSend: function(){
                    $('#' + defaults.element + ' .jsFormAlert').removeClass(defaults.errorFormClass).removeClass(defaults.successFormClass).hide();
                    $('#' + defaults.element + ' .jsFormSubmit').text(defaults.sendingButtonText);
                },
                success: function(data){
                    var dataObj = $.parseJSON(data);
                    $('#' + defaults.element + ' .jsFormAlert').hide().html(dataObj.mes).fadeIn().delay(5000).fadeOut(500);

                    if (defaults.popup == 0) {
                        container = $('html, body');
                    } else {
                        container = $('#' + defaults.element + '-popup');
                    }
                    container.animate({
                        scrollTop: $('#' + defaults.element).offset().top - 20
                    }, 500);

                    if (dataObj.res) {
                        $('#' + defaults.element + ' .jsFormAlert').removeClass(defaults.errorFormClass).addClass(defaults.successFormClass);
                        $('#' + defaults.element + ' input, #' + defaults.element + ' textarea, #' + defaults.element + ' select').removeClass(defaults.successRowClass).val('').attr('checked', false).find("option").removeAttr("selected");
                        $('#' + defaults.element + ' .jsFiles, #' + defaults.element + ' .jsError').html('');
                        $('#' + defaults.element + ' .jsFiles, #' + defaults.element + ' .jsProgress, #' + defaults.element + ' .jsError').hide();
                        $('#' + defaults.element).trigger('success.fl.universal.form');
                    } else {
                        $('#' + defaults.element + ' .jsFormAlert').addClass(defaults.errorFormClass).removeClass(defaults.successFormClass);
                    }
                    $('#' + defaults.element + ' .jsFormSubmit').text(defaults.defaultButtonText);
                }
            })
        },
        serialize: function(defaults) {
            var form = $('#' + defaults.element + ' form');
            var o = {};
            var a = form.serializeArray();
            $.each(a, function() {
                if (this.type != 'file') {
                    if (o[this.name] !== undefined) {
                        if (!o[this.name].push) {
                            o[this.name] = [o[this.name]];
                        }
                        o[this.name].push(this.value || '');
                    } else {
                        o[this.name] = this.value || '';
                    }
                };
            });
            return o;
        },
        getFiles: function() {
            var files = [];
            $('#' + defaults.element + ' .jsFiles').each(function(index, fileFields) {
                $(fileFields).find('div').each(function(index, file) {
                   files.push($(file).text());
                });
            });
            return files;
        },
        validate: function(defaults) {

            var language = {errorTitle:"Ошибка отправки формы!",requiredField:"Это обязательное поле",requiredFields:"Вы задали не все обязательные поля",badTime:"Вы задали некорректное время",badEmail:"Вы задали некорректный e-mail",badTelephone:"Вы задали некорректный номер телефона",badSecurityAnswer:"Вы задали некорректный ответ на секретный вопрос",badDate:"Вы задали некорректную дату",lengthBadStart:"Значение должно быть в диапазоне",lengthBadEnd:" символов",lengthTooLongStart:"Значение длинее, чем ",lengthTooShortStart:"Значение меньше, чем ",notConfirmed:"Введённые значения не могут быть подтверждены",badDomain:"Некорректное значение домена",badUrl:"Некорретный URL",badCustomVal:"Введённое значение неверно",andSpaces:" и пробелы ",badInt:"Значение - не число",badSecurityNumber:"Введённый защитный номер - неправильный",badUKVatAnswer:"Некорректный UK VAT номер",badStrength:"Пароль не достаточно надёжен",badNumberOfSelectedOptionsStart:"Вы должны выбрать как минимум ",badNumberOfSelectedOptionsEnd:" ответов",badAlphaNumeric:"Значение должно содержать только числа и буквы ",badAlphaNumericExtra:" и ",wrongFileSize:"Загружаемый файл слишком велик (максимальный размер %s)",wrongFileType:"Принимаются файлы следующих типов %s",groupCheckedRangeStart:"Выберите между ",groupCheckedTooFewStart:"Выберите как минимум ",groupCheckedTooManyStart:"Выберите максимум из ",groupCheckedEnd:" элемент(ов)",badCreditCard:"Номер кредитной карты некорректен",badCVV:"CVV номер некорректно",wrongFileDim:"Неверные размеры графического файла,",imageTooTall:"изображение не может быть уже чем",imageTooWide:"изображение не может быть шире чем",imageTooSmall:"изображение слишком мало",min:"минимум",max:"максимум",imageRatioNotAccepted:"Изображение с таким соотношением сторон не принимается",badBrazilTelephoneAnswer:"Введённый номер телефона неправильный",badBrazilCEPAnswer:"CEP неправильный",badBrazilCPFAnswer:"CPF неправильный"};

            var errors = [];

            conf = {
                errorElementClass: defaults.errorRowClass,
                errorMessageClass: defaults.errorTextClass,
                addValidClassOnAll: true,
                scrollToTopOnError: false,
                language : language,
                onElementValidate : function(valid, $el, $form, errorMess) {
                    if (valid) {
                        $el.removeClass(defaults.errorRowClass).addClass(defaults.successRowClass);
                    } else {
                        $el.removeClass(defaults.successRowClass).addClass(defaults.errorRowClass);
                        errors.push({el: $el, error: errorMess});
                    };
                }
            };

            if (defaults.validationMessages == 0) {
                showMessages = false;
            } else {
                showMessages = true;
            }

            if( !$('#' + defaults.element + ' form').isValid(language, conf, showMessages) ) {
                return false;
            } else {
                return true;
            }
        }
    };

    $.fn.FlUniversalForm = function(method) {
        
        if (methods[method]) {
            return methods[ method ].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if ( typeof method === 'object' || ! method ) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Метод с именем ' +  method + ' не существует для FlUniversalForm');
        } 
    };

    $.formUtils.addValidator({
        name : 'fl_file',
        validatorFunction : function(value, $el, config, language, $form) {
            var row = $el.parent().find('.jsFiles div').length;
            if (row == 0) {
                return false;
            };
            return true;
        },
        errorMessage : 'Загрузите хотя бы один файл',
        errorMessageKey: 'badFlFile'
    });

})(jQuery);