<?php
/**
 * @package   FL Universal Form Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

	defined('_JEXEC') or die('Restricted access');

?>

	<div class="name-input">
		<label title="Название поля" for="name">Название</label>
		<input type="text" name="<?php echo $var.'[row]['.$num.'][name]'; ?>" value="<?php echo $name; ?>" />
	</div>
	<div class="type-input">
		<label title="Тип поля" for="type">Тип</label>
		<select name="<?php echo $var.'[row]['.$num.'][type]'; ?>" >
			<option value="text" <?php echo ($type == 'text') ? 'selected' : ''; ?>>Text</option>
  			<option value="email" <?php echo ($type == 'email') ? 'selected' : ''; ?>>Email</option>
  			<option value="textarea" <?php echo ($type == 'textarea') ? 'selected' : ''; ?>>Textarea</option>
  			<option value="select" <?php echo ($type == 'select') ? 'selected' : ''; ?>>Select</option>
  			<option value="radio" <?php echo ($type == 'radio') ? 'selected' : ''; ?>>Radio</option>
  			<option value="checkbox" <?php echo ($type == 'checkbox') ? 'selected' : ''; ?>>Checkbox</option>
  			<option value="file" <?php echo ($type == 'file') ? 'selected' : ''; ?>>File</option>
		</select>
	</div>
	<div class="options-input <?php echo ($type == 'select' || $type == 'radio' || $type == 'checkbox') ? '' : 'hidden'; ?>">
		<label title="Опции для полей Select, Radio и Checkbox, опции указываются через запятую без пробелов" for="options">Опции</label>
		<input type="text" name="<?php echo $var.'[row]['.$num.'][options]'; ?>" value="<?php echo $options; ?>" />
	</div>
	<div class="help-input">
		<label title="Подскзка поля, отображается под самим полем" for="help">Подсказка</label>
		<input type="text" name="<?php echo $var.'[row]['.$num.'][help]'; ?>" value="<?php echo $help; ?>" />
	</div>
	<div class="placeholder-input">
		<label title="Placeholder поля" for="placeholder">Placeholder</label>
		<input type="text" name="<?php echo $var.'[row]['.$num.'][placeholder]'; ?>" value="<?php echo $placeholder; ?>" />
	</div>
	<!-- <div class="required-input">
		<label title="Валидация поля" for="required">Обязательно</label>
		<input type="checkbox" name="<?php echo $var.'[row]['.$num.'][required]'; ?>" value="required" <?php echo $required ? 'checked' : ''; ?> />
	</div> -->
	<div class="required-input">
		<label title="Валидация поля" for="required">Валидация</label>
		<select name="<?php echo $var.'[row]['.$num.'][required]'; ?>" >
			<option value="" <?php echo ($required == '') ? 'selected' : ''; ?>>Нет</option>
			<option value="required" <?php echo ($required == 'required') ? 'selected' : ''; ?>>Обязательно</option>
  			<option value="number" <?php echo ($required == 'number') ? 'selected' : ''; ?>>Число</option>
  			<option value="email" <?php echo ($required == 'email') ? 'selected' : ''; ?>>E-mail</option>
  			<option value="url" <?php echo ($required == 'url') ? 'selected' : ''; ?>>Ссылка</option>
  			<option value="alphanumeric" <?php echo ($required == 'alphanumeric') ? 'selected' : ''; ?>>Буквы и цифры</option>
		</select>
	</div> 
	<div class="value-input hidden">
		<label for="value">Value</label>
		<a class="trigger" href="#" title="<?php echo JText::_('Edit Option Value');?>"><?php echo $value; ?></a>
		<div class="panel">
			<input type="text" name="<?php echo $var.'[row]['.$num.'][value]'; ?>" value="<?php echo $value; ?>" />
			<input type="button" class="accept" value="<?php echo JText::_('Accept'); ?>">
			<a href="#" class="cancel"><?php echo JText::_('Cancel'); ?></a>
		</div>
	</div>
	<div class="delete" title="<?php echo JText::_('Delete option'); ?>">
		<img alt="<?php echo JText::_('Delete option'); ?>" src="<?php echo $this->app->path->url('assets:images/delete.png'); ?>"/>
	</div>
	<div class="sort-handle" title="<?php echo JText::_('Sort option'); ?>">
		<img alt="<?php echo JText::_('Sort option'); ?>" src="<?php echo $this->app->path->url('assets:images/sort.png'); ?>"/>
	</div>