/**
 * @package   FL Universal Form Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

(function($){
    var defaults = {
        'url'               : '',
        'element'           : '',
        'errorRowClass'     : '',
        'successRowClass'   : '',
        'errorFormClass'    : '',
        'successFormClass'  : '',
        'errorTextClass'    : '',
        'defaultButtonText' : '',
        'sendingButtonText' : '',
        'validationMessages': 1,
        'popup'             : 0,
    };
    var methods = {
        init : function(options) {
            var form = $(this);
            defaults = $.extend(defaults, options);

            form.find('.jsFormSubmit').on('click', function() {
                var result = methods.validate(defaults, form);

                if (result) {
                    data = methods.serialize(defaults, form);
                    files = methods.getFiles(form);
                    methods.sendEmail(defaults.url, data, files, defaults, form);
                };
                return false;
            })
        },
        sendEmail : function(url, data, files, defaults, form) {
            var captcha = form.find('.jsFormCaptcha').val();

            if (!captcha) {
                captcha = $('#g-recaptcha-response').val();
            } 

            jQuery.ajax({
                type: 'POST',
                url: url,
                data: {method: 'sendEmail', 'args[0]': data, 'args[1]': captcha, 'args[2]': files},
                beforeSend: function(){
                    form.find('.jsFormAlert').removeClass(defaults.errorFormClass).removeClass(defaults.successFormClass).hide();
                    form.find('.jsFormSubmit').text(defaults.sendingButtonText);
                },
                success: function(data){
                    var dataObj = $.parseJSON(data);
                    form.find('.jsFormAlert').hide().html(dataObj.mes).fadeIn().delay(5000).fadeOut(500);

                    if (defaults.popup == 0) {
                        container = $('html, body');
                    } else {
                        container = form;
                    }
                    container.animate({
                        scrollTop: form.offset().top - 20
                    }, 500);

                    if (dataObj.res) {
                        form.find('.jsFormAlert').removeClass(defaults.errorFormClass).addClass(defaults.successFormClass);
                        form.find('input, textarea, select').removeClass(defaults.successRowClass).val('').attr('checked', false).find("option").removeAttr("selected");
                        form.find('.jsFiles, .jsError').html('');
                        form.find('.jsFiles, .jsProgress, .jsError').hide();
                        $('#' + defaults.element).trigger('success.fl.universal.form');
                    } else {
                        form.find('.jsFormAlert').addClass(defaults.errorFormClass).removeClass(defaults.successFormClass);
                    }
                    form.find('.jsFormSubmit').text(defaults.defaultButtonText);
                }
            })
        },
        serialize: function(defaults, form) {
            var form = form.find('form');
            var o = {};
            var a = form.serializeArray();
            $.each(a, function() {
                if (this.type != 'file') {
                    if (o[this.name] !== undefined) {
                        if (!o[this.name].push) {
                            o[this.name] = [o[this.name]];
                        }
                        o[this.name].push(this.value || '');
                    } else {
                        o[this.name] = this.value || '';
                    }
                };
            });
            return o;
        },
        getFiles: function(form) {
            var files = [];
            form.find('.jsFiles').each(function(index, fileFields) {
                $(fileFields).find('div').each(function(index, file) {
                   files.push($(file).text());
                });
            });
            return files;
        },
        validate: function(defaults, form) {

            var language = {errorTitle:"Ошибка отправки формы!",requiredField:"Это обязательное поле",requiredFields:"Вы задали не все обязательные поля",badTime:"Вы задали некорректное время",badEmail:"Вы задали некорректный e-mail",badTelephone:"Вы задали некорректный номер телефона",badSecurityAnswer:"Вы задали некорректный ответ на секретный вопрос",badDate:"Вы задали некорректную дату",lengthBadStart:"Значение должно быть в диапазоне",lengthBadEnd:" символов",lengthTooLongStart:"Значение длинее, чем ",lengthTooShortStart:"Значение меньше, чем ",notConfirmed:"Введённые значения не могут быть подтверждены",badDomain:"Некорректное значение домена",badUrl:"Некорретный URL",badCustomVal:"Введённое значение неверно",andSpaces:" и пробелы ",badInt:"Значение - не число",badSecurityNumber:"Введённый защитный номер - неправильный",badUKVatAnswer:"Некорректный UK VAT номер",badStrength:"Пароль не достаточно надёжен",badNumberOfSelectedOptionsStart:"Вы должны выбрать как минимум ",badNumberOfSelectedOptionsEnd:" ответов",badAlphaNumeric:"Значение должно содержать только числа и буквы ",badAlphaNumericExtra:" и ",wrongFileSize:"Загружаемый файл слишком велик (максимальный размер %s)",wrongFileType:"Принимаются файлы следующих типов %s",groupCheckedRangeStart:"Выберите между ",groupCheckedTooFewStart:"Выберите как минимум ",groupCheckedTooManyStart:"Выберите максимум из ",groupCheckedEnd:" элемент(ов)",badCreditCard:"Номер кредитной карты некорректен",badCVV:"CVV номер некорректно",wrongFileDim:"Неверные размеры графического файла,",imageTooTall:"изображение не может быть уже чем",imageTooWide:"изображение не может быть шире чем",imageTooSmall:"изображение слишком мало",min:"минимум",max:"максимум",imageRatioNotAccepted:"Изображение с таким соотношением сторон не принимается",badBrazilTelephoneAnswer:"Введённый номер телефона неправильный",badBrazilCEPAnswer:"CEP неправильный",badBrazilCPFAnswer:"CPF неправильный"};

            var errors = [];

            conf = {
                errorElementClass: defaults.errorRowClass,
                errorMessageClass: defaults.errorTextClass,
                addValidClassOnAll: true,
                scrollToTopOnError: false,
                language : language,
                onElementValidate : function(valid, $el, $form, errorMess) {
                    if (valid) {
                        $el.removeClass(defaults.errorRowClass).addClass(defaults.successRowClass);
                    } else {
                        $el.removeClass(defaults.successRowClass).addClass(defaults.errorRowClass);
                        errors.push({el: $el, error: errorMess});
                    };
                }
            };

            if (defaults.validationMessages == 0) {
                showMessages = false;
            } else {
                showMessages = true;
            }

            if( !form.find('form').isValid(language, conf, showMessages) ) {
                return false;
            } else {
                return true;
            }
        }
    };

    $.fn.FlUniversalForm = function(method) {
        
        if (methods[method]) {
            return methods[ method ].apply(this, Array.prototype.slice.call(arguments, 1));
        } else if ( typeof method === 'object' || ! method ) {
            return methods.init.apply(this, arguments);
        } else {
            $.error('Метод с именем ' +  method + ' не существует для FlUniversalForm');
        } 
    };

    $.formUtils.addValidator({
        name : 'fl_file',
        validatorFunction : function(value, $el, config, language, $form) {
            var row = $el.parent().find('.jsFiles div').length;
            if (row == 0) {
                return false;
            };
            return true;
        },
        errorMessage : 'Загрузите хотя бы один файл',
        errorMessageKey: 'badFlFile'
    });

})(jQuery);