<?php
/**
 * @package   FL Universal Form Element for Zoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC') or die('Restricted access'); 

$link 				= $this->app->link(array('task' => 'callelement', 'format' => 'raw', 'item_id' => $this->_item->id, 'element' => $this->identifier), false);
$rows 				= $this->config->get('row');
$buttonText 		= $this->config->get('button-text');
$buttonTextPopup 	= $this->config->get('button-popup-text');
$buttonTextSending 	= $this->config->get('button-sending-text');
$beforeFormText 	= $this->config->get('before-form-text');
$popup 				= $this->config->get('popup');
$popupScript 		= $this->config->get('popup-script');
$validationMessages = $this->config->get('validation_messages', 1);
$uniqid 			= uniqid('fl-universal-form-');
$captchaType 		= $this->config->get('captcha-type', 'simple');

ob_start();
?>

<div id="<?php echo $uniqid; ?>">

	<div class="jsFormAlert uk-alert" style="display: none;"></div>

	<?php echo $beforeFormText ? '<p>'.$beforeFormText.'</p>' : ''; ?>

	<form id="fl-form" class="uk-form uk-form-horizontal uk-margin-bottom">
		<?php foreach ($rows as $key => $row) { 
			$type = $row['type'];
			$name = $key.'-'.$this->identifier.'-'.$row['type'];
			$class = 'fl-'.$row['type'].'-'.$row['value'];
		?>
		
		    <div class="uk-form-row">
		    	<label class="uk-form-label" for="<?php echo $name; ?>"><?php echo $row['name']?><?php echo (!empty($row['required'])) ? ' *' : '';?></label>
		    	<div class="uk-form-controls">
		    		<?php
		    			switch ($type) {
							case 'text' :
								echo $this->app->html->_('control.'.$type, $name, '', 'class="uk-form-width-medium '.$class.'" placeholder="'.$row['placeholder'].'" maxlength="255" data-validation="'.$row['required'].'"');
								break;

							case 'textarea' :
								echo $this->app->html->_('control.'.$type, $name, '', 'class="uk-form-width-medium '.$class.'" placeholder="'.$row['placeholder'].'" rows="5" data-validation="'.$row['required'].'"');
								break;

							case 'email' :
								echo $this->app->html->_('control.input', 'email', $name, '', 'class="uk-form-width-medium '.$class.'" placeholder="'.$row['placeholder'].'" data-validation="'.$row['required'].'"');
								break;

							case 'select' :
								$optionsArray = $this->parseOptions($row['options']);

								$options = array();
								$options[] = $this->app->html->_('select.option', '', '-' . JText::sprintf('Выберите %s', strtolower($row['name'])) . '-');
								foreach ($optionsArray as $option) {
									$options[] = $this->app->html->_('select.option', $option['value'], $option['value']);
								}
								echo $this->app->html->_('select.genericlist', $options, $name, 'class="uk-form-width-medium" data-validation="'.$row['required'].'"', 'value', 'text', '');
								break;

							case 'radio' :
								$optionsArray = $this->parseOptions($row['options']);

								$options = array();
								foreach ($optionsArray as $option) {
									$options[] = $this->app->html->_('select.option', $option['value'], $option['value']);
								}
								echo $this->app->html->_('zoo.radiolist', $options, $name, 'data-validation="'.$row['required'].'"', 'value', 'text', '');
								break;

							case 'checkbox' :
								$optionsArray = $this->parseOptions($row['options']);

								$options = array();
								foreach ($optionsArray as $k => $option) {
									if ($row['required'] && $k == 0) {
										$validation = 'data-validation="checkbox_group" data-validation-qty="min1"';
									}
									echo '<input id="'.$name.$k.'" type="checkbox" name="'.$name.'" value="'.$option['value'].'" '.$validation.' /><label class="uk-margin-small-left" for="'.$name.$k.'">'.$option['value'].'</label><br/>';
								}
								break;

							case 'file' :
								$fileValidation = $row['required'] ? 'fl_file' : '';
								echo '<div class="fl-fileupload '.$name.'">';
								echo $this->app->html->_('control.input', 'file', $name, '', 'class="jsFlUpload uk-display-block" multiple data-validation="'.$fileValidation.'"');
								echo '<div class="jsProgress uk-progress uk-progress-mini" style="display:none;"><div class="uk-progress-bar jsBar"></div></div>';
								echo '<div class="jsError uk-alert uk-alert-danger" style="display:none;"></div>';
    							echo '<div class="jsFiles uk-alert uk-alert-success" style="display:none;"></div>';
    							echo '</div>';
    							$this->jqueryFileUpload($name);
								break;
						}
		    		?>
		    		<?php echo $row['help'] ? '<p class="uk-form-help-block">'.$row['help'].'</p>' : ''; ?>
		    		<p class="fl-error uk-form-help-block"></p>
		    	</div>
			</div>

		<?php } ?>

		<?php if ($this->config->get('captcha')) : ?>
			<div class="uk-form-row">
				<label class="uk-form-label" for="captcha-<?php echo $this->identifier; ?>">Проверочный код *</label>
				<div class="uk-form-controls">

					<?php if ($captchaType == 'simple') {
						echo $this->app->html->_('control.text', $name, '', 'class="fluniversalform-captcha jsFormCaptcha uk-form-width-medium" placeholder="Проверочный код" maxlength="255" data-validation="required"');
					} elseif ($captchaType == 'recaptcha') {
						$captcha = JCaptcha::getInstance('recaptcha');
						echo $captcha->display('captcha', 'captcha', 'captcha');

						echo '<script type="text/javascript">
	                        jQuery(function($) {
	                            $(document).ready(function() {
	                                $(document).on("success.fl.universal.form", function() {
	                                    grecaptcha.reset();
	                                });
	                            })
	                        })
                    	</script>';
					} ?>

					<p class="uk-form-help-block"><?php echo $this->config->get('captcha-question');?></p>
					<p class="fl-error uk-form-help-block"></p>

				</div>
			</div>
		<?php endif; ?>

		<div class="uk-form-row">
			<div class="uk-form-controls">
				<div class="uk-text-primary">Поля, отмеченные звездочкой (*) обязательны.</div>
			</div>
		</div>

		<div class="uk-form-row">
			<div class="uk-form-controls">
				<button class="fluniversalform-submit jsFormSubmit uk-button uk-button-primary"><?php echo $buttonText; ?></button>
			</div>
		</div>
	</form>
</div>

<?php 
	$form = ob_get_contents();
	ob_end_clean();
?>

<?php
	if ($popup) {
		$html = $this->getPopupHtml($uniqid, $form);
		echo $html; // вывод во всплывающем окне
	} else {
		echo $form; // вывод формы
	}
?>

<script type="text/javascript">

	jQuery('#<?php echo $uniqid; ?>').FlUniversalForm({
		url 				: '<?php echo $link; ?>',
		element 			: '<?php echo $uniqid; ?>',
		errorRowClass  		: 'uk-form-danger',
		successRowClass 	: 'uk-form-success',
		errorFormClass 		: 'uk-alert-danger',
		successFormClass 	: 'uk-alert-success',
		errorTextClass 		: 'uk-text-danger',
		defaultButtonText 	: '<?php echo $buttonText; ?>',
        sendingButtonText 	: '<?php echo $buttonTextSending; ?>',
		validationMessages 	: '<?php echo $validationMessages; ?>',
		popup 				: '<?php echo $popup; ?>'
	})

	jQuery(document).on('click', '.jsDeleteFile', function() {
		var deleteButton = jQuery(this);
        var deleteFileName = deleteButton.parent().text();
        var filesContainer = deleteButton.parent().parent();
        var inputContainer = filesContainer.parent();

        jQuery.ajax({
            type: 'POST',
            url: '<?php echo $link; ?>',
            data: {method: 'deleteFile', 'args[0]': deleteFileName},
            success: function(data) {
                deleteButton.parent().remove();
                if (filesContainer.find('div').length == 0) {
                	filesContainer.hide();
                	inputContainer.find('.jsProgress').hide();
                };
            }
        });

        return false;
	});

</script>