<?php
/**
 * @package   FL Pickpoint Shipping Element for JBZoo
 * @author    Дмитрий Васюков http://fictionlabs.ru
 * @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Class JBCartElementShippingEmsPost
 */
class JBCartElementShippingFLPickpoint extends JBCartElementShipping
{   
    protected $_currency    = 'rub';

    /**
     * @return $this
     */
    public function loadAssets()
    {   
        JHtml::script('https://pickpoint.ru/select/postamat.js');
        // $this->app->document->addScript('https://pickpoint.ru/select/postamat.js');

        parent::loadAssets();
    }

    /**
     * @return JBCartValue
     */
    public function getRate()
    {   
        $rate = (int) $this->config->get('rate', 600);

        $summ = $this->_order->val(0, $this->_currency);

        if ($rate) {
            $summ->set($rate, $this->_currency);            
        }

        return $summ;
    }


    /**
     * @param array $params
     * @return mixed|string
     */
    public function renderSubmission($params = array())
    {   
        $btnText = 'Выбрать постамат';
        $name = $this->get('name', '');
        $address = $this->get('address', '');

        if (!empty($address)) {
            $btnText = 'Выбрать другой постамат';
        }

        if ($layout = $this->getLayout('submission.php')) {
            return self::renderLayout($layout, array(
                'params'    => $params,
                'btnText'   => $btnText,
                'name'      => $name,
                'address'   => $address
            ));
        }
    }

    /**
     * Validates the submitted element
     * @param $value
     * @param $params
     * @return array
     * @throws JBCartElementShippingException
     */
    public function validateSubmission($value, $params)
    {
        // for calculate rate
        $this->bindData($value);

        $rate = $this->getRate();
        $value->set('rate', $rate->data(true));

        $address = $this->get('address', '');

        if (empty($address)) {
            throw new JBCartElementShippingException('Для выбранного способа доставки необходимо выбрать постамат');
        }

        return $value;
    }

}
