﻿<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component

    @package     jbzoo
    @version     2.x Pro
    @author      JBZoo App http://jbzoo.com
    @copyright   Copyright (C) artcolorit.com,  All rights reserved.
    @license     http://jbzoo.com/license-pro.php JBZoo Licence
    @coder       Vladimir Pershin <zeus07@artcolorit.com>
 */
 
 

 
class ElementVPLabel extends Element
{
   
    /**
     * Check, has value
     * @param array $params
     * @return bool
     */
    public function hasValue($params = array())
    {
        if ((int)$this->config->get('new', 0) ||
            (int)$this->config->get('action', 0) ||
            (int)$this->config->get('hit', 0)
        ) {
            return true;
        }

        return false;
    }
    
    public function __construct()
    {
      parent::__construct();
      JFactory::getLanguage()->load('elem_' . $this->getElementType(), $this->getPath(), null, true);
    }

    /**
     * Render action
     * @param array $params
     * @return null|string
     */
    public function render($params = array())
    {
    	
        // init vars
        $containerId = uniqid('vplabel-');
        $parameter = $this->app->parameter->create()
            ->loadArray((array)$this->config)
            ->loadArray($params);
      
        // render layout
        if ($layout = $this->getLayout()) {
            return self::renderLayout($layout, compact('containerId', 'params'));
        }

        return null;
    }

    
    /**
     * Edit action
     * @return null|string
     */
    public function edit()
    {
       $layout = $this->getLayout('edit.php');
       return $this->renderLayout($layout);
    }
}