<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


/**
 * Class JBCartElementHookJBDumpLog
 */
class JBCartElementHookXML extends JBCartElementHook
{




    public function array_to_xml( $data, &$xml_data ) 
    {
        foreach( $data as $key => $value ) {
            if( is_numeric($key) ){
                $key = 'item'; //dealing with <0/>..<n/> issues
            }
            if( is_array($value) ) {
                $subnode = $xml_data->addChild($key);
                $this->array_to_xml($value, $subnode);
            } else {
                $xml_data->addChild("$key",htmlspecialchars("$value"));
            }
         }
    }  



    /**
     * @param $params
     */
    public function notify($params = array())
    {
        $order = $this->getOrder();
        $myorderid = $order->id;
        $cartItemsOneC = (array)$order->getItems();

        $this->getItemPay($cartItemsOneC, $order);
    }


    public function getItemPay($cartItemsOneC, $order)

    {

        $payments = $order->getPayment()->getName();
        $payments_status = $order->getPaymentStatus();

        $orderRecipientPhone = $order->getFieldElement('91dc265a-6d12-43f1-95c5-53189b161ccd')->data();
        $orderRecipientPhone = $orderRecipientPhone['value'];

        $orderRecipientName = $order->getFieldElement('a2ff7691-9b79-4488-bb4c-545022aad5a6')->data();
        $orderRecipientName = $orderRecipientName['value'];

        $orderRecipientMail = $order->getFieldElement('8fa262d6-30b0-4f1b-933f-5314d459463a')->data();
        $orderRecipientMail = $orderRecipientMail['value'];


        $recip = array(
            'orderId' => $order->id,
            'payments' => $payments, 
            'payments_status' => $payments_status, 
            'recipientName' =>$orderRecipientName,
            'recipientPhone' =>$orderRecipientPhone,
            'recipientMail' =>$orderRecipientMail
        );

        $i = 0;

        foreach ($cartItemsOneC as $cartItem) {

               $recipientItems = array(
                "name" => $cartItem['item_name'],
                "quantity" => $cartItem['quantity'],
                "amount" => $cartItem['elements']['_value'],
                "sku" => $cartItem['elements']['_sku'],
                "discount" => $cartItem['elements']['_discount']
                );

                //var_dump($cartItem);
                $recip['items'][$i] =  $recipientItems;

                $i= $i+1;
           }



        $xml_data = new SimpleXMLElement('<?xml version="1.0" encoding="utf-8"?><data xmlns="http://localhost/forafarm/InternetShopOrderDownload"></data>');
        $this->array_to_xml($recip, $xml_data);

        //print $xml_data->asXML();

        if ($payments == 'Яндекс Касса') {

            if ($payments_status == 'success') {

                $result = $xml_data->asXML(JPATH_ROOT . '/logs/1c/yakassa/' .$order->id.'.xml');
                unlink(JPATH_ROOT . '/logs/1c/yakassa_wait/' .$order->id.'.xml');

            }

            else {

                $result = $xml_data->asXML(JPATH_ROOT . '/logs/1c/yakassa_wait/' .$order->id.'.xml');
            }
        }

        else {

        $result = $xml_data->asXML(JPATH_ROOT . '/logs/1c/other/' .$order->id.'.xml');

        }

    }

}
