<?php
// Запрещаем прямой доступ к файлу
defined('_JEXEC') or die('Restricted access');

// Регистрируем ElementRepeatable class

class ElementMetaOgKit extends Element {

	//Проверка наличия значения
	public function hasValue($params = array()) {
		return true;
	}
	
	/* добавление в поиск данных элемента */
	protected function _getSearchData() {
		return value;
	}
	
    /* Добавляем возможность подачи и редактирования в админке */
    public function edit() {

	}

    /* Вывод результатов */
	public function render($params = array()) 
	    {
			$document = JFactory::getDocument(); 
			$config = JFactory::getConfig();

			$meta_og = $document->_custom;

			$params					= $this->app->data->create($params);

			$og_image      			= $this->_config->get('og_image');	//получаем элемент картинки из конфига
			$og_type_def   			= $this->_config->get('og_type_def');
			$og_type      			= ($params->get('og_type', "") != "" ) ? $params->get('og_type') : $og_type_def ;

			$og_image_show      	= ($this->_config->get('og_image_show') == 1) ? true : false;
			$og_type_show      		= ($this->_config->get('og_type_show') == 1) ? true : false;
			$og_title_show      	= ($this->_config->get('og_title_show') == 1) ? true : false;
			$og_url_show      		= ($this->_config->get('og_url_show') == 1) ? true : false;
			$allow_ssl 				= ($config->get("force_ssl") > 0) ? 1 : -1;
			$og_description_show   	= ($this->_config->get('og_description_show') == 1) ? true : false;
			
			$og_image      			= $this->_item->elements->$og_image;//докапываемся до нашей картинки в этом элементе 
			$og_image				= $og_image[0]['file'];	//выбираем первую
			$og_image				= $this->app->jbimage->resize($og_image, '300', '')->url; //формируем превьюшку при помощи обертки от jbzoo

			$og_description_mode = $this->_config->get('og_description_mode');//Получаем из конфига режим работы описания
			
			$og_text_def = $this->_item->name;

			if ($og_description_mode == 1) {
				$og_text_def   	= $this->_config->get('og_text_def');//получаем из настройки элемента значение описания по умолчанию
				$og_text_def   	= $this->_item->elements->$og_text_def;
				$og_text_def   	= $og_text_def[0]['value'];//и докапываемся до него
			}
			else {
				$og_text_def 	= $this->_item->params->get('metadata.description');//берем стандартное значение из дескрипшена
			}
		 		$publish = true;
			foreach ($meta_og as $mtag) {
				if (!preg_match('/<meta property="og:/i', $mtag)) {	
					$publish = true;		
				} else {
					$publish = false;
				}
			}
			
			// Блок для автогенерации
			$meta_title_priceelement	= $params->get('meta_title_priceelement');
			$meta_title_price			= ($params->get('meta_title_price') == 1) ? true : false;
			$meta_autodescr    			= ($params->get('meta_autodescr') == 1) ? true : false;
			$meta_autodescrprice		= ($params->get('meta_autodescrprice') == 1) ? true : false;
			$meta_autodescrprice_prefix	= $params->get('meta_autodescrprice_prefix');
			$meta_autodescr_prefix 		= $params->get('meta_autodescr_prefix');
			$meta_autodescr_postfix		= $params->get('meta_autodescr_postfix');
			// Блок для автогенерации
			
			
			// og:type - определяем тип
			if ($og_type_show && $publish) {$document->addCustomTag('<meta property="og:type" content="'.$og_type.'" />');}
			 
			// og:title - показываем тайтл без всяких спец символов
			$oggtitle = addslashes(htmlspecialchars(strip_tags($this->_item->name)));
			if ($og_title_show && $publish) {$document->addCustomTag('<meta property="og:title" content="'.$oggtitle.'" />');}

			// og:image - путь к файлу изображения из элемента
			if ($og_image_show && $publish) {$document->addCustomTag('<meta property="og:image" content="'.$og_image.'" />');}
			 
			// og:url - урл страницы
			$ogglink = JRoute::_($this->app->route->item($this->_item, false), true, $allow_ssl);
			if ($og_url_show && $publish) {$document->addCustomTag('<meta property="og:url" content="'.$ogglink.'" />');}
			 
			// og:description - og:description - берем описание из стандартного Мета-тег Description
			if ($og_description_show && $publish) {$document->addCustomTag('<meta property="og:description" content="'.$og_text_def.'" />');}
				
			// Автоматизация
			
				//$user = JFactory::getUser();
				//if ($user->superadmin) { }
				
				if ($meta_autodescrprice_prefix != '') {$meta_autodescrprice_prefix = ' '.$meta_autodescrprice_prefix.' ';}
				if ($meta_autodescr_prefix != '') {$meta_autodescr_prefix = $meta_autodescr_prefix.' ';}
				if ($meta_autodescr_postfix != '') {$meta_autodescr_postfix = ' '.$meta_autodescr_postfix;}
				
				
				if ($meta_title_price && $meta_title_priceelement) {		
					$itid 		= $this->_item->id;
					$item		= $this->app->table->item->get($itid);
					$jbprice 	= $item->getElement($meta_title_priceelement);
					$list 		= $jbprice->getList();
					$jbprice	= $list->getTotal();
					
					$price 		= $jbprice->text();						
					if ($meta_autodescrprice) {$dprice = $meta_autodescrprice_prefix.$price;}
					
					$metatitle = $price.' :: '.$this->app->document->getTitle();				
					$document->setTitle($metatitle);
				} 
				
				$metadescription = $meta_autodescr_prefix.$this->_item->name.$dprice.$meta_autodescr_postfix;
				if ($meta_autodescr == 1) {
					($this->app->document->getDescription()) ? $this->app->document->getDescription() : $this->app->document->setDescription($metadescription);
				}
				//jbdump ($meta_autodescrprice_prefix, 0);
			
			// Автоматизация

		return false;				    
    }


//Валмдация элемента
	public function validateSubmission($value, $params)
		{
			return array('value' => $value->get('value'));
		}

}