<?php
/**
 * @package    jbzoosetacl
 *
 * @author     CB9TOIIIA <your@email.com>
 * @copyright  A copyright
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 * @link       http://your.url.com
 */

use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Database\DatabaseDriver;

defined('_JEXEC') or die;

/**
 * Jbzoosetacl plugin.
 *
 * @package  jbzoosetacl
 * @since    1.0
 */
//JPlugin
//CMSPlugin
class plgSystemJbzoosetacl extends JPlugin
{
	/**
	 * Application object
	 *
	 * @var    CMSApplication
	 * @since  1.0
	 */
	protected $app;

	/**
	 * Database object
	 *
	 * @var    DatabaseDriver
	 * @since  1.0
	 */
	protected $db;

	/**
	 * Affects constructor behavior. If true, language files will be loaded automatically.
	 *
	 * @var    boolean
	 * @since  1.0
	 */
	protected $autoloadLanguage = true;

	/**
	 * onAfterInitialise.
	 *
	 * @return  void.
	 *
	 * @since   1.0
	 */
	public function onAfterInitialise()
	{

	}

	/**
	 * onAfterRoute.
	 *
	 * @return  void.
	 *
	 * @since   1.0
	 */
	public function onAfterRoute()
	{
	
	}

	/**
	 * onAfterDispatch.
	 *
	 * @return  void.
	 *
	 * @since   1.0
	 */
	public function onAfterDispatch()
	{

	}

	/**
	 * onAfterRender.
	 *
	 * @return  void.
	 *
	 * @since   1.0
	 */
	public function onAfterRender()
	{
		// Access to plugin parameters
		$app  = JFactory::getApplication();
		$doc = JFactory::getDocument(); 
		$user = JFactory::getUser();
		$uri = JFactory::getURI();
		$zoo = App::getInstance('zoo');
		$params      = $this->params;
		$url = $uri->toString(array('path', 'query', 'fragment'));

        //Функция проверяющая на принадлежность пользователя к группам
        function getAccess($groups=array(), $user_id=0)
        {
            if ($user_id == 0) $user_id = JFactory::getUser()->id;
            if (count($groups) == 0 || $user_id == 0) return false;
            return (count(array_intersect(JFactory::getUser($user_id)->getAuthorisedGroups(), $groups))>0);
        }

		$groups = explode(',',$params->get('regexp_acl_id'));// массив групп указываем через запятую
	
        if (!getAccess($groups)) {
            // echo 'Разрешено';

			// Get the body
			$html = $this->app->getBody();
			$css = "<style>li.jbzoo-orders,li.jbzoo.level1.item3.last.parent {display:none!important}</style>";
			$html = str_replace('</head>', $css.'</head>', $html);
			// Applies the changes
			$this->app->setBody($html);
			if (preg_match('#('.$params->get('regexp_acl').')#',$url,$match)) {
				JError::raiseError(500,$params->get('regexp_acl_name'));
			}
        }

	}
	

	/**
	 * onAfterCompileHead.
	 *
	 * @return  void.
	 *
	 * @since   1.0
	 */
	public function onAfterCompileHead()
	{
	
	}

	/**
	 * OnAfterCompress.
	 *
	 * @return  void.
	 *
	 * @since   1.0
	 */
	public function onAfterCompress()
	{
	
	}

	/**
	 * onAfterRespond.
	 *
	 * @return  void.
	 *
	 * @since   1.0
	 */
	public function onAfterRespond()
	{
	
	}
}
