<?php
/**
* @package   com_zoo
* @author    YOOtheme http://www.yootheme.com
* @copyright Copyright (C) YOOtheme GmbH
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// register ElementRepeatable class
//App::getInstance('zoo')->loader->register('ElementRepeatable', 'elements:repeatable/repeatable.php');

/*
   Class: ElementText
       The text element class
*/
//class ElementLightPrice extends ElementRepeatable implements iRepeatSubmittable {
class ElementAllNumbers extends Element implements iSubmittable {
	/*
		Function: _hasValue
			Checks if the repeatables element's value is set.

	   Parameters:
			$params - render parameter

		Returns:
			Boolean - true, on success
	*/
	//protected function _hasValue($params = array()) {
	public function hasValue($params = array()) {
		$value = $this->get('value', $this->config->get('default'));
		$value = self::clearValue($value);
		return !empty($value) || $value === '0';
	}

	public function render($params = array()) {
		if ($this->get('value', $this->config->get('default'))) {
			$params = $this->app->data->create($params);
			$value = $this->get('value', $this->config->get('default'));
			$factor = (int)$this->config->get('factor');
			$units = $params->get('units');
			$format = $params->get('format');
			$class = $params->get('class');
			$hint = ($params->get('hint') == '')? $params->get('hint') : 'title="'.$params->get('hint').'"';
			$html = array();
			$vformat = number_format($value*$factor, $format, ',', ' ');
			if ($class != ''){$html [] = '<div '.$hint.' class="'.$class.'">';}
			$html [] = $vformat.' <qq>'.$units.'</qq>';
			if ($class != ''){$html [] = '</div>';}
			return implode("\n", $html);
		}

		return null;
	}
	
	/*
		Function: _getSearchData
			Get repeatable elements search data.

		Returns:
			String - Search data
	*/
	public function getSearchData() {
		$value = $this->get('value', $this->config->get('default'));
		$value = self::clearValue($value);
		return $value;
	}

	/*
	   Function: _edit
	       Renders the repeatable edit form field.

	   Returns:
	       String - html
	*/
	//protected function _edit() {
	public function edit() {
		$value = $this->get('value', $this->config->get('default'));
		$value = self::clearValue($value);
		$factor = substr($this->config->get('factor'),1);
		$units_a = $this->config->get('units_a');
		
		if ($this->config->get('rend')){
			$html = array();
			$html[] = $this->app->html->_('control.text', $this->getControlName('value'), $value, 'size="20" maxlength="255" style="width: 20%"');
			$html[] = '<strong> '.$factor.' '.$units_a.'</strong>';
		}else{
			$this->app->document->addScript('elements:allnumbers/js/square.js');
			$html = array();
			$html[] = $this->app->html->_('control.text', $this->getControlName('value'), $value, 'class="square sot" size="20" maxlength="255" style="width: 20%"');
			$html[] = '<strong> '.$factor.' '.$units_a.'</strong>';
			$html[] = $this->app->html->_('control.text', '', '', 'class="square ga" size="20" maxlength="255" style="width: 20%"');
			$html[] = '<strong> Га</strong>';
			$html[] = $this->app->html->_('control.text', '', '', 'class="square kva" size="20" maxlength="255" style="width: 20%"');
			$html[] = '<strong> кв.м.</strong>';
		};
		return '<div class="lightnumber-wrapper">' . implode("\n ", $html) . '</div>';
	}


	/*
		Function: _renderSubmission
			Renders the element in submission.

	   Parameters:
            $params - AppData submission parameters

		Returns:
			String - html
	*/
	//public function _renderSubmission($params = array()) {
	public function renderSubmission($params = array()) {
        return $this->edit();
	}
	
	public function validateSubmission($value, $params) {
		$value = $value->get('value');
		$value = self::clearValue($value);
		return array('value' => $value);
	}
	
	public static function clearValue($value)
    {
        $value = (string)$value;
        $value = JString::trim($value);
        $value = preg_replace('#[^0-9\,\.]#ius', '', $value);
        $value = (float)str_replace(',', '.', $value);

        return $value;
    }
}