/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 */

;
(function ($, window, document, undefined) {

    /**
     * JBZoo Cart widget
     */
    JBZoo.widget('JBZoo.Cart', {
        'text_remove_item': '',
        'text_remove_all' : '',
        'url_shipping'    : '',
        'url_quantity'    : '',
        'url_delete'      : '',
        'url_clear'       : '',
        'items'           : {},
        'rates'           : {}
    }, {
        shipping      : {},
        shippingFields: {},
        changeDelay   : 600,

        init: function ($this) {
            $this.shipping       = $this.$('.jsShipping');
            $this.shippingFields = $this.$('.jsShippingField');
            $this.updateSize();

        },

        'change.JBZooQuantity .jsQuantity': function (e, $this, oldValue, newValue) {
            if (arguments.length != 4) {
                return false;
            }
            var itemKey = $(this).closest('.jsCartTableRow').data('key');
            $this._change(itemKey, newValue);
        },

        'click .jsDelete': function (e, $this) {
            var $tableRow  = $(this).closest('.jsCartTableRow'),
                itemsCount = $this.$('.jsCartTableRow').length;

            $this.confirm($this.options.text_remove_item, function () {
                $this.ajax({
                    'url'    : $this.options.url_delete,
                    'target' : $tableRow,
                    'data'   : {
                        'key': $tableRow.data('key')
                    },
                    'success': function (data) {

                        if (itemsCount != 1) {
                            $this.updatePrices(data.cart);
                            $this.reloadModule();
                        } else {
                            window.location.reload();
                        }

                        $tableRow.remove();
                        $this.updateSize(data.cart);
                    },
                    'error'  : function (error) {
                        $this.alert(error);
                    }
                });
            });

        },

        'click .jsDeleteAll': function (e, $this) {

            $this.confirm($this.options.text_remove_all, function () {
                $this.ajax({
                    url    : $this.options.url_clear,
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        },

        /**
         * Change quantity for item
         * @param itemKey
         * @param newValue
         * @returns {boolean}
         * @private
         */
        _change: function (itemKey, newValue) {

            var $this = this;

            if (!$this._getItem(itemKey)) {
                return false;
            }
            this.options.items[itemKey].quantity = newValue;
            // console.info(this.updateWeight());

            $this._delay(function () {
                $this.ajax({
                    url    : $this.options.url_quantity,
                    target : '.js' + itemKey,
                    data   : {
                        value: newValue,
                        key  : itemKey
                    },
                    success: function (data) {
                        $this.updatePrices(data.cart);
                        $this.updateSize(data.cart);
                        $this.reloadModule();
                    },
                    error  : function (data) {
                        if (data.message) {
                            $this.alert(data.message);
                        }
                        if (JBZoo.isWidgetExists('JBZooQuantity')) {
                            $this.$('.js' + itemKey + ' .jsQuantity').JBZooQuantity('setValue', data.quantity);
                        }
                    }
                });
            }, $this.changeDelay);
        },

        /**
         * Get item info
         * @param rowId
         * @returns {*}
         * @private
         */
        _getItem: function (rowId) {
            return this.options.items[rowId];
        },

        /**
         * @private
         */
        reloadModule: function () {
            if (JBZoo.isWidgetExists('JBZooCartModule')) {
                $('.jsJBZooCartModule').each(function (i, module) {
                    var $module = $(module);
                    if (!JBZoo.empty($module.data('JBZooCartModule'))) {
                        $module.JBZooCartModule('reload');
                    }
                });
            }
        },

        /**
         * Set new params from responce
         * @param cart
         * @param context
         * @private
         */
        updatePrices: function (cart, context) {

            var $this = this;
            context   = $this._def(context, '');

            $.each(cart, function (key, value) {

                var selector = '.js' + key;
                if (context) {
                    selector = '.js' + context + ' ' + '.js' + key;
                }

                var $money = $this.$(selector + '>.jsMoney');

                key = "" + key; // force to string
                if (key.indexOf('-ajax') > 0) {

                    $this.$('.jsShippingAjax-' + key.replace('-ajax', ''))
                        .data('JBZooShippingAjax', value)
                        .trigger('jbzooShippingAjax');

                } else if ($money.length
                    && typeof value == 'object'
                    && (JBZoo.countProps(value) == 2 || !JBZoo.empty(value['MoneyWrap']))
                ) {

                    if (!JBZoo.empty(value['MoneyWrap'])) {
                        value = value['MoneyWrap'];
                    }


                    $money
                        .JBZooMoney({rates: $this.options.rates})
                        .JBZooMoney('setValue', value[0], value[1]);

                } else {

                    if (typeof value == 'object') {
                        $this.updatePrices(value, key);

                    } else {
                        var $block = $this.$(selector);
                        if ($block.length > 0) {
                            $block.html(value);
                        }
                    }

                }

            });
        },
        /**
         * Set new weight from responce
         * @param cart
         * @param context
         * @private
         */
        updateSize: function (cart, context) {

            var $this       = this;
            var items       = this.options.items;
            var width      = 0;
            var widthEl    = $this.$('.jsTotalWidth');
            var tableEl     = $this.$('.jsJBZooCartTable');
            var widthAlert = $this.$('.jsWidthAlert');
            var maxWidth   = $.cookie("maxwidth");
            var height      = 0;
            var heightEl    = $this.$('.jsTotalHeight');
            var tableEl     = $this.$('.jsJBZooCartTable');
            var heightAlert = $this.$('.jsHeightAlert');
            var maxHeight   = $.cookie("maxheight");
            var length      = 0;
            var lengthEl    = $this.$('.jsTotalLength');
            var tableEl     = $this.$('.jsJBZooCartTable');
            var lengthAlert = $this.$('.jsLengthAlert');
            var maxLength   = $.cookie("maxlength");
            var weight      = 0;
            var weightEl    = $this.$('.jsTotalWeight');
            var tableEl     = $this.$('.jsJBZooCartTable');
            var weightAlert = $this.$('.jsWeightAlert');
            var maxWeight   = $.cookie("maxweight");
            var key = 0;
            var volume = 0;

            $('#cdek .goods').remove();

            $.each(items, function(index, el) {
                if($("tr").is('.js'+index)) {

                    for (var i = 1; i <= el.quantity; i++) {

                        var itemWeight = parseFloat(el.elements._weight);
                        $('#cdek').append('<input name="goods['+ key +'].weight" value="'+ itemWeight.toFixed(2) +'" hidden  class="form-weight goods goods-'+ key +'" />');
                        
                        var itemWidth = parseFloat(el.elements._properties.width * 100);
                        $('#cdek').append('<input name="goods['+ key +'].width" value="'+ itemWidth.toFixed(0) +'" hidden  class="form-width goods goods-'+ key +'" />');
                        
                        var itemHeight = parseFloat(el.elements._properties.height * 100);
                        $('#cdek').append('<input name="goods['+ key +'].height" value="'+ itemHeight.toFixed(0) +'" hidden  class="form-height goods goods-'+ key +'" />');
                        
                        var itemLenght = parseFloat(el.elements._properties.length * 100);
                        $('#cdek').append('<input name="goods['+ key +'].length" value="'+ itemLenght.toFixed(0) +'" hidden  class="form-length goods goods-'+ key +'" />');
                         
                        var itemVolume = (itemWidth * itemHeight * itemLenght)/1000000;
                        $('#cdek').append('<input name="goods['+ key +'].volume" value="'+ itemVolume.toFixed(4) +'" hidden  class="form-volume goods goods-'+ key +'" />');
                    
                        key++;
                    }

                    weight += itemWeight * el.quantity;
                    length += itemLenght * el.quantity;
                    width += itemWidth * el.quantity;
                    height += itemHeight * el.quantity;
                    volume += itemVolume;
                }

            });

            weight = weight;

            $({value: weightEl.text()})
                .stop()
                .animate({value: weight}, {
                    duration: 400,
                    easing  : 'swing',
                    step: function() {
                        weightEl.text(Math.round((this.value)*100)/100);
                        // weightEl.text(this.value.toFixed(2));
                    },
                    complete: function () {
                        weightEl.text(weight.toFixed(2));
                    }
                });

            width = width;

            $({value: widthEl.text()})
                .stop()
                .animate({value: width}, {
                    duration: 400,
                    easing  : 'swing',
                    step: function() {
                        widthEl.text(Math.round((this.value)*100)/100);
                        // widthEl.text(this.value.toFixed(2));
                    },
                    complete: function () {
                        widthEl.text(width.toFixed(2));
                    }
                });

            height = height;

            $({value: heightEl.text()})
                .stop()
                .animate({value: height}, {
                    duration: 400,
                    easing  : 'swing',
                    step: function() {
                        heightEl.text(Math.round((this.value)*100)/100);
                        // heightEl.text(this.value.toFixed(2));
                    },
                    complete: function () {
                        heightEl.text(height.toFixed(2));
                    }
                });



            length = length;

            $({value: lengthEl.text()})
                .stop()
                .animate({value: length}, {
                    duration: 400,
                    easing  : 'swing',
                    step: function() {
                        lengthEl.text(Math.round((this.value)*100)/100);
                        // lengthEl.text(this.value.toFixed(2));
                    },
                    complete: function () {
                        lengthEl.text(length.toFixed(2));
                    }
                });


            console.log('%cВес посылки: ' + '%c' + weight.toFixed(2), ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
            console.log('%cОбъем посылки: ' + '%c' + volume.toFixed(4), ' color: #39356b;', 'color: #39356b; text-decoration: underline;');

        }

    });

})(jQuery, window, document);
