
/**
@coder  Alexey Pakhomov  <web@2f-vsk.ru>
**/

$(document).ready(function($) {
	$('.hiddensdek').closest('.jbcart-form-textclass').css('display', 'none');
});


ymaps.ready(function () {


console.log('%c Основные параметры СДЭК ', 'text-transform: uppercase; background: #39356b; color: #ffffff; font-size: 12pt;');
console.log('%cНаценка: ' + '%c' + conf_discont, ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
console.log('%cВес посылки: ' + '%c' + conf_weight, ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
console.log('%cКоордината центр 1: ' + '%c' + conf_center[0], ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
console.log('%cКоордината центр 2: ' + '%c' + conf_center[1], ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
console.log('%cСсылка на иконку: ' + '%c' + conf_iconLink, ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
console.log('%cТекст иконки: ' + '%c' + conf_iconText, ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
console.log('%cРазмер иконки ширина: ' + '%c' + conf_iconSize[0], ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
console.log('%cРазмер иконки высота: ' + '%c' + conf_iconSize[1], ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
console.log('%cОтступ иконки по ширине: ' + '%c' + conf_iconOffset[0], ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
console.log('%cОтступ иконки по высоте: ' + '%c' + conf_iconOffset[1], ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
console.log('%cРазмер иконки пункта ширина: ' + '%c' + conf_iconSizeP[0], ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
console.log('%cРазмер иконки пункта высота: ' + '%c' + conf_iconSizeP[1], ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
console.log('%cОтступ иконки пункта по ширине: ' + '%c' + conf_iconOffsetP[0], ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
console.log('%cОтступ иконки пункта по высоте: ' + '%c' + conf_iconOffsetP[1], ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
console.log('%cЦвет маршрута: ' + '%c' + conf_colorRoute, ' color: #39356b;', 'color: #39356b; text-decoration: underline;');







var cdekPrice = 0;
setPriceCart(cdekPrice);
$('input.city').val('');




//-------------------------------------------------------------------------//
		// Выбор пункта и запись в скрытое поле  //
//-------------------------------------------------------------------------//


$(document).on('change','#cdek-punkt-address select',function(){
    selectCdek($(this).val());
});

//-------------------------------------------------------------------------//
		// Создаем объект карта //
//-------------------------------------------------------------------------//

        myMap = new ymaps.Map("sdek", {
            center: [conf_center[0],conf_center[1]],
            controls: ['zoomControl',  'fullscreenControl'],
            zoom: 7
        });



//-------------------------------------------------------------------------//
		// Функция геокодирование адреса и вызов renderTopunkt //
//-------------------------------------------------------------------------//

		function cityGeocode(coords) {
			$.jGrowl('Функция геокодирование адреса' , { theme: 'message-system', life: 2500 });
			ymaps.geocode(coords, { //геокодирование адреса
				kind: 'locality',
		        results: 1
		    }).then(function (res) {
		    	var full_address  = res.geoObjects.get(0).properties.get('name');
		    	$('input.city').val(full_address);
				getID();
				renderToPunkt();
			});

		};

//-------------------------------------------------------------------------//
		// Запуск построения маршрута для пунта выдачи //
//-------------------------------------------------------------------------//

		function renderToPunkt() {
			$('#cdek-punkt-address').html('<p>Выберите пункт доставки</p>');

			var totalWeight = parseInt($('.jsTotalWeight').text());
			if (totalWeight >= 30) {
				$('#tariffId').val('15');
			}
			else {
				$('#tariffId').val('12');
			}

			getPunktCdek($('#receiverCityId').val());

			myMap.geoObjects.removeAll();
			myMap.geoObjects.add(CdekPunktCollection);

			$('.punkt').addClass('active');
			$('.dver').removeClass('active');
			$('.sdek-alert').text('Доставка до пункта выдачи СДЭК');
			$.jGrowl('Запуск построения маршрута' , { theme: 'message-system', life: 2500 });
			var city = $( "input.city" ).val(); // получаем адрес

			if (city == '' ) {
				$.jGrowl('Укажите адрес доставки' , { theme: 'message-error', life: 2500 });
			}

			else {
				ymaps.geocode(city, { //геокодирование адреса
				        results: 1
				    }).then(function (res) {
				            // Выбираем первый результат геокодирования.
				            var firstGeoObject = res.geoObjects.get(0);
				            // Координаты геообъекта.
				            var coords = firstGeoObject.geometry.getCoordinates();
				            myMap.setCenter(coords, 11, {
							    checkZoomRange: true
							});
					});	
			}

		}

//-------------------------------------------------------------------------//
		// Построение маршрута //
//-------------------------------------------------------------------------//

		function routeCreatePunkt(coords, city) {
			//$.jGrowl('Построение маршрута' , { theme: 'message-system', life: 2500 });
			var myRoute = ymaps.route([[conf_center[0],conf_center[1]],coords], { // строим маршрут от начальной точки, посмотреть в ГЕОКОДЕРЕ ЯНДЕКС
				mapStateAutoApply: true // Автоматически позиционировать карту.
			}).then(function (route) {
				routeCreate(route);
			});
		};

//-------------------------------------------------------------------------//
		// Оформление и добавление маршрута //
//-------------------------------------------------------------------------//


		function routeCreate(route) {// когда маршрут построится
			//$.jGrowl('Оформление маршрута' , { theme: 'message-system', life: 2500 });
			rout = route;
			myMap.geoObjects.add(rout);
			console.log('routeCreate');

			var points = rout.getWayPoints(); //точки маршрута

			 points.options.set({
	        	iconColor: conf_colorRoute,
	        	iconLayout: 'default#image',
	            iconImageHref: conf_iconLink, //ссылка
	            iconImageSize: [parseInt(conf_iconSize[0]), parseInt(conf_iconSize[1])], // размер
	            iconImageOffset: [parseInt(conf_iconOffset[0]), parseInt(conf_iconOffset[1])] //отступы
	        });


			 // Создадим макет содержимого балуна маршрута.
            balloonContentLayout = ymaps.templateLayoutFactory.createClass(
                    '<p class="baloon-text">' + conf_iconText + '</p>');
            route.options.set('routeBalloonContentLayout', balloonContentLayout);



		    // Задаем содержимое балуна точек
		    points.get(0).properties.set('balloonContent', '<p class="baloon-text">' + conf_iconText + '</p>');
		    

		    rout.getPaths().options.set( {
		    	strokeColor: conf_colorRoute,
		    	strokeWidth: 5
		    });


		};

//-------------------------------------------------------------------------//
		// Запуск построения маршрута до адреса  //
//-------------------------------------------------------------------------//

		function renderToHome() {

				myMap.geoObjects.removeAll();

				var totalWeight = parseInt($('.jsTotalWeight').text());
				if (totalWeight >= 30) {
					$('#tariffId').val('16');
				}
				else {
					$('#tariffId').val('1');
				}


				$('#cdek-punkt-address').html('');
				$('.punkt').removeClass('active');
				$('.dver').addClass('active');
				$('.sdek-alert').text('Доставка до двери СДЭК');

				var city = $( "input.city" ).val(); // получаем адрес
				var street = $( "input.street" ).val(); // получаем адрес
				var building = $( "input.house" ).val(); // получаем адрес
				var room = $( "input.apartament" ).val(); // получаем адрес
				var address = city + ' ' + street + ' ' + building;

				console.log('%cАдрес доставки: ' + '%c' + address, ' color: #39356b;', 'color: #39356b; text-decoration: underline;');
				

				if (city == '') {
					$.jGrowl('Укажите адрес доставки' , { theme: 'message-error', life: 2500 });
				}
				else {
					ymaps.geocode(address, { //геокодирование адреса
					        results: 1
					    }).then(function (res) {
					            // Выбираем первый результат геокодирования.
					            var firstGeoObject = res.geoObjects.get(0);
					            // Координаты геообъекта.
					            var coords = firstGeoObject.geometry.getCoordinates();
								routeCreatePunkt(coords, city); // вызов функции построения маршрута
						});	
				}
		}


//-------------------------------------------------------------------------//
		// Получение ID города //
//-------------------------------------------------------------------------//
		
		function getID() {
			$.jGrowl('Получение ID города' , { theme: 'message-system', life: 2500 });

				$.ajax({
					url : "https://api.cdek.ru/city/getListByTerm/jsonp.php?callback=?",
					dataType : "json",
					data : {
						q : function() {
							return $(".city").val()
						},
						name_startsWith : function() {
							return $(".city").val()
						}
					},
					success : function(data) {
						$('#receiverCityId').val(data.geonames[0].id);
						setTimeout(function(){calc();}, 500)
					}
				});			
		}




//-------------------------------------------------------------------------//
		// Проверка города //
//-------------------------------------------------------------------------//
	
	$('input.city').change(function() {
		validateCity($(this).val());
	});
	$('input.street').change(function() {
		setTimeout(function() { renderToHome(); }, 300);
	});
	$('input.house').change(function() {
		setTimeout(function() { renderToHome(); }, 300);
	});


	function validateCity(city) {
		$.jGrowl('Проверка города' , { theme: 'message-system', life: 2500 });

		ymaps.geocode(city, { //геокодирование адреса
			kind: 'locality',
	        results: 1
	    }).then(function (res) {
	    	var full_address  = res.geoObjects.get(0).properties.get('name');
	    	$('input.city').val(full_address);
	    	getID();
	    	renderToHome();
		});
	}


//-------------------------------------------------------------------------//
		// Рассчет стоимости  //
//-------------------------------------------------------------------------//



		function calc() {
			$.jGrowl('Рассчет стоимости' , { theme: 'message-system', life: 2500 });

			var formData = form2js('cdek', '.', true, function(node) {
				if(node.id && node.id.match(/callbackTest/)) {
					return {
						name : node.id,
						value : node.innerHTML
					};
				}
			});

			var formDataJson = JSON.stringify(formData);
			//console.log(JSON.stringify(formData));
			//$('#testArea').html('Отправляемые данные: <br />' + JSON.stringify(formData, null, '\t'));

			$.ajax({
				url : 'https://api.cdek.ru/calculator/calculate_price_by_jsonp.php',
				jsonp : 'callback',
				data : {
					"json" : formDataJson
				},
				type : 'GET',
				dataType : "jsonp",
				success : function(data) {
				    //console.log(data);
				    if(data.hasOwnProperty("result")) {

				    	
			    		cdekPrice = data.result.price;
				    	setPriceCart(cdekPrice);
				    	dateShipping(data.result.deliveryDateMin, data.result.deliveryDateMax, data.result.deliveryPeriodMin, data.result.deliveryPeriodMax);
						console.log('%cСтоимость доставки: ' + '%c' + cdekPrice, ' color: #39356b;', 'color: #39356b; text-decoration: underline;');


				    	

					} else {
						$.jGrowl('Не удалось посчитать стоимость, пожалуйста проверьте адрес или уточните у менеджера' , { theme: 'message-error', life: 2500 });
					}
				},
				error: function (error) {
				    console.log(error);
				}
			});
			
		};


//-------------------------------------------------------------------------//
		// Установка цены  + //
//-------------------------------------------------------------------------//



function setPriceCart(cdekPrice, shipper) {
	//$.jGrowl('Установка цены' , { theme: 'message-system', life: 2500 });

	// Проверка на скидку/наценку 

	if ( (conf_discont == '') || (conf_discont == '1') ) {
		$('.counter-cdek-price input').val(cdekPrice).trigger('change');
	}
	else {
		cdekPrice = parseInt(cdekPrice) * parseFloat(conf_discont);
		$('.counter-cdek-price input').val(cdekPrice).trigger('change');
	}

	//$.jGrowl('Стоимость доставки: '+ parseInt(cdekPrice) , { theme: 'message-success', life: 2500 });
}

//-------------------------------------------------------------------------//
		// Подмена цен  //
//-------------------------------------------------------------------------//


function dateShipping(deliveryDateMin, deliveryDateMax, deliveryPeriodMin, deliveryPeriodMax) {


		deliveryDateMinArr = deliveryDateMin.split('-');
		deliveryDateMin = deliveryDateMinArr[2] + '.' + deliveryDateMinArr[1];

		deliveryDateMaxArr = deliveryDateMax.split('-');
		deliveryDateMax = deliveryDateMaxArr[2] + '.' + deliveryDateMaxArr[1];

		$('.sdek-info-srok').text(deliveryPeriodMin + ' - '+ deliveryPeriodMax);
		$('.sdek-info-time').text( ' c '+ deliveryDateMin + ' по '+ deliveryDateMax);

};

//-------------------------------------------------------------------------//
		// Евент изменения количества  //
//-------------------------------------------------------------------------//

function changeCount() {

		setTimeout(function(){
			city = $('input.city').val();
			validateCity(city);
		}, 1000);
}

$('.input-quantity').change(function() {
	changeCount();
});

$('.jsQuantity .jsAdd, .jsQuantity .jsRemove, .jsDelete').click(function() {
	changeCount();
});


//-------------------------------------------------------------------------//
		// Эвенты кнопок  //
//-------------------------------------------------------------------------//

		$('.sdek-change span').click(function(){
				getID();

			if ($(this).hasClass('punkt')) {
				setTimeout(function() { renderToPunkt(); }, 300);
			}

			else {
				setTimeout(function() { renderToHome(); }, 300);
			};
		});








//-------------------------------------------------------------------------//
		// Добавление пунктов по городу //
//-------------------------------------------------------------------------//


		function getPunktCdek(cityID) {
			$.ajax({
				url : 'https://integration.cdek.ru/pvzlist/v1/xml',
				type : 'GET',
				data : {
					"cityid" : cityID
				},
				success : function(data) {
				    xmlParser(data);
				    
				},
				error: function (error) {
				    console.log('error');
				}
			});
			
		};





//-------------------------------------------------------------------------//
		// Разбор ответа пунктов по городу //
//-------------------------------------------------------------------------//
var punktCity = '';
var punktAddress = '';
var punktWorkTime = '';

	function xmlParser(xml) {

		var i = 0;
	    $(xml).find("Pvz").each(function () {
	    	punktCity = $(this).attr('City');
	    	punktAddress = $(this).attr('FullAddress');
	    	punktWorkTime = $(this).attr('WorkTime');
	    	if (i == 0) {
				$('.hiddensdek').val(punktAddress);
				$('.hiddensdek').text(punktAddress);
	    	}
	        i++;

	        cityPunktParser(punktAddress, punktCity, punktWorkTime);


            


	    });
	}


//-------------------------------------------------------------------------//
		// Создаем коллекцию меток //
//-------------------------------------------------------------------------//


 		var CdekPunktCollection = new ymaps.GeoObjectCollection(null, {
            preset: 'islands#violetStretchyIcon',
            iconColor: conf_colorRoute,
            iconLayout: 'default#image',
            iconImageHref: conf_iconLink, //ссылка
            iconImageSize: [parseInt(conf_iconSizeP[0]), parseInt(conf_iconSizeP[1])], // размер
            iconImageOffset: [parseInt(conf_iconOffsetP[0]), parseInt(conf_iconOffsetP[1])] //отступы
        });



//-------------------------------------------------------------------------//
		// Парсер пунктов города  //
//-------------------------------------------------------------------------//

	function cityPunktParser(punktAddress, punktCity, punktWorkTime) {
		CdekPunktCollection.removeAll();
		ymaps.geocode(punktAddress, { //геокодирование адреса
			        results: 1
	    	}).then(function (res) {
		            var firstGeoObject = res.geoObjects.get(0);
		            var coords = firstGeoObject.geometry.getCoordinates();


		            CdekPunktCollection.add(myCityPlacemark = new ymaps.Placemark(coords));
			             myCityPlacemark.properties.set('balloonContent' , 'Адрес: '+ punktAddress + '<br> Режим работы: ' + punktWorkTime );

						myCityPlacemark.events.add('click', function (e) {            	
						 	selectCdek(punktAddress);
			            });

			        
			});


	}	


	function selectCdek (punk_address) {
		$('.hiddensdek').val(punk_address);
		$('.hiddensdek').text(punk_address);
		$('#cdek-punkt-address').html('<p>Пункт доставки по адресу: ' + punk_address);
	}





});


