<?php
/**
@coder  Alexey Pakhomov  <web@2f-vsk.ru>
**/

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Class JBCartElementShippingManual
 */
class JBCartElementShippingSdek extends JBCartElementShipping
{

    /**
     * @param array $params
     * @return bool
     */
    public function hasValue($params = array())
    {
        return true;
    }




    protected function _renderCdekPrice()
    {
        return $this->app->jbhtml->text($this->getControlName('cdek-price'), '0');
    }
    /**
     * @return JBCartValue
     */
    public function getRate()
    {

        $cdek_price = $this->get('cdek-price');

        return $this->_order->val($cdek_price);
    }


    public function getLogin()
    {
        return $this->config->get('login');
    }
    public function getToken()
    {
        return $this->config->get('token');
    }
    public function getDiscont()
    {
        return $this->config->get('discont');
    }
    public function getCenter()
    {
        return $this->config->get('center');
    }

    public function getSenderCity()
    {
        return $this->config->get('senderCityId');
    }

    public function getColorRoute()
    {
        return $this->config->get('colorRoute');
    }

    public function getIconLink()
    {
        return $this->config->get('iconLink');
    }

    public function getIconText()
    {
        return $this->config->get('iconText');
    }

    public function getIconSize()
    {
        return $this->config->get('iconSize');
    }

    public function getIconOffset()
    {
        return $this->config->get('iconOffset');
    }

    public function getIconLinkP()
    {
        return $this->config->get('iconLinkP');
    }

    public function getIconSizeP()
    {
        return $this->config->get('iconSizeP');
    }

    public function getIconOffsetP()
    {
        return $this->config->get('iconOffsetP');
    }


    public function getWeight()
    {
        //return $this->config->get('weight');
        return $weight = $this->_order->getTotalWeight();
    }

    public function getLength()
    {
        //return $this->config->get('length');
        $length = 0;
        
        $items = $this->_order->getItems();
        foreach ($items as $item) {
            $quantity  = $item->get('quantity', 1);
            $length = $length + ($item->find('elements._properties.length', 0.1) * $quantity);  
        }

        return $length;
    }

    public function getWidth()
    {
        //return $this->config->get('width');
        $width = 0;
        
        $items = $this->_order->getItems();
        foreach ($items as $item) {
            $quantity  = $item->get('quantity', 1);
            $width = $width + ($item->find('elements._properties.width', 0.1) * $quantity);  
        }

        return $width;
    }

    public function getHeight()
    {
        //return $this->config->get('height');
        $height = 0;
        
        $items = $this->_order->getItems();
        foreach ($items as $item) {
            $quantity  = $item->get('quantity', 1);
            $height = $height + ($item->find('elements._properties.height', 0.1) * $quantity);  
        }

        return $height;
    }



}
