<?php
/**
 * @package    JLSitemap - Zoo Plugin
 * @version    1.6.0
 * @author     Васюков Дмитрий - fictionlabs.ru
 * @copyright  Copyright (c) Fictionlans. All rights reserved.
 * @license    GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * @link       https://fictionlabs.ru/
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Registry\Registry;

class plgJLSitemapZoo extends CMSPlugin
{
	/**
	 * Affects constructor behavior. If true, language files will be loaded automatically.
	 *
	 * @var boolean
	 *
	 * @since 0.0.1
	 */
	protected $autoloadLanguage = true;

	/**
	 * Method to get urls array
	 *
	 * @param array    $urls   Urls array
	 * @param Registry $config Component config
	 *
	 * @return array Urls array with attributes
	 *
	 * @since 0.0.1
	 */
	public function onGetUrls(&$urls, $config)
	{	
		// // Check Zoo Component
		if (!JFile::exists(JPATH_ADMINISTRATOR.'/components/com_zoo/config.php')
				|| !JComponentHelper::getComponent('com_zoo', true)->enabled) 
		{
			return $urls;
		}

		if (!$this->params->get('applications_enable')
			&& !$this->params->get('categories_enable')
			&& !$this->params->get('items_enable'))
		{
			return $urls;
		}

		// load zoo config
		require_once (JPATH_ADMINISTRATOR.'/components/com_zoo/config.php');

		// get the ZOO App instance
		$zoo = App::getInstance('zoo');

		// get dates
		$nullDate   	= $zoo->database->getNullDate();
		$nowDate    	= Factory::getDate()->toUnix();

		// Applications
		if ($this->params->get('applications_enable', false)) {

			$changefreq 	= $this->params->get('applications_changefreq', $config->get('changefreq', 'weekly'));
			$priority   	= $this->params->get('applications_priority', $config->get('priority', '0.5'));

			// Get Applications
			$applications 	= $zoo->application->getApplications();

			if (!empty($applications)) {
				foreach ($applications as $row) {
					// Prepare application object
					$application              = new stdClass();
					$application->type       = Text::_('PLG_JLSITEMAP_ZOO_TYPES_APPLICATION');
					$application->title      = $row->params->get('content.category_title') ? $row->params->get('content.category_title') : $app->name;
					$application->loc        = $zoo->route->frontpage($row->id);
					$application->changefreq = $changefreq;
					$application->priority   = $priority;
					$application->exclude    = false;
					$application->alternates = false;

					// Add applications to urls
					$urls[] = $application;
				}
			}
		}

		// Categories
		if ($this->params->get('categories_enable', false)) {

			$changefreq 	= $this->params->get('categories_changefreq', $config->get('changefreq', 'weekly'));
			$priority   	= $this->params->get('categories_priority', $config->get('priority', '0.5'));

			// Get Applications
			$applications 	= $zoo->application->getApplications();

			if (!empty($applications)) {
				foreach ($applications as $application) {
					// Get Categories
					$categories = $application->getCategories(false);

					if (!empty($categories)) {

						foreach ($categories as $row) {
							// Prepare exclude attribute
							$exclude = array();

							if (preg_match('/noindex/', $row->params->get('metadata.robots'))) { // Check robots
								$exclude[] = array('type' => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_CATEGORY'),
								                   'msg'  => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_CATEGORY_ROBOTS'));
							}

							if (!$row->published) { // check published
								$exclude[] = array(
									'type' => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_CATEGORY'),
									'msg'  => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_CATEGORY_UNPUBLISH')
								);
							}

							// Prepare category object
							$category             = new stdClass();
							$category->type       = Text::_('PLG_JLSITEMAP_ZOO_TYPES_CATEGORY');
							$category->title      = $row->name;
							$category->loc        = $zoo->route->category($row);
							$category->changefreq = $changefreq;
							$category->priority   = $priority;
							$category->exclude    = (!empty($exclude)) ? $exclude : false;
							$category->alternates = false;

							// Add category to urls
							$urls[] = $category;
						}
					}
				}
			}
		}

		// Items
		if ($this->params->get('items_enable', false)) {

			$changefreq 	= $this->params->get('items_changefreq', $config->get('changefreq', 'weekly'));
			$priority   	= $this->params->get('items_priority', $config->get('priority', '0.5'));

			// Get Items
        	$items = $zoo->table->item->all();

			if (!empty($items)) {
				foreach ($items as $row) {
					
					// Prepare exclude attribute
					$exclude = array();

					if (preg_match('/noindex/', $row->params->get('metadata.robots'))) {
						$exclude[] = array('type' => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_CATEGORY'),
						                   'msg'  => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_CATEGORY_ROBOTS'));
					}

					if (!$row->state) { // check state
						$exclude[] = array(
							'type' => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_ITEM'),
							'msg'  => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_ITEM_UNPUBLISH')
						);
					}

					if (!in_array($row->access, $config->get('guestAccess', array()))) { // Check access
						$exclude[] = array(
							'type' => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_ITEM'),
							'msg'  => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_ITEM_ACCESS')
						);
					}

					if (!$row->searchable) { // Check searchale
						$exclude[] = array(
							'type' => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_ITEM'),
							'msg'  => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_ITEM_SEARCHABLE')
						);
					}

					if ($row->publish_up == $nullDate || Factory::getDate($row->publish_up)->toUnix() > $nowDate) { // Check publish up
						$exclude[] = array('type' => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_ITEM'),
						                   'msg'  => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_ITEM_PUBLISH_UP'));
					}

					if ($row->publish_down != $nullDate && Factory::getDate($row->publish_down)->toUnix() < $nowDate) { // Check publish down
						$exclude[] = array('type' => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_ITEM'),
						                   'msg'  => Text::_('PLG_JLSITEMAP_ZOO_EXCLUDE_ITEM_PUBLISH_DOWN'));
					}

					// Prepare item object
					$item             = new stdClass();
					$item->type       = Text::_('PLG_JLSITEMAP_ZOO_TYPES_ITEM');
					$item->title      = $row->name;
					$item->loc        = $zoo->route->item($row);
					$item->changefreq = $changefreq;
					$item->priority   = $priority;
					$item->exclude    = (!empty($exclude)) ? $exclude : false;
					$item->alternates = false;

					// Add item to urls
					$urls[] = $item;
				}
			}
		}

		return $urls;
	}
}