<?php
define('_JEXEC', 1);
define('JBZOO_APP_GROUP', 'jbuniversal');
define('DS', DIRECTORY_SEPARATOR);

// include Joomla!
if (file_exists(dirname(__FILE__) . '/defines.php')) {
	include_once dirname(__FILE__) . '/defines.php';
}

if (!defined('_JDEFINES')) {
	define('JPATH_BASE', dirname(__FILE__));
	require_once JPATH_BASE.'/includes/defines.php';
}

require_once JPATH_BASE.'/includes/framework.php';

//create application
$app = &JFactory::getApplication('site');

// include Zoo & JBZoo
require_once JPATH_BASE . '/administrator/components/com_zoo/config.php';
require_once JPATH_BASE . '/media/zoo/applications/jbuniversal/framework/jbzoo.php';

JBZoo::init();

$zoo = App::getInstance('zoo');

require_once JPATH_LIBRARIES . '/dompdf/autoload.inc.php';

use Dompdf\Dompdf;
use Dompdf\Options;

$dompdf = new DOMPDF();

$dompdf->set_option('fontDir', JPATH_LIBRARIES.'/dompdf/lib/fonts');

$session = JFactory::getSession();
$sid = $session->get('sid');

if ($sid == $session->getId()) {
	$session->clear('sid');
	
	$data_invoice = (array)$session->get('data_invoice');

	$order_id = (int)$data_invoice['order_id'];
	$order = JBModelOrder::model()->getById($order_id);
	//Our requisites
	$prefix_invoice					= JString::trim($order->getPayment()->config->get('prefix_invoice'));
	$vat	 						= JString::trim($order->getPayment()->config->get('VAT'));
	$ourinn 						= JString::trim($order->getPayment()->config->get('INN'));
	$ourkpp 						= JString::trim($order->getPayment()->config->get('KPP'));
	$ourname						= JString::trim($order->getPayment()->config->get('urname'));
	$ouraddress 					= JString::trim($order->getPayment()->config->get('uraddress'));
	$ourbankaccount 				= JString::trim($order->getPayment()->config->get('bankaccount'));
	$ourbank 						= JString::trim($order->getPayment()->config->get('bankname'));
	$ourbankbik 					= JString::trim($order->getPayment()->config->get('bankbik'));
	$ourcoraccount 					= JString::trim($order->getPayment()->config->get('bankcoraccount'));
	$ourdirector 					= JString::trim($order->getPayment()->config->get('director'));
	$ouraccountant 					= JString::trim($order->getPayment()->config->get('accountant'));
	$stamp 							= JString::trim($order->getPayment()->config->get('stamp'));
	$signature						= JString::trim($order->getPayment()->config->get('signature'));
	//Customer requisites
	$organization 					= $order->getElement(JString::trim($order->getPayment()->config->get('clNameID')))->get('value');
	$INN 							= $order->getElement(JString::trim($order->getPayment()->config->get('clINNID')))->get('value');
	$KPP 							= $order->getElement(JString::trim($order->getPayment()->config->get('clKPPID')))->get('value');
	$uraddress 						= $order->getElement(JString::trim($order->getPayment()->config->get('clAddressID')))->get('value');
	$telephone 						= $order->getElement(JString::trim($order->getPayment()->config->get('clPhoneID')))->get('value');
	//
	$sum_items = $order->getTotalForItems();
	$sum_total = $order->getTotalForSevices();
	$ship_name = $order->getShipping()->config->get('name');
	$limit_for_free = (float)$order->getShipping()->config->get('limit_for_free');
	$shipping_cost = $order->getShipping()->config->get('cost');
	
	if ($limit_for_free <= $sum_items->val())
	{
		$shipping_cost = 0;
		$is_shipping = FALSE;		
	}else{
		$is_shipping = TRUE;
	}
	
	$items = $order->getItems();

	$html = '<!DOCTYPE html>
						<html>
							<head>
								<meta charset="utf-8">
								<title>invoice</title>
								<style>
										table.invoice {
											font-family: times;
											font-size: 10pt;
											width: 100%;
											border: black;
											border: 1px solid;
											border-collapse: collapse;
										}
										table.invoice th {
											text-align: left;
											background: #ccc;
											padding: 5px;
										}
										table.invoice td {
											border: 1px solid;
											padding: 5px;
										}
										table.invoice td.td-brdr {
											border: 1px solid;
										}
										table.invoice td.td-fbold {
											font-weight: bold;
										}
										table.invoice td.td-aright {
											text-align: right;
										}
										table.invoice td.td-acenter {
											text-align: center;
										}
										</style>
									</head>
								<body>';
	$html = $html.'<table><tr><td style="text-align: center;"><span style="font-family: times; font-size: 8pt;">
Внимание! Счет действителен в течение 3(трех) банковских дней. По истечении данного срока, цены и сроки поставки подлежат уточнению. Оплата данного счета означает согласие с условиями поставки товара. Уведомление об оплате обязательно, в противном случае не гарантируется наличие товара на складе. Товар отпускается по факту прихода денег на р/с Поставщика, самовывозом, при наличии доверенности и паспорта.<br />
				<span style="font-weight: bold; padding: 25px 0;">Образец заполнения платежного поручения</span></span></td></tr></table>
									<table class="invoice">
										<tr>
										<td  colspan="2" style="border-bottom: none;">'.JText::_($ourbank).'</td>
											<td>БИК</td>
											<td>'.JText::_($ourbankbik).'</td>
										</tr>
										<tr>
										<td colspan="2" style="border-top: none;">
											<span style="font-size: 8pt;">Банк получателя</span></td>
											<td>Сч.№</td>
											<td>'.JText::_($ourcoraccount).'</td>
										</tr>
										<tr>
							 				<td>ИНН '.JText::_($ourinn).'</td>
							 				<td>КПП '.JText::_($ourkpp).'</td>
											<td>Сч.№</td>
											<td>'.JText::_($ourbankaccount).'</td>
										</tr>
										<tr>
											<td colspan="2" style="border-bottom: none;">'.JText::_($ourname).'</td>
											<td style="border-bottom: none;"></td>
											<td style="border-bottom: none;"></td>
										</tr>
										<tr>
											<td colspan="2" style="border-top: none;">
												<span style="font-size: 8pt">Получатель</span>
											</td>
											<td style="border-top: none;"></td>
											<td style="border-top: none;"></td>
										</tr>
									</table>

									<div class="hh1">
									<h2>Счет № '.$prefix_invoice.$order->id.' от '.strftime("%d.%m.%Y",strtotime($order->created)).'</h2></div>
									<hr />
									<table>
										<tr>
											<td style="width: 10%">Поставщик:</td>
											<td><b>ИНН '.JText::_($ourinn).'	КПП '.JText::_($ourkpp)." ".JText::_($ourname).' '.JText::_($ouraddress).'</b></td>
										</tr>
										<tr>
											<td style="width: 10%">Покупатель:</td>
											<td><b>ИНН '.JText::_($INN).' КПП '.JText::_($KPP).', '.JText::_($organization).', '. JText::_($uraddress).', тел.: '.JText::_($telephone).'</b></td>
										</tr>
									</table>
									<br />
									<table class="invoice" border="2px">
										<tr style="border: 2px solid;">
											<td class="td-brdr td-fbold td-acenter" width="10px">№</td>
											<td class="td-brdr td-fbold td-acenter">Наименование товара</td>
											<td class="td-brdr td-fbold td-acenter" width="10px">Кол-во</td>
											<td class="td-brdr td-fbold td-acenter" width="5px">Ед.</td>
											<td class="td-brdr td-fbold td-acenter" width="80px">Цена</td>
											<td class="td-brdr td-fbold td-acenter" width="80px">Сумма</td>
										</tr>';

	$i = 0;
	foreach ($items as $item) {
		$i++;
		//$sku = $item->find('elements._sku');

		$html=$html.'<tr style="border-left: 2px solid; border-right: 2px solid;">
											<td class="td-brdr td-acenter">'. $i.'</td>
											<td>'.JText::_($item->item_name).'</td>
											<td class="td-brdr td-aright">'.JText::_($item->quantity).'</td>
											<td class="td-brdr td-aright">шт</td>
											<td class="td-brdr td-aright">'.JText::_(number_format(sprintf("%01.2f",(int)$item->total),2,',',' ')).'</td>
											<td class="td-brdr td-aright">'.JText::_(number_format(sprintf("%01.2f",(int)$item->total*(int)$item->quantity),2,',',' ')).'</td>
										</tr>';

	}
	//SHIPPING
	if ($is_shipping) {
		$html=$html.'<tr style="border: 2px solid;">
											<td class="td-brdr td-acenter">'. (int)($order->getTotalCountSku()+1) .'</td>
											<td>'.JText::_($ship_name).'</td>
											<td class="td-brdr td-aright">1</td>
											<td class="td-brdr td-aright">шт</td>
											<td class="td-brdr td-aright">'.JText::_(number_format(sprintf("%01.2f",(int)$shipping_cost),2,',',' ')).'</td>
											<td class="td-brdr td-aright">'.JText::_(number_format(sprintf("%01.2f",(int)$shipping_cost),2,',',' ')).'</td>
										</tr>';
	}
	//TOTAL									
	$html=$html.'<tr style="border: 2px solid;">
											<td class="td-brdr td-fbold td-aright" colspan="5">Итого:</td>
											<td class="td-brdr td-fbold td-aright">'. JText::_(number_format(sprintf("%01.2f",$sum_total->val()),2,',',' ')).'</td>
										</tr>
										<tr style="border-bottom: 2px solid; border-left: 2px solid; border-right: 2px solid;">
											<td class="td-brdr td-fbold td-aright" colspan="5">В том числе НДС:</td>
											<td class="td-brdr td-fbold td-aright">'.JText::_(number_format(sprintf("%01.2f",(int)$sum_total->val()*(int)$vat/(100+(int)$vat)),2,',',' ')).'</td>
										</tr>
									</table>
									<br />
									<div>Всего наименований
										<span style="font-weight: bold;">'. $i.'</span>, на сумму
										<span style="font-weight: bold;">'.JText::_(number_format(sprintf("%01.2f",$sum_total->val()),2,',',' ')).' руб.</span></div>
									<hr />
									<table>
										<tr>
											<td colspan="7"></td></tr>
										<tr>
											<td colspan="7"></td></tr>
										<tr>
											<td colspan="7"></td></tr>
										<tr>
											<td colspan="7"></td></tr>
										<tr>
											<td width="10px">Руководитель</td>
											<td width="10%"><div><img src="'.JText::_($signature).'" width="80px"/></div></td>
											<td width="15px">'.JText::_($ourdirector).'</td>
											<td><img src="'.JText::_($stamp).'" width="160px"/></td>
											<td width="10px">Бухгалтер</td>
											<td width="10%"><div><img src="'.JText::_($signature).'" width="80px"/></div></td>
											<td width="15px">'.JText::_($ouraccountant).'</td>
										</tr>
									</table>
								</body>
							</html>';

//echo $html; //for debug
$dompdf->loadhtml($html);
$dompdf->render();
$opt = array ('Attachment' => 1);

$dompdf->stream("invoice.pdf",$opt);

}
else {
	die('Сделайте заказ и выберите оплату по счету.');
}

