<?php
/**
 * JBZoo Element YandexKassaApi
 *
 * This file is part of the JBZoo CCK package.
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @package     JBZoo
 * @license     MIT
 * @copyright   Copyright (C) JBZoo.com, All rights reserved.
 * @link        https://github.com/JBZoo/Element-Payment-YandexKassa
 * @author      Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

require_once __DIR__ . '/lib/autoload.php'; 

use YandexCheckout\Client;
use YandexCheckout\Model\Notification\NotificationSucceeded;
use YandexCheckout\Model\Notification\NotificationWaitingForCapture;
use YandexCheckout\Model\NotificationEventType;


/**
 * Class JBCartElementPaymentYandexKassa
 */
class JBCartElementPaymentYandexKassaApi extends JBCartElementPayment
{
	protected $_shopId;
	protected $_APIkey;
	protected $_idempotenceKey;
	protected $_clientYK;
	protected $_obPayment;
	
	private $finalSum;
	private $shipping;
	private $payCurrency;
	private $comissionInAmount;
	private $isRobot;
	
	/**
	* Клиент API YandexKassa
	* 
	* @return 
	*/
	private function _getClientYK()
	{		
		$this->_shopId = trim($this->config->get('shopId'));
		$this->_APIkey = trim($this->config->get('APIkey'));

		$this->_clientYK = new Client();
		$this->_clientYK->setAuth($this->_shopId, $this->_APIkey);
	}
	
	/**
	* 
	* @param String $paymentId
	* 
	* @return PaymentInterface $object
	*/
	public function getPaymentYK($paymentId)
	{
		$this->_getClientYK();	
		$this->_obPayment = $this->_clientYK->getPaymentInfo($paymentId);
		
		return $this->_obPayment;
	}
	
	/**
	* 
	* 
	* @return string
	*/
	public function getStatusPaymentYK()
	{
		$status = $this->_obPayment->getStatus();
		
		return $status;
	}
	
	/**
	* 
	* 
	* @return bool
	*/
	public function getIsTest()
	{
		$isTest = $this->_obPayment->getTest();

		return $isTest;
	}
	
    /**
     * Redirect to payment action
     * @return null|string
     */
    public function getRedirectUrl()
    {
		$this->_getClientYK();

		$_idempotenceKey = uniqid('', true);
		
		$this->finalSum = $this->_getFinalSumPayment();
		
		$order       	= JBModelOrder::model()->getById($this->getOrder()->id);
		
		$fieldsOrder 	= $order->getFields();
		$UserTel 		= $fieldsOrder->get($this->config->get('cps_phone'))->value;
		$UserEmail 		= $fieldsOrder->get($this->config->get('cps_email'))->value;
		
		$this->shipping = $this->getOrder()->getShipping()->getRate();;
		$this->payCurrency = strtoupper($order->getCurrency());
		
		$arItemsData = array();
		
		$cartItems = $order->getItems(false);

		foreach ($cartItems as $num=>$cartItem) {
			$arItemData = array();
			$arItemData['description']		= addslashes(substr(JText::_($cartItem->get('item_name')),0,127));
			$arItemData['quantity']			= (string)JText::_($cartItem->quantity);
			if ($this->_isOrderModifiers())
			{
				$valueAmount = (float)$cartItem->elements['_value'];
				$arItemData['amount']		=  array('value'=>number_format($this->_getValidOrderItemsAmount($valueAmount),2,'.',''),'currency'=>$this->payCurrency);
			}
			else
			{
				$arItemData['amount']		= array('value'=>number_format($cartItem->elements['_value'],2,'.',''),'currency'=>$this->payCurrency);
			}

			$arItemData['vat_code']			= $this->config->get('tax');
			$arItemData['payment_subject'] 	= 'commodity';
			$arItemData['payment_mode']		= 'full_payment';
			$arItemsData[$num] 				= $arItemData;
		}
		
		//add shipping row
		if ((float)$this->shipping->val() > 0)
		{
			$rowShipping = $this->_getShippingRow($order);
			if (!is_null($rowShipping))
			{
				$arItemsData[uniqid('',true)] = $rowShipping;
			}
		}

        $objPayment = array(
        	'amount' => array('value'=>$this->finalSum,'currency'=>$this->payCurrency),
			'description' => 'Оплата заказа №'.$order->id,
			'receipt' => array(
								'customer'=>array('email'=>$UserEmail),
								'items'=>$arItemsData,
								'email'=>$UserEmail
								),
			'payment_method_data'=>$this->_getPaymentMethodData(),
			'confirmation'=>array(
									'type'=>'redirect',
									'return_url'=>$this->config->get('return_url')
								),
        	'capture'=>TRUE,
			'metadata'=>array('order_id'=>trim($order->id))
        );

		$responseYK = $this->_clientYK->createPayment($objPayment,$_idempotenceKey);
		$this->_obPayment = $responseYK;
		
		$session = JFactory::getSession();
		$data_payment['paymentId'] = $this->_obPayment->getId();
		$data_payment['orderId'] = $order->id;
		$session->set('paymentData',(array)$data_payment);
		
		//get confirmation url
		$confirmationUrl = $responseYK->getConfirmation()->getConfirmationUrl();
		
		return $confirmationUrl;
    }
    
    /**
     * Checking 
     * @param array $params
     * @return bool
     */
    public function isValid($params = array())
    {
		$this->_getClientYK();
		
		$isPaid 		= $this->_obPayment->getPaid(); //bool
		$isTestP		= $this->_obPayment->getTest(); //bool
		$isTest			= $this->_getIsTest();
		
		$requestBody = json_decode(json_encode($this->_obPayment), true);

		$statusPaymentYK 	= $this->getStatusPaymentYK();

		$cart = JBCart::getInstance();
		
		if ($statusPaymentYK === 'pending'){
			$default = $cart->getDefaultStatus(JBCart::STATUS_PAYMENT);
			$this->setStatus($default);
			
		}elseif ($statusPaymentYK === 'waiting_for_capture'){

		}elseif($statusPaymentYK === 'succeeded'){

		}elseif($statusPaymentYK === 'canceled'){
			$status = $this->_order->getParams()->config['default_payment_status_error'];
			$this->setStatus($status);
			JBModelOrder::model()->save($this->_order);
			
			$this->renderResponseForRobot();
			
			$app = JFactory::getApplication();
			$app->redirect($this->_jbrouter->payment('fail'));
			return false;
		}
		
		$this->renderResponseForRobot();
		
		if ($isPaid)// && ($isTest && $isTestP))
		{
			$this->_order->setStatus('paid');
			JBCartElementPayment::set('value',$requestBody);
			return true;
		}
		
		return false;
    }

    /**
     * Detect order id from merchant's robot request
     * 
     * @return int
     */
    public function getRequestOrderId()
    {
		//$this->app->jbcartelement->create($this->_type, $this->_namespace);
		
		$source = file_get_contents('php://input');
		$requestBody = json_decode($source, true);

		//$orderId = $requestBody['object']['metadata']['order_id'];

		if (!is_null($requestBody))
		{
			try {
				$notification = ($requestBody['event'] === NotificationEventType::PAYMENT_SUCCEEDED)
				? new NotificationSucceeded($requestBody)
				: new NotificationWaitingForCapture($requestBody);
			} catch (Exception $e) {
				// Обработка ошибок при неверных данных
				throw new Exception($e);
			}
			
			$this->_obPayment = $notification->getObject();
			$this->isRobot = TRUE;
		} else {
			$session = JFactory::getSession();
			$paymentId = $session->get('paymentData')['paymentId'];
			$orderId = $session->get('paymentData')['orderId'];
			
			if (empty($paymentId)) {
				return 0;
			}
			
			$this->_obPayment = $this->getPaymentYK($paymentId);
		}    
		
		if (!empty($this->_obPayment)) {
			$metaDataPayment = $this->_obPayment->getMetadata();
			
			return (int)$metaDataPayment['order_id'];
		}
		
		return 0;
    }

    /**
     * @return JBCartValue
     */
    public function getRequestOrderSum()
    {
    	//kostyl for robot
		$this->getRequestOrderId();
		
		$this->_getClientYK();
		if (!$this->_obPayment)
		{
			$this->_obPayment = $this->getPaymentYK(JFactory::getSession()->get('paymentData')['paymentId']);
			$amount = $this->_obPayment->getAmount()->value;
		}else{
			$amount = $this->_obPayment->getAmount()->value;
		}
		
		return $this->_order->val($amount, $this->_order->getCurrency());
    }

    /**
     * {@inheritdoc}
     */
    public function renderResponse()
    {		
		$app = JFactory::getApplication();
		$app->redirect($this->_jbrouter->payment('success'));
    }
    
    private function renderResponseForRobot(){
		if ($this->isRobot) {
			header("HTTP/1.0 200 OK");
			jexit("OK");
		}
    }

    /**
     * Set payment rate
     * @return JBCartValue
     */
    public function getRate()
    {
        return $this->_order->val($this->config->get('rate', '3.5%'));
    }
    
    /**
	* 
	* @return
	*/
    protected function _isOrderModifiers()
    {
		$modifiers = $this->getOrder()->getModifiersOrderPrice();
		if (is_array($modifiers)){
			foreach ($modifiers as $identifier=>$modifier)
			{
				$rate = (float)$modifier->getRate()->noStyle();
				$zero = (float)$this->getOrder()->val(0)->noStyle();
				if ((float)abs($modifier->getRate()->noStyle()) > (float)$this->getOrder()->val(0)->noStyle())
				{
					return true;
				}
			}
		}
		return false;
    }
    
	/**
	* 
	* @return float
	*/
	private function _getValidOrderItemsAmount($curItemAmount)
	{
		$sumItems = $this->getOrder()->getTotalForItems();
		$sumOrder = $this->getOrder()->getTotalForSevices();
		
		$shippingCost = $this->shipping;
		
		$totalDifference = (float)$sumOrder->val() - (float)$shippingCost->val() - (float)$sumItems->val();
		
		if (abs($totalDifference) > 0)
		{
			$weightСoefficient = (float)$curItemAmount/(float)$sumItems->val();
			
			$curItemAmount = (float)$curItemAmount + ($totalDifference*$weightСoefficient);

			return $curItemAmount;
		}
	}
	
	/**
	*Формирует данные по доставке
	* 
	* @param JBCartOrder $order
	*
	* @return array()
	*/
	private function getShippingData($order)
	{
		$shData['ship_name'] 		= $order->getShipping()->config->get('name');
		$shData['limit_for_free'] 	= $order->getShipping()->config->get('limit_for_free');
		$shData['shipping_cost'] 	= $order->getShipping()->config->get('cost');

		return $shData;
	}
	
	/**
	* Формирует строку для объекта платежа с данными по доставке, если стоимость доставки учитывается в заказе
	*
	* @param JBCartOrder $order
	*
	* @return array
	*/
	private function _getShippingRow($order)
	{
		$shippingData = $this->getShippingData($order);

		$arItemShippingData = array(
		'description'=>$shippingData['ship_name'],
		'quantity'=>'1',
		'amount'=>array('value'=>number_format((int)$shippingData['shipping_cost'],2,'.',''),'currency'=>$this->payCurrency),
		'vat_code'=>$this->config->get('tax'),
		'payment_subject'=>'service',
		'payment_mode'=>'full_payment'
		);

		return $arItemShippingData;
	}
    
    /**
	* Возвращает из настроек признак использования тестового магазина
	* 
	* @return bool
	*/
    private function _getIsTest()
    {
		$isTest = $this->config->get('isTest', 'no');
		
		$isTest = ($isTest == 'yes') ? TRUE : FALSE;
		
		return (bool)$isTest;
    }
    
    /**
	* 
	* @return array
	*/
    private function _getPaymentMethodData()
    {
    	
		$method = $this->config->get('paymentType', 'bank_card');
		
		//TODO for other methods the array list fields are different
		
		return array('type' => $method);
    }
    
    /**
	* 
	* @return string
	*/
    private function _getFinalSumPayment()
    {
		return number_format($this->modify($this->getOrderSumm())->val(), 2, '.','');
    }
}
