<?php
/**
 * JBZoo Application
 *
 * This file is part of the JBZoo CCK package.
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @package    Application
 * @license    GPL-2.0
 * @copyright  Copyright (C) JBZoo.com, All rights reserved.
 * @link       https://github.com/JBZoo/JBZoo
 * @author     Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

require_once 'smsru/sms.ru.php';
/**
 * Class JBCartElementNotificationSmsru
 */
class JBCartElementNotificationSmsru extends JBCartElementNotification
{

    /**
     * Launch notification
     * @return void
     */
    public function notify()
    {
        $phones   = $this->_getPhones();
		$api_id   = JString::trim($this->config->get('sms_apiid'));
		$isTest   = $this->config->get('isTest');
        $text     = $this->_macros->renderText($this->config->get('message'), $this->getOrder());
		$partner_id = JString::trim($this->config->get('partner_id'));
		if (
			!empty($api_id) &&
            !empty($phones) && !empty($text)
        ) {

            $this->_sendSMS($phones, array(
				'api_id'    => $api_id,
				'isTest'	=> $isTest,
                'text'     	=> $text,
                'partner_id' => $partner_id
            ));
        }
    }

    /**
     * Send sms
     * @param array $phones
     * @param array $params
     * @return array|bool
     */
    protected function _sendSMS($phones, $params)
    {
        foreach ($phones as $phone) {
            $phoneList .= $phone . ',';
        }
        //delete last ','
		substr_replace($phoneList, '', 1, -1);

		$smsru = new SMSRU($params['api_id']); 

		$data = new stdClass();

		$data->to = $phoneList;
		$data->text = $params['text'];

		if ($params['isTest']) {
			$data->test = 1;
		}
		
		if (!empty($params['partner_id'])) {
			$data->partner_id = $params['partner_id'];
		}
		
		$response = $smsru->send($data);
        return $response;
    }

    /**
     * @return array
     */
    protected function _getPhones()
    {
        $result = array();

        // custom phones
        $phones = $this->app->jbstring->parseLines($this->config->get('phones', ''));

        // form field
        $elements = $this->config->get('userphone', array());
        if (!empty($elements)) {
            foreach ($elements as $elementID) {

                if ($element = $this->getOrder()->getFieldElement($elementID)) {
                    $data     = $element->data();
                    $phones[] = $data->get('value');
                }
            }
        }

        // clean & check
        foreach ($phones as $phone) {
            $result[] = $this->app->jbvars->phone($phone);
        }
        $result = array_filter($result);
        $result = array_unique($result);

        return $result;
    }

}
