<?php
/**
* @package   ZOO Component
* @file      graphibox.php
* @version   3.0.0 December 2012
* @author    Attavus M.D. http://www.raslab.org
* @copyright Copyright (C) 2011 - 2012 R.A.S.Lab[.org]
* @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

// register ElementOption class
App::getInstance('zoo')->loader->register('ElementOption', 'elements:option/option.php');

/*
	Class: ElementGraphiBox
		The checkbox element class
*/
class ElementGraphiBox extends ElementOption implements iSubmittable {

	/*
	   Function: Constructor
	*/
	public function __construct() {
		parent::__construct();
		// load language
		$this->loadLanguage();
	}	
	
	/*
		Function: getConfigForm
			Get parameter form object to render input form.

		Returns:
			Parameter Object
	*/
	public function getConfigForm() {

		$form = parent::getConfigForm();
		$form->addElementPath(dirname(__FILE__).'/cform');

		return $form;
	}	
	
	/*
		Function: loadConfigAssets()
			Load elements css/js config assets.

		Returns:
			Void
	*/
	public function loadConfigAssets() {
		$this->app->document->addScript('assets:js/image.js');
		$this->app->document->addStylesheet('elements:graphibox/assets/css/editoption.css');		
		return parent::loadConfigAssets();
	}
	
	/*
	   Function: editOption
	      Renders elements options for form input.

	   Parameters:
	      $var - form var name
	      $num - option order number

	   Returns:
		  Array
	*/
	public function editOption ($var, $num, $name = null, $value = null, $image = null){

		// init vars
		$path = $this->app->path->path("elements:graphibox/tmpl/editoption.php");

		// render option
		$__html = '';
		ob_start();
		include($path);
		$__html = ob_get_contents();
		ob_end_clean();

		return $__html;
	}	
		
	/*
	   Function: edit
	       Renders the edit form field.

	   Returns:
	       String - html
	*/
	public function edit(){

		// init vars
		$options_from_config 	= $this->config->get('option', array());
		$default				= $this->config->get('default');
		
		if (count($options_from_config)) {		
			// set default, if item is new
			if ($default != '' && $this->_item != null && $this->_item->id == 0) {
				$default = array($default);
			} else {
				$default = array();
			}
			
			$selected_options  = $this->get('option', array());
			
			$i       = 0;
			$html    = array();			
	
			foreach ($options_from_config as $option) {
				$name = $this->getControlName('option', true);
				$checked = in_array($option['value'], $selected_options) ? ' checked="checked"' : null;
				$image = '../'.$option['image'];
				if (isset($option['image']) && JFile::exists($image)) {
					$info = getimagesize($image);
					$imghtml = '<img src="'.$image.'" title="'.$option['name'].'"'.$info[3].' /><br/>';
				}
				else {
					$imghtml = '<img/>';
				}				
				$html[]  = '<input id="'.$name.$i.'" type="checkbox" name="'.$name.'" value="'.$option['value'].'"'.$checked.' /><label for="'.$name.$i++.'">'.$imghtml.$option['name'].'</label>';
			}
			// workaround: if nothing is selected, the element is still being transfered
			$html[] = '<input type="hidden" name="'.$this->getControlName('check').'" value="1" />';
	
			return implode("\n", $html);
		}
		
		return JText::_("There are no options to choose from.");
	}

	/*
		Function: renderSubmission
			Renders the element in submission.

	   Parameters:
            $params - submission parameters

		Returns:
			String - html
	*/
	public function renderSubmission($params = array()) {
        return $this->edit();
	}
			
	/*
		Function: render
			Renders the element.

	   Parameters:
            $params - render parameter

		Returns:
			String - html
	*/
	public function render($params = array()) {
		// init vars
		$options_from_config = $this->config->get('option');
		$selected_options  = $this->get('option', array());
		
		// init display params
		$params            = $this->app->data->create($params);
		$showoptionname    = $params->get('showoptionname');
		$separated_by	   = $params->get('separated_by');
		
		// include assets css
		$application = $this->_item->getApplication()->getGroup();
		
		$path = $this->app->path->path('applications:'.$application.'/elements/graphibox/assets/css/graphibox.css');
		
		if (JFile::exists($path)) {	
			$this->app->document->addStylesheet($path);	
		} else {
			$this->app->document->addStylesheet('elements:graphibox/assets/css/graphibox.css');		
		}	
		
		$options = array();
		foreach ($options_from_config as $option) {
			if (in_array($option['value'], $selected_options)) {
				if ($showoptionname && isset($option['image']) && JFile::exists($option['image'])) {
					$info = getimagesize($option['image']);
					$options[] = '<div class="gbopt"><img src="'.$option['image'].'" title="'.$option['name'].'"'.$info[3].' /><br/><div style="text-align: center;">'.$option['name'].'</div></div>';					
				} elseif (!$showoptionname && isset($option['image']) && JFile::exists($option['image'])) {
					$info = getimagesize($option['image']);
					$options[] = '<div class="gbopt"><img src="'.$option['image'].'" title="'.$option['name'].'"'.$info[3].' /></div>';
				} else {
					$options[] = '<div class="gbopt">'.$option['name'].'</div>';
				}
							
			}
		}

		return $this->app->element->applySeparators($params['separated_by'], $options);

	}
	
	/*
		Function: loadLanguage
			Load elements language file.

		Returns:
			Void
	*/
	public function loadLanguage() {
		// init vars						
		$element = strtolower($this->getElementType());
		$path    = $this->app->path->path('elements:'.$element);
		$jlang   = $this->app->system->language;		
		// lets load first english, then joomla default standard, then user language
		$jlang->load('com_zoo.element.'.$element, $path, 'en-GB', true);
		$jlang->load('com_zoo.element.'.$element, $path, $jlang->getDefault(), true);
		$jlang->load('com_zoo.element.'.$element, $path, null, true);
	}
}
