<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Denis Smetannikov <denis@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');


$this->app->jbdebug->mark('template::filter::start');

$this->app->jblayout->setView($this);

if (!$this->app->jbcache->start()) {
    $this->app->jbwrapper->start();

    $reqElems = $this->app->jbrequest->getElements();
    $type     = $this->app->jbrequest->get('type');
    $appId    = $this->app->jbrequest->get('app_id');

    $requestHtml = $result = array();

    $juri    = new JUri($this->app->jbenv->getCurrentUrl());
    $baseUrl = $juri->toString(array('scheme', 'user', 'pass', 'host', 'port', 'path'));

    foreach ($reqElems as $elemId => $value) {
        $element  = $this->app->jbentity->getElement($elemId, $type, $appId);
        $_GETOrig = $_GET;

        if (is_array($value)) {

            if (isset($value['range']) && is_array($value['range'])) {
                $value = implode(', ', $value['range']);

            } else if (isset($value['range-date']) && is_array($value['range'])) {
                $value = implode(', ', $value['range-date']);

            } else if (is_array($value)) {
                $value = implode(', ', $value);
            }
        }

        $checkVal = trim(str_replace(', ', '', $value));
        if (strlen($checkVal) == 0) {
            continue;
        }

        if (isset($_GETOrig['e'][$elemId])) {
            unset($_GETOrig['e'][$elemId]);
        }

        $elemName   = $element->config->get('name');
        $removeHref = $baseUrl . '?' . http_build_query($_GETOrig);

        $requestHtml[] = '<div class="request-row">'
            . ' <span class="request-label">' . $elemName . ':</span>'
            . ' <span class="request-value">' . $value . '</span>'
            . ' <a href="' . $removeHref . '" class="request-remove"> </a>'
            . ' </div>';
    }

    if (!empty($requestHtml)) {
        echo '<div class="request-list">' . implode("\n ", $requestHtml) . '</div><div class="clr"></div>';
    }

    ?><h1 class="title"><?php echo JText::_('JBZOO_SEARCH_RESULT'); ?></h1><?php

    if ($this->items) {

        echo '<p>' . JText::_('JBZOO_FILTER_TOTAL_RESULT') . ': ' . $this->itemsCount . '</p>';

        // items
        echo $this->app->jblayout->render('items', $this->items);

        // pagination render
        echo $this->app->jblayout->render('pagination', $this->pagination, array('link' => $this->pagination_link));

    } else {
        echo $this->app->jbjoomla->renderPosition('jbzoo_price_filter');
        ?><p><?php echo JText::_('JBZOO_FILTER_ITEMS_NOT_FOUND'); ?></p><?php

    }

    $this->app->jbwrapper->end();
    $this->app->jbcache->stop();
}

$this->app->jbdebug->mark('template::filter::finish');
